/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.EncryptionInformation;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.widgets.KeyInformationWidget;
import com.ibm.ast.ws.security.ui.widgets.KeyStoreInformationWidget;
import com.ibm.ast.ws.security.ui.widgets.MessagePartsTableWidget;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class ConsumerEncryptionWidget
extends SimpleWidgetDataContributor {
    private KeyInformationWidget keyInfoWidget;
    private KeyStoreInformationWidget keyStoreInfoWidget;
    private Combo keyEncryptionMethod_;
    private Combo dataEncryptionMethod_;
    private EncryptionInformation encryptionInfo;
    private MessagePartsTableWidget messageParts;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = WSSecurityUIPlugin.getUiUtils();
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        Composite root = uiUtils.createComposite((Composite)scroller, 1);
        scroller.setContent((Control)root);
        Group group = uiUtils.createGroup(root, WSSecurityUIPlugin.getMessage("%LABEL_CONFIDENTIALITY_GROUP"), null, null);
        this.messageParts = new MessagePartsTableWidget();
        this.messageParts.addControls((Composite)group, statusListener);
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Group encryptionGroup = uiUtils.createGroup(root, WSSecurityUIPlugin.getMessage("%LABEL_ENC_GROUP"), null, null);
        encryptionGroup.setLayout((Layout)new GridLayout(2, false));
        this.keyEncryptionMethod_ = uiUtils.createCombo((Composite)encryptionGroup, ATKWASUIPlugin.getMessage((String)"%LABEL_KEY_ENCRYPTION_METHOD_ALGORITHM"), null, null, 2060);
        this.keyEncryptionMethod_.setItems(atkWasUiConstants.getEncryptionInfoKeyEncryptionMethods(false));
        this.dataEncryptionMethod_ = uiUtils.createCombo((Composite)encryptionGroup, ATKWASUIPlugin.getMessage((String)"%LABEL_DATA_ENCRYPTION_METHOD_ALGORITHM"), null, null, 2060);
        this.dataEncryptionMethod_.setItems(atkWasUiConstants.getEncryptionInfoDataEncryptionMethods(false));
        this.keyInfoWidget = new KeyInformationWidget(true);
        this.keyInfoWidget.addControls(root, statusListener);
        this.keyStoreInfoWidget = new KeyStoreInformationWidget();
        this.keyStoreInfoWidget.addControls(root, statusListener);
        Point size = root.computeSize(-1, -1);
        scroller.setMinSize(size);
        root.setSize(size);
        scroller.setLayoutData((Object)new GridData(1808));
        return this;
    }

    public IStatus getStatus() {
        IStatus finalStatus_ = this.messageParts.getStatus();
        if (finalStatus_ != null && finalStatus_.getSeverity() != 0) {
            return finalStatus_;
        }
        return this.keyStoreInfoWidget.getStatus();
    }

    public EncryptionInformation getEncryptionInfo() {
        this.encryptionInfo.setKeyInfo(this.keyInfoWidget.getKeyInfo());
        this.encryptionInfo.setKeyStore(this.keyStoreInfoWidget.getKeyStore());
        this.encryptionInfo.setMessageParts(this.messageParts.getMessageParts());
        this.encryptionInfo.setDataEncryptionMethod(this.dataEncryptionMethod_.getText());
        this.encryptionInfo.setKeyEncryptionMethod(this.keyEncryptionMethod_.getText());
        return this.encryptionInfo;
    }

    public void setEncryptionInfo(EncryptionInformation encryptionInfo) {
        this.encryptionInfo = encryptionInfo;
        this.keyInfoWidget.setKeyInfo(encryptionInfo.getKeyInfo());
        this.keyStoreInfoWidget.setKeyStore(encryptionInfo.getKeyStore());
        this.dataEncryptionMethod_.setText(encryptionInfo.getDataEncryptionMethod());
        this.keyEncryptionMethod_.setText(encryptionInfo.getKeyEncryptionMethod());
        this.messageParts.setMessageParts(encryptionInfo.getMessageParts());
    }

    public void setProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        if (facetedProject != null && WASRuntimeUtil.isWASv61Runtime((IRuntime)FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getRuntime()))) {
            this.messageParts.setKeywords(ATKWASUIConstants.getConfidentialityKeywords7());
        } else {
            this.messageParts.setKeywords(ATKWASUIConstants.getConfidentialityKeywords6());
        }
    }
}

