/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.PortQnameBinding;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.ServiceRef;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscext.impl.WscextFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wscommonext.RequiredSecurityToken;
import com.ibm.etools.webservice.wscommonext.SecurityToken;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseGeneratorServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SecureClientExtensionCommand
extends AbstractDataModelOperation {
    private IProject serviceProject;
    private String serviceName;
    private ServiceReferenceObject serviceReference;
    private WsextArtifactEdit serverArtifactEdit = null;
    private EList securityTokenList = null;
    private EList requiredSecurityTokenList = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            try {
                ServerServiceConfig serverServiceConfig = this.readServerExtension();
                if (serverServiceConfig != null) {
                    this.updateClientExtension(serverServiceConfig);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
                if (this.serverArtifactEdit != null) {
                    this.serverArtifactEdit.dispose();
                }
                return status;
            }
        }
        finally {
            if (this.serverArtifactEdit != null) {
                this.serverArtifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private ServerServiceConfig readServerExtension() {
        this.serverArtifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForRead((IProject)this.serviceProject);
        WsExtension wsext = this.serverArtifactEdit.getWsExtension();
        WsDescExt wsDescExt = null;
        PcBinding pcBinding = null;
        EList wsDescExts = wsext.getWsDescExt();
        int i = 0;
        while (i < wsDescExts.size()) {
            WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
            if (tmpWsDescExt.getWsDescNameLink() != null && this.serviceName.equals(tmpWsDescExt.getWsDescNameLink())) {
                wsDescExt = tmpWsDescExt;
                break;
            }
            ++i;
        }
        if (wsDescExt == null) {
            return null;
        }
        EList pcBnds = wsDescExt.getPcBinding();
        int i2 = 0;
        while (i2 < pcBnds.size()) {
            PcBinding pcBnd;
            pcBinding = pcBnd = (PcBinding)pcBnds.get(i2);
            ++i2;
        }
        if (pcBinding == null) {
            return null;
        }
        ServerServiceConfig serverserviceconfig = pcBinding.getServerServiceConfig();
        if (serverserviceconfig == null) {
            return null;
        }
        SecurityRequestConsumerServiceConfig secReqConServiceConfig = serverserviceconfig.getSecurityRequestConsumerServiceConfig();
        SecurityResponseGeneratorServiceConfig secResGenServiceConfig = serverserviceconfig.getSecurityResponseGeneratorServiceConfig();
        if (secReqConServiceConfig == null && secResGenServiceConfig == null) {
            return null;
        }
        return serverserviceconfig;
    }

    private void updateClientExtension(ServerServiceConfig serverServiceConfig) throws IOException {
        WscextArtifactEdit clientArtifactEdit = null;
        try {
            try {
                ClientServiceConfig clientServiceconfig;
                clientArtifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                WsClientExtension wscext = clientArtifactEdit.getWsClientExtension();
                WscextFactoryImpl wscextfactory = new WscextFactoryImpl();
                ServiceRef serviceRef = null;
                PortQnameBinding portQnameBinding = null;
                EList serviceRefs = null;
                serviceRefs = J2EEUtils.isEJBProject((IProject)this.serviceReference.getClientProject()) ? ((ComponentScopedRefs)wscext.getComponentScopedRefs().get(0)).getServiceRefs() : wscext.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    ServiceRef tmpSerRef = (ServiceRef)serviceRefs.get(i);
                    if (tmpSerRef.getServiceRefLink() != null && tmpSerRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = tmpSerRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscextfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int i2 = 0;
                while (i2 < portQnameBindings.size()) {
                    PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(i2);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQnameBinding = pqBnd;
                        break;
                    }
                    ++i2;
                }
                if (portQnameBinding == null) {
                    portQnameBinding = wscextfactory.createPortQnameBinding();
                    portQnameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQnameBinding);
                }
                if ((clientServiceconfig = portQnameBinding.getClientServiceConfig()) == null) {
                    clientServiceconfig = wscextfactory.createClientServiceConfig();
                    portQnameBinding.setClientServiceConfig(clientServiceconfig);
                }
                SecurityRequestConsumerServiceConfig secReqConServiceConfig = serverServiceConfig.getSecurityRequestConsumerServiceConfig();
                SecurityResponseGeneratorServiceConfig secResGenServiceConfig = serverServiceConfig.getSecurityResponseGeneratorServiceConfig();
                SecurityRequestGeneratorServiceConfig secReqGenServiceConfig = clientServiceconfig.getSecurityRequestGeneratorServiceConfig();
                if (secReqGenServiceConfig == null) {
                    secReqGenServiceConfig = wscextfactory.createSecurityRequestGeneratorServiceConfig();
                    clientServiceconfig.setSecurityRequestGeneratorServiceConfig(secReqGenServiceConfig);
                }
                if (secReqConServiceConfig != null) {
                    this.updateClientRequestGenerator(secReqConServiceConfig, secResGenServiceConfig, secReqGenServiceConfig);
                }
                this.securityTokenList = secReqGenServiceConfig.getSecurityToken();
                SecurityResponseConsumerServiceConfig secResConServiceConfig = clientServiceconfig.getSecurityResponseConsumerServiceConfig();
                if (secResConServiceConfig == null) {
                    secResConServiceConfig = wscextfactory.createSecurityResponseConsumerServiceConfig();
                    clientServiceconfig.setSecurityResponseConsumerServiceConfig(secResConServiceConfig);
                }
                if (secResGenServiceConfig != null) {
                    this.updateClientResponseConsumer(secResGenServiceConfig, secResConServiceConfig);
                }
                this.requiredSecurityTokenList = secResConServiceConfig.getRequiredSecurityToken();
                clientArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (clientArtifactEdit != null) {
                    clientArtifactEdit.dispose();
                }
            }
        }
        finally {
            if (clientArtifactEdit != null) {
                clientArtifactEdit.dispose();
            }
        }
    }

    private void updateClientRequestGenerator(SecurityRequestConsumerServiceConfig secReqConServiceConfig, SecurityResponseGeneratorServiceConfig secResGenServiceConfig, SecurityRequestGeneratorServiceConfig secReqGenServiceConfig) {
        Collection messageParts;
        WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
        EList jList = null;
        if (secResGenServiceConfig != null) {
            jList = secResGenServiceConfig.getConfidentiality();
        }
        EList iList = secReqConServiceConfig.getRequiredConfidentiality();
        int i = 0;
        while (i < iList.size()) {
            Confidentiality serverConfidentiality = iList.size() == jList.size() ? (Confidentiality)jList.get(i) : null;
            RequiredConfidentiality requiredConfidentiality = (RequiredConfidentiality)iList.get(i);
            if (requiredConfidentiality != null) {
                Confidentiality confidentiality = wscommonextfactory.createConfidentiality();
                confidentiality.setName(requiredConfidentiality.getName());
                if (serverConfidentiality != null) {
                    confidentiality.setOrder(serverConfidentiality.getOrder());
                } else {
                    confidentiality.setOrder(Integer.toString(i + 1));
                }
                messageParts = EcoreUtil.copyAll((Collection)requiredConfidentiality.getMessageParts());
                confidentiality.getMessageParts().addAll(messageParts);
                secReqGenServiceConfig.getConfidentiality().add((Object)confidentiality);
            }
            ++i;
        }
        jList = null;
        if (secResGenServiceConfig != null) {
            jList = secResGenServiceConfig.getIntegrity();
        }
        iList = secReqConServiceConfig.getRequiredIntegrity();
        i = 0;
        while (i < iList.size()) {
            Integrity serverIntegrity = iList.size() == jList.size() ? (Integrity)jList.get(i) : null;
            RequiredIntegrity requiredIntegrity = (RequiredIntegrity)iList.get(i);
            if (requiredIntegrity != null) {
                Integrity integrity = wscommonextfactory.createIntegrity();
                integrity.setName(requiredIntegrity.getName());
                if (serverIntegrity != null) {
                    integrity.setOrder(serverIntegrity.getOrder());
                } else {
                    integrity.setOrder(Integer.toString(i + 1));
                }
                messageParts = EcoreUtil.copyAll((Collection)requiredIntegrity.getMessageParts());
                integrity.getMessageParts().addAll(messageParts);
                secReqGenServiceConfig.getIntegrity().add((Object)integrity);
            }
            ++i;
        }
        iList = secReqConServiceConfig.getRequiredSecurityToken();
        i = 0;
        while (i < iList.size()) {
            RequiredSecurityToken requiredSecurityToken = (RequiredSecurityToken)iList.get(i);
            if (requiredSecurityToken != null) {
                SecurityToken securityToken = wscommonextfactory.createSecurityToken();
                securityToken.setName(requiredSecurityToken.getName());
                securityToken.setUri(requiredSecurityToken.getUri());
                securityToken.setLocalName(requiredSecurityToken.getLocalName());
                secReqGenServiceConfig.getSecurityToken().add((Object)securityToken);
            }
            ++i;
        }
    }

    private void updateClientResponseConsumer(SecurityResponseGeneratorServiceConfig secResGenServiceConfig, SecurityResponseConsumerServiceConfig secResConServiceConfig) {
        Collection messageParts;
        WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
        EList iList = secResGenServiceConfig.getConfidentiality();
        int i = 0;
        while (i < iList.size()) {
            Confidentiality confidentiality = (Confidentiality)iList.get(i);
            if (confidentiality != null) {
                RequiredConfidentiality requiredConfidentiality = wscommonextfactory.createRequiredConfidentiality();
                requiredConfidentiality.setName(confidentiality.getName());
                requiredConfidentiality.setUsage(UsageType.REQUIRED_LITERAL);
                messageParts = EcoreUtil.copyAll((Collection)confidentiality.getMessageParts());
                requiredConfidentiality.getMessageParts().addAll(messageParts);
                secResConServiceConfig.getRequiredConfidentiality().add((Object)requiredConfidentiality);
            }
            ++i;
        }
        iList = secResGenServiceConfig.getIntegrity();
        i = 0;
        while (i < iList.size()) {
            Integrity integrity = (Integrity)iList.get(i);
            if (integrity != null) {
                RequiredIntegrity requiredIntegrity = wscommonextfactory.createRequiredIntegrity();
                requiredIntegrity.setName(integrity.getName());
                requiredIntegrity.setUsage(UsageType.REQUIRED_LITERAL);
                messageParts = EcoreUtil.copyAll((Collection)integrity.getMessageParts());
                requiredIntegrity.getMessageParts().addAll(messageParts);
                secResConServiceConfig.getRequiredIntegrity().add((Object)requiredIntegrity);
            }
            ++i;
        }
        iList = secResGenServiceConfig.getSecurityToken();
        i = 0;
        while (i < iList.size()) {
            SecurityToken securityToken = (SecurityToken)iList.get(i);
            if (securityToken != null) {
                RequiredSecurityToken requiredSecurityToken = wscommonextfactory.createRequiredSecurityToken();
                requiredSecurityToken.setName(securityToken.getName());
                requiredSecurityToken.setUri(securityToken.getUri());
                requiredSecurityToken.setLocalName(securityToken.getLocalName());
                secResConServiceConfig.getRequiredSecurityToken().add((Object)requiredSecurityToken);
            }
            ++i;
        }
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setServiceReference(ServiceReferenceObject serviceReference) {
        this.serviceReference = serviceReference;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public EList getSecurityTokenList() {
        return this.securityTokenList;
    }

    public EList getRequiredSecurityTokenList() {
        return this.requiredSecurityTokenList;
    }
}

