/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.KeyStoreInformation;
import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.common.TokenCertificate;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseGeneratorBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.impl.WscbndFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.JAASConfig;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.RequiredSecurityToken;
import com.ibm.etools.webservice.wscommonext.SecurityToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SecureClientBindingCommand
extends AbstractDataModelOperation {
    private IProject serviceProject;
    private String serviceName;
    private ServiceReferenceObject serviceReference;
    private WsbndArtifactEdit serverArtifactEdit = null;
    private EList securityTokenList = null;
    private EList requiredSecurityTokenList = null;
    private ArrayList clientGenEncrypTokenNames = new ArrayList();
    private ArrayList clientGenEncrypKeyLocator = new ArrayList();
    private ArrayList clientConEncrypKeyLocator = new ArrayList();
    private KeyStoreInformation callbackKeyStore;
    private KeyStoreInformation trustAnchorKeyStore;
    private KeyStoreInformation genEncKeyLocator;
    private KeyStoreInformation conEncKeyLocator;
    private TokenCertificate certificate;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            try {
                PCBinding pcBinding = this.readServerBinding();
                if (pcBinding != null) {
                    this.updateClientBinding(pcBinding);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
                if (this.serverArtifactEdit != null) {
                    this.serverArtifactEdit.dispose();
                }
                return status;
            }
        }
        finally {
            if (this.serverArtifactEdit != null) {
                this.serverArtifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private PCBinding readServerBinding() {
        this.serverArtifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)this.serviceProject);
        WSBinding wsbnd = this.serverArtifactEdit.getWSBinding();
        WSDescBinding wsDescBinding = null;
        PCBinding pcBinding = null;
        EList wscbindings = wsbnd.getWsdescBindings();
        int i = 0;
        while (i < wscbindings.size()) {
            WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
            if (wsDscBnd.getWsDescNameLink() != null && this.serviceName.equals(wsDscBnd.getWsDescNameLink())) {
                wsDescBinding = wsDscBnd;
                break;
            }
            ++i;
        }
        if (wsDescBinding == null) {
            return null;
        }
        EList pcBindings = wsDescBinding.getPcBindings();
        int j = 0;
        while (j < pcBindings.size()) {
            PCBinding pcBnd;
            pcBinding = pcBnd = (PCBinding)pcBindings.get(j);
            ++j;
        }
        if (pcBinding == null) {
            return null;
        }
        if (pcBinding.getSecurityRequestConsumerBindingConfig() == null && pcBinding.getSecurityResponseGeneratorBindingConfig() == null) {
            return null;
        }
        return pcBinding;
    }

    private void updateClientBinding(PCBinding pcBinding) throws IOException {
        WscbndArtifactEdit clientArtifactEdit = null;
        try {
            try {
                SecurityResponseGeneratorBindingConfig secResGenBndConfig;
                SecurityResponseConsumerBindingConfig secResConBndConfig;
                SecurityRequestConsumerBindingConfig secReqConBndConfig;
                SecurityRequestGeneratorBindingConfig secReqGenBndConfig;
                clientArtifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                ClientBinding wscbnd = clientArtifactEdit.getClientBinding();
                WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();
                ServiceRef serviceRef = null;
                PortQnameBinding portQNameBinding = null;
                EList serviceRefs = null;
                serviceRefs = J2EEUtils.isEJBProject((IProject)this.serviceReference.getClientProject()) ? ((ComponentScopedRefs)wscbnd.getComponentScopedRefs().get(0)).getServiceRefs() : wscbnd.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
                    if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = serRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscbndfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int j = 0;
                while (j < portQnameBindings.size()) {
                    PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQNameBinding = pqBnd;
                        break;
                    }
                    ++j;
                }
                if (portQNameBinding == null) {
                    portQNameBinding = wscbndfactory.createPortQnameBinding();
                    portQNameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQNameBinding);
                }
                if ((secReqGenBndConfig = portQNameBinding.getSecurityRequestGeneratorBindingConfig()) == null) {
                    secReqGenBndConfig = wscbndfactory.createSecurityRequestGeneratorBindingConfig();
                    portQNameBinding.setSecurityRequestGeneratorBindingConfig(secReqGenBndConfig);
                }
                if ((secReqConBndConfig = pcBinding.getSecurityRequestConsumerBindingConfig()) != null) {
                    this.updateClientRequestGenerator(secReqConBndConfig, secReqGenBndConfig);
                }
                if ((secResConBndConfig = portQNameBinding.getSecurityResponseConsumerBindingConfig()) == null) {
                    secResConBndConfig = wscbndfactory.createSecurityResponseConsumerBindingConfig();
                    portQNameBinding.setSecurityResponseConsumerBindingConfig(secResConBndConfig);
                }
                if ((secResGenBndConfig = pcBinding.getSecurityResponseGeneratorBindingConfig()) != null) {
                    this.updateClientResponseConsumer(secResGenBndConfig, secResConBndConfig);
                }
                clientArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (clientArtifactEdit != null) {
                    clientArtifactEdit.dispose();
                }
            }
        }
        finally {
            if (clientArtifactEdit != null) {
                clientArtifactEdit.dispose();
            }
        }
    }

    private void updateClientRequestGenerator(SecurityRequestConsumerBindingConfig secReqConBndConfig, SecurityRequestGeneratorBindingConfig secReqGenBndConfig) {
        WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
        WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();
        Collection encryptionInfos = EcoreUtil.copyAll((Collection)secReqConBndConfig.getEncryptionInfo());
        secReqGenBndConfig.getEncryptionInfo().addAll(encryptionInfos);
        Collection signingInfos = EcoreUtil.copyAll((Collection)secReqConBndConfig.getSigningInfo());
        secReqGenBndConfig.getSigningInfo().addAll(signingInfos);
        EList iList = secReqConBndConfig.getKeyInfo();
        int i = 0;
        while (i < iList.size()) {
            KeyInfo serverKeyInfo = (KeyInfo)iList.get(i);
            if (serverKeyInfo != null) {
                boolean foundEncryptionKeyInfo = false;
                EList encrypInfos = secReqConBndConfig.getEncryptionInfo();
                int k = 0;
                while (k < encrypInfos.size()) {
                    EncryptionInfo encrypInfo = (EncryptionInfo)encrypInfos.get(k);
                    EncryptionKeyInfo encryptionKeyInfo = (EncryptionKeyInfo)encrypInfo.getEncryptionKeyInfo().get(0);
                    if (encryptionKeyInfo.getKeyinfoRef().equals(serverKeyInfo.getName())) {
                        if (serverKeyInfo.getTokenReference() != null) {
                            this.clientGenEncrypTokenNames.add(serverKeyInfo.getTokenReference().getTokenRef());
                        }
                        this.clientGenEncrypKeyLocator.add(serverKeyInfo.getKeyLocatorMapping().getLocatorRef());
                        foundEncryptionKeyInfo = true;
                    }
                    ++k;
                }
                KeyInfo clientKeyInfo = wscommonbndfactory.createKeyInfo();
                clientKeyInfo.setType(serverKeyInfo.getType());
                clientKeyInfo.setName(serverKeyInfo.getName());
                clientKeyInfo.setClassname(serverKeyInfo.getClassname().replaceAll("Consumer", "Generator"));
                if (serverKeyInfo.getKeyLocatorMapping() != null) {
                    clientKeyInfo.setKeyLocatorMapping((KeyLocatorMapping)EcoreUtil.copy((EObject)serverKeyInfo.getKeyLocatorMapping()));
                    if (!foundEncryptionKeyInfo && this.callbackKeyStore.getKey() != null) {
                        clientKeyInfo.getKeyLocatorMapping().setKeynameRef(this.callbackKeyStore.getKey().getName());
                    }
                }
                if (serverKeyInfo.getTokenReference() != null && !foundEncryptionKeyInfo) {
                    clientKeyInfo.setTokenReference((TokenReference)EcoreUtil.copy((EObject)serverKeyInfo.getTokenReference()));
                }
                if (serverKeyInfo.getProperties() != null) {
                    clientKeyInfo.getProperties().addAll(EcoreUtil.copyAll((Collection)serverKeyInfo.getProperties()));
                }
                secReqGenBndConfig.getKeyInfo().add((Object)clientKeyInfo);
            }
            ++i;
        }
        iList = secReqConBndConfig.getKeyLocator();
        i = 0;
        while (i < iList.size()) {
            KeyLocator serverKeyLocator = (KeyLocator)iList.get(i);
            if (serverKeyLocator != null) {
                KeyStore keyStore;
                boolean foundEncryptionKeyLocator = false;
                int k = 0;
                while (k < this.clientGenEncrypKeyLocator.size()) {
                    if (serverKeyLocator.getName().equals(this.clientGenEncrypKeyLocator.get(k))) {
                        foundEncryptionKeyLocator = true;
                    }
                    ++k;
                }
                KeyLocator clientKeyLocator = wscommonbndfactory.createKeyLocator();
                clientKeyLocator.setName(serverKeyLocator.getName());
                clientKeyLocator.setClassname("com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator");
                if (foundEncryptionKeyLocator) {
                    if (this.genEncKeyLocator != null) {
                        keyStore = wscommonbndfactory.createKeyStore();
                        keyStore.setStorepass(this.genEncKeyLocator.getKeyStoreStorePass());
                        keyStore.setPath(this.genEncKeyLocator.getKeyStorePath());
                        keyStore.setType(this.genEncKeyLocator.getKeyStoreType());
                        clientKeyLocator.setKeyStore(keyStore);
                    }
                    if (serverKeyLocator.getKeys() != null) {
                        clientKeyLocator.getKeys().addAll(EcoreUtil.copyAll((Collection)serverKeyLocator.getKeys()));
                        EList clientKeyInfoList = secReqGenBndConfig.getKeyInfo();
                        int l = 0;
                        while (l < clientKeyInfoList.size()) {
                            KeyInfo clientKeyInfo = (KeyInfo)clientKeyInfoList.get(l);
                            if (clientKeyInfo.getKeyLocatorMapping().getLocatorRef().equals(clientKeyLocator.getName())) {
                                Key firstKey = (Key)clientKeyLocator.getKeys().get(0);
                                clientKeyInfo.getKeyLocatorMapping().setKeynameRef(firstKey.getName());
                            }
                            ++l;
                        }
                    }
                } else if (this.callbackKeyStore != null) {
                    keyStore = wscommonbndfactory.createKeyStore();
                    keyStore.setStorepass(this.callbackKeyStore.getKeyStoreStorePass());
                    keyStore.setPath(this.callbackKeyStore.getKeyStorePath());
                    keyStore.setType(this.callbackKeyStore.getKeyStoreType());
                    clientKeyLocator.setKeyStore(keyStore);
                    if (this.callbackKeyStore.getKey() != null) {
                        Key key = wscommonbndfactory.createKey();
                        key.setAlias(this.callbackKeyStore.getKey().getAlias());
                        key.setKeypass(this.callbackKeyStore.getKey().getKeypass());
                        key.setName(this.callbackKeyStore.getKey().getName());
                        clientKeyLocator.getKeys().add((Object)key);
                    }
                }
                if (serverKeyLocator.getProperties() != null) {
                    clientKeyLocator.getProperties().addAll(EcoreUtil.copyAll((Collection)serverKeyLocator.getProperties()));
                }
                secReqGenBndConfig.getKeyLocator().add((Object)clientKeyLocator);
            }
            ++i;
        }
        int usernameTokenCount = 0;
        iList = secReqConBndConfig.getTokenConsumer();
        int i2 = 0;
        while (i2 < iList.size()) {
            block30: {
                TokenConsumer tokenConsumer = (TokenConsumer)iList.get(i2);
                if (tokenConsumer != null) {
                    int k = 0;
                    while (k < this.clientGenEncrypTokenNames.size()) {
                        if (!tokenConsumer.getName().equals(this.clientGenEncrypTokenNames.get(k))) {
                            ++k;
                            continue;
                        }
                        break block30;
                    }
                    TokenGenerator tokenGenerator = wscommonbndfactory.createTokenGenerator();
                    tokenGenerator.setName(tokenConsumer.getName());
                    tokenGenerator.setClassname(tokenConsumer.getClassname().replaceAll("Consumer", "Generator"));
                    if (tokenConsumer.getValueType() != null) {
                        tokenGenerator.setValueType((ValueType)EcoreUtil.copy((EObject)tokenConsumer.getValueType()));
                    }
                    CallbackHandler callbackHandler = wscommonbndfactory.createCallbackHandler();
                    String className = tokenGenerator.getClassname();
                    String callBackHandlerClassName = className.equals("com.ibm.wsspi.wssecurity.token.UsernameTokenGenerator") ? "com.ibm.wsspi.wssecurity.auth.callback.GUIPromptCallbackHandler" : (className.equals("com.ibm.wsspi.wssecurity.token.LTPATokenGenerator") ? "com.ibm.wsspi.wssecurity.auth.callback.LTPATokenCallbackHandler" : "com.ibm.wsspi.wssecurity.auth.callback.X509CallbackHandler");
                    callbackHandler.setClassname(callBackHandlerClassName);
                    if (this.callbackKeyStore != null && !className.equals("com.ibm.wsspi.wssecurity.token.UsernameTokenGenerator")) {
                        KeyStore keyStore = wscommonbndfactory.createKeyStore();
                        keyStore.setStorepass(this.callbackKeyStore.getKeyStoreStorePass());
                        keyStore.setPath(this.callbackKeyStore.getKeyStorePath());
                        keyStore.setType(this.callbackKeyStore.getKeyStoreType());
                        callbackHandler.setKeyStore(keyStore);
                        if (this.callbackKeyStore.getKey() != null) {
                            Key key = wscommonbndfactory.createKey();
                            key.setAlias(this.callbackKeyStore.getKey().getAlias());
                            key.setKeypass(this.callbackKeyStore.getKey().getKeypass());
                            key.setName(this.callbackKeyStore.getKey().getName());
                            callbackHandler.getKey().add((Object)key);
                        }
                    }
                    BasicAuth basicAuth = wscbndfactory.createBasicAuth();
                    callbackHandler.setBasicAuth(basicAuth);
                    tokenGenerator.setCallbackHandler(callbackHandler);
                    if (this.securityTokenList != null && className.equals("com.ibm.wsspi.wssecurity.token.UsernameTokenGenerator")) {
                        SecurityToken securityToken = (SecurityToken)this.securityTokenList.get(usernameTokenCount);
                        ++usernameTokenCount;
                        PartReference partReference = wscommonbndfactory.createPartReference();
                        partReference.setPart(securityToken.getName());
                        tokenGenerator.setPartReference(partReference);
                    }
                    secReqGenBndConfig.getTokenGenerator().add((Object)tokenGenerator);
                }
            }
            ++i2;
        }
    }

    private void updateClientResponseConsumer(SecurityResponseGeneratorBindingConfig secResGenBndConfig, SecurityResponseConsumerBindingConfig secResConBndConfig) {
        WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
        Collection encryptionInfos = EcoreUtil.copyAll((Collection)secResGenBndConfig.getEncryptionInfo());
        secResConBndConfig.getEncryptionInfo().addAll(encryptionInfos);
        Collection signingInfos = EcoreUtil.copyAll((Collection)secResGenBndConfig.getSigningInfo());
        secResConBndConfig.getSigningInfo().addAll(signingInfos);
        EList iList = secResGenBndConfig.getKeyInfo();
        int i = 0;
        while (i < iList.size()) {
            KeyInfo serverKeyInfo = (KeyInfo)iList.get(i);
            if (serverKeyInfo != null) {
                EList encrypInfos = secResGenBndConfig.getEncryptionInfo();
                int k = 0;
                while (k < encrypInfos.size()) {
                    EncryptionInfo encrypInfo = (EncryptionInfo)encrypInfos.get(k);
                    EncryptionKeyInfo encryptionKeyInfo = (EncryptionKeyInfo)encrypInfo.getEncryptionKeyInfo().get(0);
                    if (encryptionKeyInfo.getKeyinfoRef().equals(serverKeyInfo.getName())) {
                        this.clientConEncrypKeyLocator.add(serverKeyInfo.getKeyLocatorMapping().getLocatorRef());
                    }
                    ++k;
                }
                KeyInfo clientKeyInfo = wscommonbndfactory.createKeyInfo();
                clientKeyInfo.setType(serverKeyInfo.getType());
                clientKeyInfo.setName(serverKeyInfo.getName());
                clientKeyInfo.setClassname(serverKeyInfo.getClassname().replaceAll("Generator", "Consumer"));
                if (serverKeyInfo.getKeyLocatorMapping() != null) {
                    clientKeyInfo.setKeyLocatorMapping((KeyLocatorMapping)EcoreUtil.copy((EObject)serverKeyInfo.getKeyLocatorMapping()));
                    clientKeyInfo.getKeyLocatorMapping().setKeynameRef(null);
                }
                if (serverKeyInfo.getTokenReference() != null) {
                    clientKeyInfo.setTokenReference((TokenReference)EcoreUtil.copy((EObject)serverKeyInfo.getTokenReference()));
                }
                if (serverKeyInfo.getProperties() != null) {
                    clientKeyInfo.getProperties().addAll(EcoreUtil.copyAll((Collection)serverKeyInfo.getProperties()));
                }
                secResConBndConfig.getKeyInfo().add((Object)clientKeyInfo);
            }
            ++i;
        }
        iList = secResGenBndConfig.getKeyLocator();
        i = 0;
        while (i < iList.size()) {
            KeyLocator serverKeyLocator = (KeyLocator)iList.get(i);
            if (serverKeyLocator != null) {
                boolean foundEncryptionKeyLocator = false;
                int k = 0;
                while (k < this.clientConEncrypKeyLocator.size()) {
                    if (serverKeyLocator.getName().equals(this.clientConEncrypKeyLocator.get(k))) {
                        foundEncryptionKeyLocator = true;
                    }
                    ++k;
                }
                KeyLocator clientKeyLocator = wscommonbndfactory.createKeyLocator();
                clientKeyLocator.setName(serverKeyLocator.getName());
                if (foundEncryptionKeyLocator) {
                    clientKeyLocator.setClassname("com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator");
                    if (this.conEncKeyLocator != null) {
                        KeyStore keyStore = wscommonbndfactory.createKeyStore();
                        keyStore.setStorepass(this.conEncKeyLocator.getKeyStoreStorePass());
                        keyStore.setPath(this.conEncKeyLocator.getKeyStorePath());
                        keyStore.setType(this.conEncKeyLocator.getKeyStoreType());
                        clientKeyLocator.setKeyStore(keyStore);
                    }
                    if (serverKeyLocator.getKeys() != null) {
                        clientKeyLocator.getKeys().addAll(EcoreUtil.copyAll((Collection)serverKeyLocator.getKeys()));
                    }
                } else {
                    clientKeyLocator.setClassname("com.ibm.wsspi.wssecurity.keyinfo.X509TokenKeyLocator");
                }
                if (serverKeyLocator.getProperties() != null) {
                    clientKeyLocator.getProperties().addAll(EcoreUtil.copyAll((Collection)serverKeyLocator.getProperties()));
                }
                secResConBndConfig.getKeyLocator().add((Object)clientKeyLocator);
            }
            ++i;
        }
        iList = secResGenBndConfig.getTokenGenerator();
        i = 0;
        while (i < iList.size()) {
            TokenGenerator tokenGenerator = (TokenGenerator)iList.get(i);
            if (tokenGenerator != null) {
                TokenConsumer tokenConsumer = wscommonbndfactory.createTokenConsumer();
                tokenConsumer.setName(tokenGenerator.getName());
                tokenConsumer.setClassname(tokenGenerator.getClassname().replaceAll("Generator", "Consumer"));
                if (tokenGenerator.getValueType() != null) {
                    tokenConsumer.setValueType((ValueType)EcoreUtil.copy((EObject)tokenGenerator.getValueType()));
                }
                JAASConfig jAASConfig = wscommonbndfactory.createJAASConfig();
                jAASConfig.setConfigName("system.wssecurity.X509BST");
                tokenConsumer.setJAASConfig(jAASConfig);
                CertPathSettings certPathSettings = wscommonbndfactory.createCertPathSettings();
                if (this.trustAnchorKeyStore == null) {
                    TrustAnyCertificate trustAnyCertificate = wscommonbndfactory.createTrustAnyCertificate();
                    certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
                } else {
                    TrustAnchor trustAnchor = wscommonbndfactory.createTrustAnchor();
                    trustAnchor.setKeyStore(this.trustAnchorKeyStore.getKeyStore());
                    trustAnchor.setName("TtrustAnchor_" + i);
                    secResConBndConfig.getTrustAnchor().add((Object)trustAnchor);
                    TrustAnchorRef trustRef = wscommonbndfactory.createTrustAnchorRef();
                    trustRef.setRef(trustAnchor.getName());
                    certPathSettings.setTrustAnchorRef(trustRef);
                    if (this.certificate != null) {
                        CertStoreList list = wscommonbndfactory.createCertStoreList();
                        CollectionCertStore certStore = wscommonbndfactory.createCollectionCertStore();
                        certStore.setProvider(this.certificate.getProvider());
                        certStore.setName(this.certificate.getCertName());
                        X509Certificate x509Cert = wscommonbndfactory.createX509Certificate();
                        x509Cert.setPath(this.certificate.getPath());
                        certStore.getX509Certificates().add((Object)x509Cert);
                        list.getCollectionCertStores().add((Object)certStore);
                        secResConBndConfig.setCertStoreList(list);
                        CertStoreRef certRef = wscommonbndfactory.createCertStoreRef();
                        certRef.setRef(certStore.getName());
                        certPathSettings.setCertStoreRef(certRef);
                        CertStoreRef certStoreRef = wscommonbndfactory.createCertStoreRef();
                        certStoreRef.setRef(certStore.getName());
                        certPathSettings.setCertStoreRef(certStoreRef);
                    }
                }
                tokenConsumer.setCertPathSettings(certPathSettings);
                if (this.requiredSecurityTokenList != null && this.requiredSecurityTokenList.size() > i) {
                    RequiredSecurityToken requiredSecurityToken = (RequiredSecurityToken)this.requiredSecurityTokenList.get(i);
                    PartReference partReference = wscommonbndfactory.createPartReference();
                    partReference.setName(requiredSecurityToken.getName());
                    tokenConsumer.setPartReference(partReference);
                }
                secResConBndConfig.getTokenConsumer().add((Object)tokenConsumer);
            }
            ++i;
        }
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setServiceReference(ServiceReferenceObject serviceReference) {
        this.serviceReference = serviceReference;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setSecurityTokenList(EList securityTokenList) {
        this.securityTokenList = securityTokenList;
    }

    public void setRequiredSecurityTokenList(EList requiredSecurityTokenList) {
        this.requiredSecurityTokenList = requiredSecurityTokenList;
    }

    public void setCallbackKeyStore(KeyStoreInformation callbackKeyStore) {
        this.callbackKeyStore = callbackKeyStore;
    }

    public void setCertificate(TokenCertificate certificate) {
        this.certificate = certificate;
    }

    public void setTrustAnchorKeyStore(KeyStoreInformation trustAnchorKeyStore) {
        this.trustAnchorKeyStore = trustAnchorKeyStore;
    }

    public void setConsumerKeyStore(KeyStoreInformation conEncKeyLocator) {
        this.conEncKeyLocator = conEncKeyLocator;
    }

    public void setGeneratorKeyStore(KeyStoreInformation genEncKeyLocator) {
        this.genEncKeyLocator = genEncKeyLocator;
    }
}

