/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseGeneratorServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.etools.webservice.wsext.impl.WsextFactoryImpl;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CloningServerExtensionCommand
extends AbstractDataModelOperation {
    private String sourcePCName = null;
    private String targetPCName = null;
    private String sourceServiceName;
    private String targetServiceName;
    private IProject sourceProject;
    private IProject targetProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            this.sourcePCName = this.getNamesFromWebServicesXML(this.sourceProject, this.sourceServiceName);
            this.targetPCName = this.getNamesFromWebServicesXML(this.targetProject, this.targetServiceName);
            ServerServiceConfig serverServiceConfig = this.readSourceExtension();
            if (serverServiceConfig != null) {
                this.updateTargetExtension(serverServiceConfig);
            }
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServerServiceConfig readSourceExtension() {
        WsextArtifactEdit sourceArtifactEdit = null;
        try {
            sourceArtifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForRead((IProject)this.sourceProject);
            WsExtension wsext = sourceArtifactEdit.getWsExtension();
            WsDescExt wsDescExt = null;
            PcBinding pcBinding = null;
            EList wsDescExts = wsext.getWsDescExt();
            int i = 0;
            while (i < wsDescExts.size()) {
                WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
                if (tmpWsDescExt.getWsDescNameLink() != null && tmpWsDescExt.getWsDescNameLink().equalsIgnoreCase(this.sourceServiceName)) {
                    wsDescExt = tmpWsDescExt;
                    break;
                }
                ++i;
            }
            if (wsDescExt == null) {
                return null;
            }
            EList pcBnds = wsDescExt.getPcBinding();
            int i2 = 0;
            while (i2 < pcBnds.size()) {
                PcBinding pcBnd = (PcBinding)pcBnds.get(i2);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equalsIgnoreCase(this.sourcePCName)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++i2;
            }
            if (pcBinding == null) {
                return null;
            }
            ServerServiceConfig serverserviceconfig = pcBinding.getServerServiceConfig();
            if (serverserviceconfig == null) {
                return null;
            }
            SecurityRequestConsumerServiceConfig secReqConServiceConfig = serverserviceconfig.getSecurityRequestConsumerServiceConfig();
            SecurityResponseGeneratorServiceConfig secResGenServiceConfig = serverserviceconfig.getSecurityResponseGeneratorServiceConfig();
            if (secReqConServiceConfig == null && secResGenServiceConfig == null) {
                return null;
            }
            ServerServiceConfig serverServiceConfig = serverserviceconfig;
            return serverServiceConfig;
        }
        finally {
            if (sourceArtifactEdit != null) {
                sourceArtifactEdit.dispose();
            }
        }
    }

    private void updateTargetExtension(ServerServiceConfig serverServiceConfig) throws IOException {
        WsextArtifactEdit targetArtifactEdit = null;
        try {
            targetArtifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)this.targetProject);
            WsExtension wsext = targetArtifactEdit.getWsExtension();
            WsextFactoryImpl wsextfactory = new WsextFactoryImpl();
            WsDescExt wsDescExt = null;
            PcBinding pcBinding = null;
            EList wsDescExts = wsext.getWsDescExt();
            int i = 0;
            while (i < wsDescExts.size()) {
                WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
                if (tmpWsDescExt.getWsDescNameLink() != null && tmpWsDescExt.getWsDescNameLink().equals(this.targetServiceName)) {
                    wsDescExt = tmpWsDescExt;
                    break;
                }
                ++i;
            }
            if (wsDescExt == null) {
                wsDescExt = wsextfactory.createWsDescExt();
                wsDescExt.setWsDescNameLink(this.targetServiceName);
                wsext.getWsDescExt().add((Object)wsDescExt);
            }
            EList pcBnds = wsDescExt.getPcBinding();
            int i2 = 0;
            while (i2 < pcBnds.size()) {
                PcBinding pcBnd = (PcBinding)pcBnds.get(i2);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.targetPCName)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++i2;
            }
            if (pcBinding == null) {
                pcBinding = wsextfactory.createPcBinding();
                pcBinding.setPcNameLink(this.targetPCName);
                wsDescExt.getPcBinding().add((Object)pcBinding);
            }
            EObject newServerserviceconfig = EcoreUtil.copy((EObject)serverServiceConfig);
            pcBinding.setServerServiceConfig((ServerServiceConfig)newServerserviceconfig);
            targetArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (targetArtifactEdit != null) {
                targetArtifactEdit.dispose();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNamesFromWebServicesXML(IProject ddProject, String serviceName) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            EList wsDescriptions = webservices.getWebServiceDescriptions();
            if (wsDescriptions.size() < 1) {
                return null;
            }
            WebServiceDescription wsDescription = null;
            int i = 0;
            while (i < wsDescriptions.size()) {
                if (((WebServiceDescription)wsDescriptions.get(i)).getWebServiceDescriptionName().equals(serviceName)) {
                    wsDescription = (WebServiceDescription)wsDescriptions.get(i);
                }
                ++i;
            }
            EList portComponents = wsDescription.getPortComponents();
            if (portComponents.size() < 1) {
                return null;
            }
            PortComponent portComponent = (PortComponent)portComponents.get(0);
            String string = portComponent.getPortComponentName();
            return string;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public void setSourceProject(IProject sourceProject) {
        this.sourceProject = sourceProject;
    }

    public void setTargetProject(IProject targetProject) {
        this.targetProject = targetProject;
    }

    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    public void setTargetServiceName(String targetServiceName) {
        this.targetServiceName = targetServiceName;
    }
}

