/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CloningServerBindingCommand
extends AbstractDataModelOperation {
    private String sourcePCName = null;
    private String targetPCName = null;
    private String sourceServiceName;
    private String targetServiceName;
    private IProject sourceProject;
    private IProject targetProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            this.sourcePCName = this.getNamesFromWebServicesXML(this.sourceProject, this.sourceServiceName);
            this.targetPCName = this.getNamesFromWebServicesXML(this.targetProject, this.targetServiceName);
            PCBinding pcBinding = this.readSourceBinding();
            if (pcBinding != null) {
                this.updateTargetBinding(pcBinding);
            }
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PCBinding readSourceBinding() {
        WsbndArtifactEdit sourceArtifactEdit = null;
        try {
            sourceArtifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)this.sourceProject);
            WSBinding wsbnd = sourceArtifactEdit.getWSBinding();
            WSDescBinding wsDescBinding = null;
            PCBinding pcBinding = null;
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
            while (i < wscbindings.size()) {
                WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
                if (wsDscBnd.getWsDescNameLink() != null && wsDscBnd.getWsDescNameLink().equalsIgnoreCase(this.sourceServiceName)) {
                    wsDescBinding = wsDscBnd;
                    break;
                }
                ++i;
            }
            if (wsDescBinding == null) {
                return null;
            }
            EList pcBindings = wsDescBinding.getPcBindings();
            int j = 0;
            while (j < pcBindings.size()) {
                PCBinding pcBnd = (PCBinding)pcBindings.get(j);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.sourcePCName)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++j;
            }
            if (pcBinding == null) {
                return null;
            }
            if (pcBinding.getSecurityRequestConsumerBindingConfig() == null && pcBinding.getSecurityResponseGeneratorBindingConfig() == null) {
                return null;
            }
            PCBinding pCBinding = pcBinding;
            return pCBinding;
        }
        finally {
            if (sourceArtifactEdit != null) {
                sourceArtifactEdit.dispose();
            }
        }
    }

    private void updateTargetBinding(PCBinding pcBinding) throws IOException {
        WsbndArtifactEdit targetArtifactEdit = null;
        try {
            targetArtifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)this.targetProject);
            WSBinding wsbnd = targetArtifactEdit.getWSBinding();
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            WSDescBinding wsDescBinding = null;
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
            while (i < wscbindings.size()) {
                WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
                if (wsDscBnd.getWsDescNameLink() != null && wsDscBnd.getWsDescNameLink().equals(this.targetServiceName)) {
                    wsDescBinding = wsDscBnd;
                    break;
                }
                ++i;
            }
            if (wsDescBinding == null) {
                wsDescBinding = wsbndfactory.createWSDescBinding();
                wsDescBinding.setWsDescNameLink(this.targetServiceName);
                wsbnd.getWsdescBindings().add((Object)wsDescBinding);
            }
            EList pcBindings = wsDescBinding.getPcBindings();
            int j = 0;
            while (j < pcBindings.size()) {
                PCBinding pcBnd = (PCBinding)pcBindings.get(j);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.targetPCName)) {
                    wsDescBinding.getPcBindings().remove((Object)pcBnd);
                    break;
                }
                ++j;
            }
            EObject newPcBinding = EcoreUtil.copy((EObject)pcBinding);
            ((PCBinding)newPcBinding).setPcNameLink(this.targetPCName);
            wsDescBinding.getPcBindings().add((Object)((PCBinding)newPcBinding));
            targetArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (targetArtifactEdit != null) {
                targetArtifactEdit.dispose();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNamesFromWebServicesXML(IProject ddProject, String serviceName) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            EList wsDescriptions = webservices.getWebServiceDescriptions();
            if (wsDescriptions.size() < 1) {
                return null;
            }
            WebServiceDescription wsDescription = null;
            int i = 0;
            while (i < wsDescriptions.size()) {
                if (((WebServiceDescription)wsDescriptions.get(i)).getWebServiceDescriptionName().equals(serviceName)) {
                    wsDescription = (WebServiceDescription)wsDescriptions.get(i);
                }
                ++i;
            }
            EList portComponents = wsDescription.getPortComponents();
            if (portComponents.size() < 1) {
                return null;
            }
            PortComponent portComponent = (PortComponent)portComponents.get(0);
            String string = portComponent.getPortComponentName();
            return string;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public void setSourceProject(IProject sourceProject) {
        this.sourceProject = sourceProject;
    }

    public void setTargetProject(IProject targetProject) {
        this.targetProject = targetProject;
    }

    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    public void setTargetServiceName(String targetServiceName) {
        this.targetServiceName = targetServiceName;
    }
}

