/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.PortQnameBinding;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.ServiceRef;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscext.impl.WscextFactoryImpl;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CloningClientExtensionCommand
extends AbstractDataModelOperation {
    private ServiceReferenceObject targetServiceReference;
    private ServiceReferenceObject sourceServiceReference;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            ClientServiceConfig clientServiceConfig = this.readSourceExtension();
            if (clientServiceConfig != null) {
                this.updateTargetExtension(clientServiceConfig);
            }
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientServiceConfig readSourceExtension() {
        WscextArtifactEdit sourceArtifactEdit = null;
        try {
            sourceArtifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForRead((IProject)this.sourceServiceReference.getClientProject());
            WsClientExtension wscext = sourceArtifactEdit.getWsClientExtension();
            ServiceRef serviceRef = null;
            PortQnameBinding portQnameBinding = null;
            EList serviceRefs = wscext.getServiceRefs();
            int i = 0;
            while (i < serviceRefs.size()) {
                ServiceRef tmpSerRef = (ServiceRef)serviceRefs.get(i);
                if (tmpSerRef.getServiceRefLink() != null && tmpSerRef.getServiceRefLink().equals(this.sourceServiceReference.getServiceName())) {
                    serviceRef = tmpSerRef;
                    break;
                }
                ++i;
            }
            if (serviceRef == null) {
                return null;
            }
            EList portQnameBindings = serviceRef.getPortQnameBindings();
            int i2 = 0;
            while (i2 < portQnameBindings.size()) {
                PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(i2);
                if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.sourceServiceReference.getPortName())) {
                    portQnameBinding = pqBnd;
                    break;
                }
                ++i2;
            }
            if (portQnameBinding == null) {
                return null;
            }
            ClientServiceConfig clientServiceconfig = portQnameBinding.getClientServiceConfig();
            if (clientServiceconfig == null) {
                return null;
            }
            SecurityRequestGeneratorServiceConfig secReqGenServiceConfig = clientServiceconfig.getSecurityRequestGeneratorServiceConfig();
            SecurityResponseConsumerServiceConfig secResConServiceConfig = clientServiceconfig.getSecurityResponseConsumerServiceConfig();
            if (secReqGenServiceConfig == null && secResConServiceConfig == null) {
                return null;
            }
            ClientServiceConfig clientServiceConfig = clientServiceconfig;
            return clientServiceConfig;
        }
        finally {
            if (sourceArtifactEdit != null) {
                sourceArtifactEdit.dispose();
            }
        }
    }

    private void updateTargetExtension(ClientServiceConfig clientServiceConfig) throws IOException {
        WscextArtifactEdit targetArtifactEdit = null;
        try {
            targetArtifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.targetServiceReference.getClientProject());
            WsClientExtension wscext = targetArtifactEdit.getWsClientExtension();
            WscextFactoryImpl wscextfactory = new WscextFactoryImpl();
            ServiceRef serviceRef = null;
            PortQnameBinding portQnameBinding = null;
            EList serviceRefs = wscext.getServiceRefs();
            int i = 0;
            while (i < serviceRefs.size()) {
                ServiceRef tmpSerRef = (ServiceRef)serviceRefs.get(i);
                if (tmpSerRef.getServiceRefLink() != null && tmpSerRef.getServiceRefLink().equals(this.targetServiceReference.getServiceName())) {
                    serviceRef = tmpSerRef;
                    break;
                }
                ++i;
            }
            if (serviceRef == null) {
                serviceRef = wscextfactory.createServiceRef();
                serviceRef.setServiceRefLink(this.targetServiceReference.getServiceName());
                serviceRefs.add((Object)serviceRef);
            }
            EList portQnameBindings = serviceRef.getPortQnameBindings();
            int i2 = 0;
            while (i2 < portQnameBindings.size()) {
                PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(i2);
                if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.targetServiceReference.getPortName())) {
                    portQnameBinding = pqBnd;
                    break;
                }
                ++i2;
            }
            if (portQnameBinding == null) {
                portQnameBinding = wscextfactory.createPortQnameBinding();
                portQnameBinding.setPortQnameLocalNameLink(this.targetServiceReference.getPortName());
                serviceRef.getPortQnameBindings().add((Object)portQnameBinding);
            }
            EObject newClientServiceConfig = EcoreUtil.copy((EObject)clientServiceConfig);
            portQnameBinding.setClientServiceConfig((ClientServiceConfig)newClientServiceConfig);
            targetArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (targetArtifactEdit != null) {
                targetArtifactEdit.dispose();
            }
        }
    }

    public void setSourceServiceReference(ServiceReferenceObject sourceServiceReference) {
        this.sourceServiceReference = sourceServiceReference;
    }

    public void setTargetServiceReference(ServiceReferenceObject targetServiceReference) {
        this.targetServiceReference = targetServiceReference;
    }
}

