/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.impl.WscbndFactoryImpl;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CloningClientBindingCommand
extends AbstractDataModelOperation {
    private ServiceReferenceObject sourceServiceReference;
    private ServiceReferenceObject targetServiceReference;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            PortQnameBinding portQNameBinding = this.readSourceBinding();
            if (portQNameBinding != null) {
                this.updateTargetBinding(portQNameBinding);
            }
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PortQnameBinding readSourceBinding() {
        WscbndArtifactEdit sourceArtifactEdit = null;
        try {
            sourceArtifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForRead((IProject)this.sourceServiceReference.getClientProject());
            ClientBinding wscbnd = sourceArtifactEdit.getClientBinding();
            ServiceRef serviceRef = null;
            PortQnameBinding portQNameBinding = null;
            EList serviceRefs = wscbnd.getServiceRefs();
            int i = 0;
            while (i < serviceRefs.size()) {
                ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
                if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(this.sourceServiceReference.getServiceName())) {
                    serviceRef = serRef;
                    break;
                }
                ++i;
            }
            if (serviceRef == null) {
                return null;
            }
            EList portQnameBindings = serviceRef.getPortQnameBindings();
            int j = 0;
            while (j < portQnameBindings.size()) {
                PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
                if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.sourceServiceReference.getPortName())) {
                    portQNameBinding = pqBnd;
                    break;
                }
                ++j;
            }
            if (portQNameBinding == null) {
                return null;
            }
            SecurityRequestGeneratorBindingConfig secReqGenBndConfig = portQNameBinding.getSecurityRequestGeneratorBindingConfig();
            SecurityResponseConsumerBindingConfig secResConBndConfig = portQNameBinding.getSecurityResponseConsumerBindingConfig();
            if (secReqGenBndConfig == null && secResConBndConfig == null) {
                return null;
            }
            PortQnameBinding portQnameBinding = portQNameBinding;
            return portQnameBinding;
        }
        finally {
            if (sourceArtifactEdit != null) {
                sourceArtifactEdit.dispose();
            }
        }
    }

    private void updateTargetBinding(PortQnameBinding portQNameBinding) throws IOException {
        WscbndArtifactEdit targetArtifactEdit = null;
        try {
            targetArtifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.targetServiceReference.getClientProject());
            ClientBinding wscbnd = targetArtifactEdit.getClientBinding();
            WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();
            ServiceRef serviceRef = null;
            EList serviceRefs = wscbnd.getServiceRefs();
            int i = 0;
            while (i < serviceRefs.size()) {
                ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
                if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(this.targetServiceReference.getServiceName())) {
                    serviceRef = serRef;
                    break;
                }
                ++i;
            }
            if (serviceRef == null) {
                serviceRef = wscbndfactory.createServiceRef();
                serviceRef.setServiceRefLink(this.targetServiceReference.getServiceName());
                serviceRefs.add((Object)serviceRef);
            }
            EList portQnameBindings = serviceRef.getPortQnameBindings();
            int j = 0;
            while (j < portQnameBindings.size()) {
                PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
                if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.targetServiceReference.getPortName())) {
                    serviceRef.getPortQnameBindings().remove((Object)pqBnd);
                    break;
                }
                ++j;
            }
            EObject newPortQNameBinding = EcoreUtil.copy((EObject)portQNameBinding);
            ((PortQnameBinding)newPortQNameBinding).setPortQnameLocalNameLink(this.targetServiceReference.getPortName());
            serviceRef.getPortQnameBindings().add((Object)((PortQnameBinding)newPortQNameBinding));
            targetArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (targetArtifactEdit != null) {
                targetArtifactEdit.dispose();
            }
        }
    }

    public void setSourceServiceReference(ServiceReferenceObject sourceServiceReference) {
        this.sourceServiceReference = sourceServiceReference;
    }

    public void setTargetServiceReference(ServiceReferenceObject targetServiceReference) {
        this.targetServiceReference = targetServiceReference;
    }
}

