/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.MessagePartItem;
import com.ibm.ast.ws.security.ui.common.SignatureInformation;
import com.ibm.ast.ws.security.ui.common.SignedCertificateToken;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseGeneratorBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.JAASConfig;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseGeneratorServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.etools.webservice.wsext.impl.WsextFactoryImpl;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddServerSideSignatureCommand
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private final String IBM_WEBSERVICES_BND_XMI = "ibm-webservices-bnd.xmi";
    private final String IBM_WEBSERVICES_EXT_XMI = "ibm-webservices-ext.xmi";
    private String wsNameLink = null;
    private String pcNameLink = null;
    private String serviceName;
    private IProgressMonitor monitor;
    IPath ibmWebServicesXMLPath = null;
    IPath ibmWebServicesBndXMLPath = null;
    IPath ibmWebServicesExtXMLPath = null;
    private IProject serviceProject;
    private SignatureInformation consumerSignatureInfo;
    private SignatureInformation generatorSignatureInfo;
    private SignedCertificateToken tokenGenerator;
    private SignedCertificateToken tokenConsumer;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject wsXmlProject = this.serviceProject;
        this.monitor = monitor;
        this.getWSDDFilePath(wsXmlProject);
        if (this.ibmWebServicesXMLPath == null) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_WEBSERVICES_XML_NOT_FOUND"), null);
        }
        try {
            this.getNamesFromWebServicesXML(wsXmlProject);
            this.updateWsBndENC(wsXmlProject);
            this.updateWsExtENC(wsXmlProject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEBSERVICES_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNamesFromWebServicesXML(IProject ddProject) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            EList wsDescriptions = webservices.getWebServiceDescriptions();
            if (wsDescriptions.size() < 1) {
                return;
            }
            WebServiceDescription wsDescription = null;
            int i = 0;
            while (i < wsDescriptions.size()) {
                if (((WebServiceDescription)wsDescriptions.get(i)).getWebServiceDescriptionName().equals(this.serviceName)) {
                    wsDescription = (WebServiceDescription)wsDescriptions.get(i);
                }
                ++i;
            }
            this.wsNameLink = wsDescription.getWebServiceDescriptionName();
            EList portComponents = wsDescription.getPortComponents();
            if (portComponents.size() < 1) {
                return;
            }
            PortComponent portComponent = (PortComponent)portComponents.get(0);
            this.pcNameLink = portComponent.getPortComponentName();
            return;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtENC(IProject ddProject) {
        WsextArtifactEdit artifactEdit = null;
        try {
            SecurityRequestConsumerServiceConfig secReqConServiceConfig;
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ddProject);
            WsExtension wsext = artifactEdit.getWsExtension();
            WsextFactoryImpl wsextfactory = new WsextFactoryImpl();
            WsDescExt wsDescExt = null;
            PcBinding pcBinding = null;
            EList wsDescExts = wsext.getWsDescExt();
            int i = 0;
            while (i < wsDescExts.size()) {
                WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
                if (tmpWsDescExt.getWsDescNameLink() != null && tmpWsDescExt.getWsDescNameLink().equals(this.wsNameLink)) {
                    wsDescExt = tmpWsDescExt;
                    break;
                }
                ++i;
            }
            if (wsDescExt == null) {
                wsDescExt = wsextfactory.createWsDescExt();
                wsDescExt.setWsDescNameLink(this.wsNameLink);
                wsext.getWsDescExt().add((Object)wsDescExt);
            }
            EList pcBnds = wsDescExt.getPcBinding();
            int i2 = 0;
            while (i2 < pcBnds.size()) {
                PcBinding pcBnd = (PcBinding)pcBnds.get(i2);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.pcNameLink)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++i2;
            }
            if (pcBinding == null) {
                pcBinding = wsextfactory.createPcBinding();
                pcBinding.setPcNameLink(this.pcNameLink);
                wsDescExt.getPcBinding().add((Object)pcBinding);
            }
            WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
            ServerServiceConfig serverserviceconfig = pcBinding.getServerServiceConfig();
            if (serverserviceconfig == null) {
                serverserviceconfig = wsextfactory.createServerServiceConfig();
                pcBinding.setServerServiceConfig(serverserviceconfig);
            }
            if ((secReqConServiceConfig = serverserviceconfig.getSecurityRequestConsumerServiceConfig()) == null) {
                secReqConServiceConfig = wsextfactory.createSecurityRequestConsumerServiceConfig();
                serverserviceconfig.setSecurityRequestConsumerServiceConfig(secReqConServiceConfig);
            }
            RequiredIntegrity requiredIntegrity = wscommonextfactory.createRequiredIntegrity();
            requiredIntegrity.setName(this.consumerSignatureInfo.getId());
            requiredIntegrity.setUsage(UsageType.get((String)this.consumerSignatureInfo.getUsageType()));
            Vector parts = this.consumerSignatureInfo.getMessageParts();
            int i3 = 0;
            while (i3 < parts.size()) {
                MessageParts messagePart = wscommonextfactory.createMessageParts();
                MessagePartItem item = (MessagePartItem)parts.get(i3);
                messagePart.setDialect(item.getDialect());
                messagePart.setKeyword(item.getKeyword());
                requiredIntegrity.getMessageParts().add((Object)messagePart);
                ++i3;
            }
            secReqConServiceConfig.getRequiredIntegrity().add((Object)requiredIntegrity);
            SecurityResponseGeneratorServiceConfig secResGenServiceConfig = serverserviceconfig.getSecurityResponseGeneratorServiceConfig();
            if (secResGenServiceConfig == null) {
                secResGenServiceConfig = wsextfactory.createSecurityResponseGeneratorServiceConfig();
                serverserviceconfig.setSecurityResponseGeneratorServiceConfig(secResGenServiceConfig);
            }
            Integrity confidentiality = wscommonextfactory.createIntegrity();
            confidentiality.setName(this.generatorSignatureInfo.getId());
            confidentiality.setOrder(this.generatorSignatureInfo.getOrder());
            parts = this.generatorSignatureInfo.getMessageParts();
            int i4 = 0;
            while (i4 < parts.size()) {
                MessageParts messagePart = wscommonextfactory.createMessageParts();
                MessagePartItem item = (MessagePartItem)parts.get(i4);
                messagePart.setDialect(item.getDialect());
                messagePart.setKeyword(item.getKeyword());
                confidentiality.getMessageParts().add((Object)messagePart);
                ++i4;
            }
            secResGenServiceConfig.getIntegrity().add((Object)confidentiality);
            artifactEdit.saveIfNecessary(this.monitor);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsBndENC(IProject ddProject) {
        WsbndArtifactEdit artifactEdit = null;
        try {
            KeyStore keyStore;
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ddProject);
            WSBinding wsbnd = artifactEdit.getWSBinding();
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            WSDescBinding wsDescBinding = null;
            PCBinding pcBinding = null;
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
            while (i < wscbindings.size()) {
                WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
                if (wsDscBnd.getWsDescNameLink() != null && wsDscBnd.getWsDescNameLink().equals(this.wsNameLink)) {
                    wsDescBinding = wsDscBnd;
                    break;
                }
                ++i;
            }
            if (wsDescBinding == null) {
                wsDescBinding = wsbndfactory.createWSDescBinding();
                wsDescBinding.setWsDescNameLink(this.wsNameLink);
                wsbnd.getWsdescBindings().add((Object)wsDescBinding);
            }
            EList pcBindings = wsDescBinding.getPcBindings();
            int j = 0;
            while (j < pcBindings.size()) {
                PCBinding pcBnd = (PCBinding)pcBindings.get(j);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.pcNameLink)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++j;
            }
            if (pcBinding == null) {
                pcBinding = wsbndfactory.createPCBinding();
                pcBinding.setPcNameLink(this.pcNameLink);
                wsDescBinding.getPcBindings().add((Object)pcBinding);
            }
            WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
            SecurityRequestConsumerBindingConfig secReqConBndConfig = pcBinding.getSecurityRequestConsumerBindingConfig();
            if (secReqConBndConfig == null) {
                secReqConBndConfig = wsbndfactory.createSecurityRequestConsumerBindingConfig();
                pcBinding.setSecurityRequestConsumerBindingConfig(secReqConBndConfig);
            }
            SigningInfo signingInfo = wscommonbndfactory.createSigningInfo();
            signingInfo.setName("RequestConsumerSigningInfo" + System.currentTimeMillis());
            SignatureMethod signatureMethod = wscommonbndfactory.createSignatureMethod();
            signatureMethod.setAlgorithm(this.consumerSignatureInfo.getSignMethod());
            signingInfo.setSignatureMethod(signatureMethod);
            CanonicalizationMethod canonicalizationMethod = wscommonbndfactory.createCanonicalizationMethod();
            canonicalizationMethod.setAlgorithm(this.consumerSignatureInfo.getCanonicalizationMethod());
            signingInfo.setCanonicalizationMethod(canonicalizationMethod);
            PartReference partReference = wscommonbndfactory.createPartReference();
            partReference.setName("RequestConsumerSignaturePartRef" + System.currentTimeMillis());
            partReference.setPart(this.consumerSignatureInfo.getId());
            Transform transform = wscommonbndfactory.createTransform();
            transform.setName("RequestConsumerSignatureTransform" + System.currentTimeMillis());
            transform.setAlgorithm(this.consumerSignatureInfo.getTransformAlgorithm());
            partReference.getTransform().add((Object)transform);
            DigestMethod digestMethod = wscommonbndfactory.createDigestMethod();
            digestMethod.setAlgorithm(this.consumerSignatureInfo.getDigestMethod());
            partReference.setDigestMethod(digestMethod);
            signingInfo.getPartReference().add((Object)partReference);
            SigningKeyInfo signingKeyInfo = wscommonbndfactory.createSigningKeyInfo();
            signingKeyInfo.setKeyinfoRef(this.consumerSignatureInfo.getKeyInfo().getId());
            signingInfo.getSigningKeyInfo().add((Object)signingKeyInfo);
            secReqConBndConfig.getSigningInfo().add((Object)signingInfo);
            KeyInfo keyInfo = wscommonbndfactory.createKeyInfo();
            keyInfo.setName(this.consumerSignatureInfo.getKeyInfo().getId());
            keyInfo.setType(this.consumerSignatureInfo.getKeyInfo().getType());
            keyInfo.setClassname(this.consumerSignatureInfo.getKeyInfo().getConsumerClassName());
            KeyLocatorMapping keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
            keyLocatorMapping.setLocatorRef(this.consumerSignatureInfo.getKeyInfo().getId());
            keyInfo.setKeyLocatorMapping(keyLocatorMapping);
            TokenReference tokenReference = wscommonbndfactory.createTokenReference();
            tokenReference.setTokenRef(this.tokenConsumer.getToken().getId());
            keyInfo.setTokenReference(tokenReference);
            secReqConBndConfig.getKeyInfo().add((Object)keyInfo);
            KeyLocator keyLocator = wscommonbndfactory.createKeyLocator();
            keyLocator.setName(this.consumerSignatureInfo.getKeyInfo().getId());
            keyLocator.setClassname(this.consumerSignatureInfo.getKeyInfo().getLocatorClass());
            secReqConBndConfig.getKeyLocator().add((Object)keyLocator);
            TokenConsumer tokenConsumerModel = wscommonbndfactory.createTokenConsumer();
            tokenConsumerModel.setName(this.tokenConsumer.getToken().getId());
            tokenConsumerModel.setClassname(this.tokenConsumer.getToken().getConsumerClassName());
            ValueType valueType = wscommonbndfactory.createValueType();
            valueType.setLocalName(this.tokenConsumer.getToken().getTokenLocalName());
            valueType.setUri(this.tokenConsumer.getToken().getTokenURI());
            valueType.setName(this.tokenConsumer.getToken().getValueType());
            tokenConsumerModel.setValueType(valueType);
            JAASConfig jAASConfig = wscommonbndfactory.createJAASConfig();
            jAASConfig.setConfigName(this.tokenConsumer.getToken().getJAASConfigName());
            tokenConsumerModel.setJAASConfig(jAASConfig);
            CertPathSettings certPathSettings = wscommonbndfactory.createCertPathSettings();
            if (this.tokenConsumer.getKeyStore() == null) {
                TrustAnyCertificate trustAnyCertificate = wscommonbndfactory.createTrustAnyCertificate();
                certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
            } else {
                TrustAnchor trustAnchor = wscommonbndfactory.createTrustAnchor();
                trustAnchor.setName(this.tokenConsumer.getTrustAnchor());
                keyStore = wscommonbndfactory.createKeyStore();
                keyStore.setStorepass(this.tokenConsumer.getKeyStore().getKeyStoreStorePass());
                keyStore.setPath(this.tokenConsumer.getKeyStore().getKeyStorePath());
                keyStore.setType(this.tokenConsumer.getKeyStore().getKeyStoreType());
                trustAnchor.setKeyStore(keyStore);
                secReqConBndConfig.getTrustAnchor().add((Object)trustAnchor);
                TrustAnchorRef trustAnchorRef = wscommonbndfactory.createTrustAnchorRef();
                trustAnchorRef.setRef(this.tokenConsumer.getTrustAnchor());
                certPathSettings.setTrustAnchorRef(trustAnchorRef);
                if (this.tokenConsumer.getCertificate() != null) {
                    CertStoreList certStoreList = wscommonbndfactory.createCertStoreList();
                    CollectionCertStore collectionCertStore = wscommonbndfactory.createCollectionCertStore();
                    collectionCertStore.setName(this.tokenConsumer.getCertificate().getCertName());
                    collectionCertStore.setProvider(this.tokenConsumer.getCertificate().getProvider());
                    X509Certificate x509Certificate = wscommonbndfactory.createX509Certificate();
                    x509Certificate.setPath(this.tokenConsumer.getCertificate().getPath());
                    collectionCertStore.getX509Certificates().add((Object)x509Certificate);
                    certStoreList.getCollectionCertStores().add((Object)collectionCertStore);
                    secReqConBndConfig.setCertStoreList(certStoreList);
                    CertStoreRef certStoreRef = wscommonbndfactory.createCertStoreRef();
                    certStoreRef.setRef(this.tokenConsumer.getCertificate().getCertName());
                    certPathSettings.setCertStoreRef(certStoreRef);
                }
            }
            tokenConsumerModel.setCertPathSettings(certPathSettings);
            secReqConBndConfig.getTokenConsumer().add((Object)tokenConsumerModel);
            SecurityResponseGeneratorBindingConfig secResGenBndConfig = pcBinding.getSecurityResponseGeneratorBindingConfig();
            if (secResGenBndConfig == null) {
                secResGenBndConfig = wsbndfactory.createSecurityResponseGeneratorBindingConfig();
                pcBinding.setSecurityResponseGeneratorBindingConfig(secResGenBndConfig);
            }
            signingInfo = wscommonbndfactory.createSigningInfo();
            signingInfo.setName("ResponseGeneratorSigningInfo" + System.currentTimeMillis());
            signatureMethod = wscommonbndfactory.createSignatureMethod();
            signatureMethod.setAlgorithm(this.generatorSignatureInfo.getSignMethod());
            signingInfo.setSignatureMethod(signatureMethod);
            canonicalizationMethod = wscommonbndfactory.createCanonicalizationMethod();
            canonicalizationMethod.setAlgorithm(this.generatorSignatureInfo.getCanonicalizationMethod());
            signingInfo.setCanonicalizationMethod(canonicalizationMethod);
            partReference = wscommonbndfactory.createPartReference();
            partReference.setName("ResponseGeneratorSignaturePartRef" + System.currentTimeMillis());
            partReference.setPart(this.generatorSignatureInfo.getId());
            transform = wscommonbndfactory.createTransform();
            transform.setName("ResponseGeneratorSignatureTransform" + System.currentTimeMillis());
            transform.setAlgorithm(this.generatorSignatureInfo.getTransformAlgorithm());
            partReference.getTransform().add((Object)transform);
            digestMethod = wscommonbndfactory.createDigestMethod();
            digestMethod.setAlgorithm(this.generatorSignatureInfo.getDigestMethod());
            partReference.setDigestMethod(digestMethod);
            signingInfo.getPartReference().add((Object)partReference);
            signingKeyInfo = wscommonbndfactory.createSigningKeyInfo();
            signingKeyInfo.setKeyinfoRef(this.generatorSignatureInfo.getKeyInfo().getId());
            signingInfo.getSigningKeyInfo().add((Object)signingKeyInfo);
            secResGenBndConfig.getSigningInfo().add((Object)signingInfo);
            keyInfo = wscommonbndfactory.createKeyInfo();
            keyInfo.setName(this.generatorSignatureInfo.getKeyInfo().getId());
            keyInfo.setType(this.generatorSignatureInfo.getKeyInfo().getType());
            keyInfo.setClassname(this.generatorSignatureInfo.getKeyInfo().getGeneratorClassName());
            keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
            keyLocatorMapping.setLocatorRef(this.generatorSignatureInfo.getKeyInfo().getId());
            if (this.tokenGenerator.getKeyStore().getKey() != null) {
                keyLocatorMapping.setKeynameRef(this.tokenGenerator.getKeyStore().getKeyName());
            }
            keyInfo.setKeyLocatorMapping(keyLocatorMapping);
            tokenReference = wscommonbndfactory.createTokenReference();
            tokenReference.setTokenRef(this.tokenGenerator.getToken().getId());
            keyInfo.setTokenReference(tokenReference);
            secResGenBndConfig.getKeyInfo().add((Object)keyInfo);
            keyLocator = wscommonbndfactory.createKeyLocator();
            keyLocator.setName(this.generatorSignatureInfo.getKeyInfo().getId());
            keyLocator.setClassname(this.generatorSignatureInfo.getKeyInfo().getLocatorClass());
            keyStore = wscommonbndfactory.createKeyStore();
            keyStore.setStorepass(this.tokenGenerator.getKeyStore().getKeyStoreStorePass());
            keyStore.setPath(this.tokenGenerator.getKeyStore().getKeyStorePath());
            keyStore.setType(this.tokenGenerator.getKeyStore().getKeyStoreType());
            keyLocator.setKeyStore(keyStore);
            if (this.tokenGenerator.getKeyStore().getKey() != null) {
                Key key = wscommonbndfactory.createKey();
                key.setAlias(this.tokenGenerator.getKeyStore().getKeyAlias());
                key.setKeypass(this.tokenGenerator.getKeyStore().getKeyPass());
                key.setName(this.tokenGenerator.getKeyStore().getKeyName());
                keyLocator.getKeys().add((Object)key);
            }
            secResGenBndConfig.getKeyLocator().add((Object)keyLocator);
            TokenGenerator tokenGeneratorModel = wscommonbndfactory.createTokenGenerator();
            tokenGeneratorModel.setName(this.tokenGenerator.getToken().getId());
            tokenGeneratorModel.setClassname(this.tokenGenerator.getToken().getGeneratorClassName());
            valueType = wscommonbndfactory.createValueType();
            valueType.setLocalName(this.tokenGenerator.getToken().getTokenLocalName());
            valueType.setUri(this.tokenGenerator.getToken().getTokenURI());
            valueType.setName(this.tokenGenerator.getToken().getValueType());
            tokenGeneratorModel.setValueType(valueType);
            CallbackHandler callbackHandler = wscommonbndfactory.createCallbackHandler();
            callbackHandler.setClassname(this.tokenGenerator.getToken().getTokenCallBackHandler());
            keyStore = wscommonbndfactory.createKeyStore();
            keyStore.setStorepass(this.tokenGenerator.getKeyStore().getKeyStoreStorePass());
            keyStore.setPath(this.tokenGenerator.getKeyStore().getKeyStorePath());
            keyStore.setType(this.tokenGenerator.getKeyStore().getKeyStoreType());
            callbackHandler.setKeyStore(keyStore);
            if (this.tokenGenerator.getKeyStore().getKey() != null) {
                Key key = wscommonbndfactory.createKey();
                key.setAlias(this.tokenGenerator.getKeyStore().getKeyAlias());
                key.setKeypass(this.tokenGenerator.getKeyStore().getKeyPass());
                key.setName(this.tokenGenerator.getKeyStore().getKeyName());
                callbackHandler.getKey().add((Object)key);
            }
            tokenGeneratorModel.setCallbackHandler(callbackHandler);
            if (this.tokenGenerator.getCertificate() != null) {
                CertStoreList certStoreList = wscommonbndfactory.createCertStoreList();
                CollectionCertStore collectionCertStore = wscommonbndfactory.createCollectionCertStore();
                collectionCertStore.setName(this.tokenGenerator.getCertificate().getCertName());
                collectionCertStore.setProvider(this.tokenGenerator.getCertificate().getProvider());
                X509Certificate x509Certificate = wscommonbndfactory.createX509Certificate();
                x509Certificate.setPath(this.tokenGenerator.getCertificate().getPath());
                collectionCertStore.getX509Certificates().add((Object)x509Certificate);
                certStoreList.getCollectionCertStores().add((Object)collectionCertStore);
                secResGenBndConfig.setCertStoreList(certStoreList);
                certPathSettings = wscommonbndfactory.createCertPathSettings();
                CertStoreRef certStoreRef = wscommonbndfactory.createCertStoreRef();
                certStoreRef.setRef(this.tokenGenerator.getCertificate().getCertName());
                certPathSettings.setCertStoreRef(certStoreRef);
                tokenGeneratorModel.setCertPathSettings(certPathSettings);
            }
            secResGenBndConfig.getTokenGenerator().add((Object)tokenGeneratorModel);
            artifactEdit.saveIfNecessary(this.monitor);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = component.getRootFolder().getFolder("WEB-INF");
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = component.getRootFolder().getFolder("META-INF");
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.ibmWebServicesXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservices-bnd.xmi")).exists()) {
            this.ibmWebServicesBndXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservices-ext.xmi")).exists()) {
            this.ibmWebServicesExtXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public void setConsumerSignatureInfo(SignatureInformation consumerSignatureInfo) {
        this.consumerSignatureInfo = consumerSignatureInfo;
    }

    public void setGeneratorSignatureInfo(SignatureInformation generatorSignatureInfo) {
        this.generatorSignatureInfo = generatorSignatureInfo;
    }

    public void setTokenConsumer(SignedCertificateToken tokenConsumer) {
        this.tokenConsumer = tokenConsumer;
    }

    public void setTokenGenerator(SignedCertificateToken tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

