/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.JAASConfig;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Caller;
import com.ibm.etools.webservice.wscommonext.RequiredSecurityToken;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.etools.webservice.wsext.impl.WsextFactoryImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddServerSideAuthenticationCommand
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private String wsNameLink = null;
    private String pcNameLink = null;
    private String serviceName;
    IPath ibmWebServicesXMLPath = null;
    private IProject serviceProject;
    private IProgressMonitor monitor;
    private AuthenticationToken token;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adabptable) {
        IProject wsXmlProject = this.serviceProject;
        this.monitor = monitor;
        this.getWSDDFilePath(wsXmlProject);
        if (this.ibmWebServicesXMLPath == null) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_WEBSERVICES_XML_NOT_FOUND"), null);
        }
        try {
            this.getNamesFromWebServicesXML(wsXmlProject);
            this.updateWsBndENC(wsXmlProject);
            this.updateWsExtENC(wsXmlProject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEBSERVICES_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNamesFromWebServicesXML(IProject ddProject) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            EList wsDescriptions = webservices.getWebServiceDescriptions();
            if (wsDescriptions.size() < 1) {
                return;
            }
            WebServiceDescription wsDescription = null;
            int i = 0;
            while (i < wsDescriptions.size()) {
                if (((WebServiceDescription)wsDescriptions.get(i)).getWebServiceDescriptionName().equals(this.serviceName)) {
                    wsDescription = (WebServiceDescription)wsDescriptions.get(i);
                }
                ++i;
            }
            this.wsNameLink = wsDescription.getWebServiceDescriptionName();
            EList portComponents = wsDescription.getPortComponents();
            if (portComponents.size() < 1) {
                return;
            }
            PortComponent portComponent = (PortComponent)portComponents.get(0);
            this.pcNameLink = portComponent.getPortComponentName();
            return;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtENC(IProject ddProject) {
        WsextArtifactEdit artifactEdit = null;
        try {
            SecurityRequestConsumerServiceConfig secReqConServiceConfig;
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ddProject);
            WsExtension wsext = artifactEdit.getWsExtension();
            WsextFactoryImpl wsextfactory = new WsextFactoryImpl();
            WsDescExt wsDescExt = null;
            PcBinding pcBinding = null;
            EList wsDescExts = wsext.getWsDescExt();
            int i = 0;
            while (i < wsDescExts.size()) {
                WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
                if (tmpWsDescExt.getWsDescNameLink() != null && tmpWsDescExt.getWsDescNameLink().equals(this.wsNameLink)) {
                    wsDescExt = tmpWsDescExt;
                    break;
                }
                ++i;
            }
            if (wsDescExt == null) {
                wsDescExt = wsextfactory.createWsDescExt();
                wsDescExt.setWsDescNameLink(this.wsNameLink);
                wsext.getWsDescExt().add((Object)wsDescExt);
            }
            EList pcBnds = wsDescExt.getPcBinding();
            int i2 = 0;
            while (i2 < pcBnds.size()) {
                PcBinding pcBnd = (PcBinding)pcBnds.get(i2);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.pcNameLink)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++i2;
            }
            if (pcBinding == null) {
                pcBinding = wsextfactory.createPcBinding();
                pcBinding.setPcNameLink(this.pcNameLink);
                wsDescExt.getPcBinding().add((Object)pcBinding);
            }
            WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
            ServerServiceConfig serverserviceconfig = pcBinding.getServerServiceConfig();
            if (serverserviceconfig == null) {
                serverserviceconfig = wsextfactory.createServerServiceConfig();
                pcBinding.setServerServiceConfig(serverserviceconfig);
            }
            if ((secReqConServiceConfig = serverserviceconfig.getSecurityRequestConsumerServiceConfig()) == null) {
                secReqConServiceConfig = wsextfactory.createSecurityRequestConsumerServiceConfig();
                serverserviceconfig.setSecurityRequestConsumerServiceConfig(secReqConServiceConfig);
            }
            Caller caller = wscommonextfactory.createCaller();
            caller.setLocalName(this.token.getTokenLocalName());
            caller.setUri(this.token.getTokenURI());
            RequiredSecurityToken secToken = wscommonextfactory.createRequiredSecurityToken();
            secToken.setLocalName(this.token.getTokenLocalName());
            secToken.setUri(this.token.getTokenURI());
            secToken.setName(this.token.getId());
            secToken.setUsage(this.token.getUsageType().equals("Required") ? UsageType.REQUIRED_LITERAL : UsageType.OPTIONAL_LITERAL);
            secReqConServiceConfig.getCaller().add((Object)caller);
            secReqConServiceConfig.getRequiredSecurityToken().add((Object)secToken);
            artifactEdit.saveIfNecessary(this.monitor);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsBndENC(IProject ddProject) {
        WsbndArtifactEdit artifactEdit = null;
        try {
            SecurityRequestConsumerBindingConfig secReqConBndConfig;
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ddProject);
            WSBinding wsbnd = artifactEdit.getWSBinding();
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            WSDescBinding wsDescBinding = null;
            PCBinding pcBinding = null;
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
            while (i < wscbindings.size()) {
                WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
                if (wsDscBnd.getWsDescNameLink() != null && wsDscBnd.getWsDescNameLink().equals(this.wsNameLink)) {
                    wsDescBinding = wsDscBnd;
                    break;
                }
                ++i;
            }
            if (wsDescBinding == null) {
                wsDescBinding = wsbndfactory.createWSDescBinding();
                wsDescBinding.setWsDescNameLink(this.wsNameLink);
                wsbnd.getWsdescBindings().add((Object)wsDescBinding);
            }
            EList pcBindings = wsDescBinding.getPcBindings();
            int j = 0;
            while (j < pcBindings.size()) {
                PCBinding pcBnd = (PCBinding)pcBindings.get(j);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.pcNameLink)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++j;
            }
            if (pcBinding == null) {
                pcBinding = wsbndfactory.createPCBinding();
                pcBinding.setPcNameLink(this.pcNameLink);
                wsDescBinding.getPcBindings().add((Object)pcBinding);
            }
            if ((secReqConBndConfig = pcBinding.getSecurityRequestConsumerBindingConfig()) == null) {
                secReqConBndConfig = wsbndfactory.createSecurityRequestConsumerBindingConfig();
                pcBinding.setSecurityRequestConsumerBindingConfig(secReqConBndConfig);
            }
            WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
            TokenConsumer tokenConsumer = wscommonbndfactory.createTokenConsumer();
            tokenConsumer.setName(this.token.getId());
            tokenConsumer.setClassname(this.token.getConsumerClassName());
            ValueType valueType = wscommonbndfactory.createValueType();
            valueType.setLocalName(this.token.getTokenLocalName());
            valueType.setUri(this.token.getTokenURI());
            valueType.setName(this.token.getValueType());
            if (this.token.getJAASConfigName() != null) {
                JAASConfig jAASConfig = wscommonbndfactory.createJAASConfig();
                jAASConfig.setConfigName(this.token.getJAASConfigName());
                tokenConsumer.setJAASConfig(jAASConfig);
            }
            PartReference partRef = wscommonbndfactory.createPartReference();
            partRef.setPart(this.token.getId());
            tokenConsumer.setValueType(valueType);
            tokenConsumer.setPartReference(partRef);
            secReqConBndConfig.getTokenConsumer().add((Object)tokenConsumer);
            artifactEdit.saveIfNecessary(this.monitor);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = component.getRootFolder().getFolder("WEB-INF");
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = component.getRootFolder().getFolder("META-INF");
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.ibmWebServicesXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setToken(AuthenticationToken token) {
        this.token = token;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

