/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.utils.CopyJAXRPCMappingFileUtil;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.wsdl.Port;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.internal.WebServiceInit;
import org.eclipse.jst.j2ee.webservice.internal.wsdd.WsddResourceFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class UpdateWebServicesXmlCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webServicesXMLPath = null;
    private String eJBProjectName;
    private IProject serviceProject;
    private String ejbName = null;
    private String wsdlRelativePath = null;
    private boolean isFreeFormJ2ee14_ = false;
    private boolean isWebProjectStartupRequested = true;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject wsXmlProject;
        IEnvironment environment = super.getEnvironment();
        if (this.javaWSDLParam == null) {
            IStatus status = StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"));
            environment.getStatusHandler().reportError(status);
            return status;
        }
        boolean isEJB = this.javaWSDLParam.getServerSide() == 2;
        IProject iProject = wsXmlProject = isEJB ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.eJBProjectName) : this.serviceProject;
        if (wsXmlProject == null) {
            IStatus status = StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_SERVICE_PROJECT_NOT_FOUND"));
            environment.getStatusHandler().reportError(status);
            return status;
        }
        if (this.javaWSDLParam.isMetaInfOnly()) {
            CopyJAXRPCMappingFileUtil.copyJaxRpcMappingFile(environment, monitor, this.javaWSDLParam, isEJB);
        }
        this.getWSDDFilePath(wsXmlProject);
        Hashtable webServiceDescriptions = new Hashtable();
        WSDDArtifactEdit artifactEdit = null;
        WebServices newWebServices = null;
        if (!this.isFreeFormJ2ee14_ && this.webServicesXMLPath == null) {
            IStatus status = this.copyWebServicesXMLFile(environment, monitor, isEJB);
            if (status.getSeverity() != 0) {
                return status;
            }
            try {
                try {
                    artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForWrite((IProject)wsXmlProject);
                    newWebServices = artifactEdit.getWebServices();
                    this.modifyWebServicesXMLContents(newWebServices, isEJB, webServiceDescriptions);
                    artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    status = StatusUtils.errorStatus((String)(String.valueOf(RdPlugin.getDefault().getMessage("MSG_ERROR_PARSING_WEBSERVICES_XML")) + ": " + e), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    IStatus iStatus = status;
                    artifactEdit.dispose();
                    return iStatus;
                }
            }
            finally {
                artifactEdit.dispose();
            }
            return Status.OK_STATUS;
        }
        CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
        if (context.isBackupDD()) {
            CopyJAXRPCMappingFileUtil.backupWebServicesFile(environment, monitor, this.webServicesXMLPath.toString(), wsXmlProject, "webservices.xml");
        }
        newWebServices = UpdateWebServicesXmlCommand.loadResourceFromOutside(this.javaWSDLParam.getTempOutput(), isEJB);
        this.modifyWebServicesXMLContents(newWebServices, isEJB, webServiceDescriptions);
        try {
            try {
                artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForWrite((IProject)wsXmlProject);
                WebServices webServicesTemp = artifactEdit.getWebServices();
                if (webServicesTemp == null) {
                    webServicesTemp = (WebServices)artifactEdit.createModelRoot(11);
                }
                EList eList = webServicesTemp.getWebServiceDescriptions();
                int i = 0;
                while (i < eList.size()) {
                    WebServiceDescription wsdpTemp = (WebServiceDescription)eList.get(i);
                    if (webServiceDescriptions.get(wsdpTemp.getWebServiceDescriptionName()) != null) {
                        eList.remove(i);
                        --i;
                    }
                    ++i;
                }
                for (WebServiceDescription wsDesc : webServiceDescriptions.values()) {
                    eList.add((Object)wsDesc);
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                IStatus status = StatusUtils.errorStatus((String)(String.valueOf(RdPlugin.getDefault().getMessage("MSG_ERROR_PARSING_WEBSERVICES_XML")) + ": " + e), (Throwable)e);
                environment.getStatusHandler().reportError(status);
                IStatus iStatus = status;
                artifactEdit.dispose();
                return iStatus;
            }
        }
        finally {
            artifactEdit.dispose();
        }
        return Status.OK_STATUS;
    }

    private IStatus copyWebServicesXMLFile(IEnvironment environment, IProgressMonitor monitor, boolean isEJB) {
        if (this.javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform(this.javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
        File source = new File(String.valueOf(targetOutput) + infFolder + File.separator + "webservices.xml");
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = outputPath.append(infFolder).append("webservices.xml").makeAbsolute();
        try {
            FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
            ResourcesPlugin.getWorkspace().checkpoint(false);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    private void getWSDDFilePath(IProject wsProject) {
        IPath projectPath = wsProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)wsProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)wsProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)wsProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.webServicesXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    private void modifyWebServicesXMLContents(WebServices newWebServices, boolean isEJB, Hashtable webServiceDescriptions) {
        Map wsdlPort2ImplBeanMapping = this.javaWSDLParam.getWSDLPort2ImplBeanMapping();
        HashMap wsdlPortName2ImplBeanMapping = new HashMap();
        for (Port port : wsdlPort2ImplBeanMapping.keySet()) {
            wsdlPortName2ImplBeanMapping.put(port.getName(), wsdlPort2ImplBeanMapping.get(port));
        }
        for (WebServiceDescription wsDesc : newWebServices.getWebServiceDescriptions()) {
            webServiceDescriptions.put(wsDesc.getWebServiceDescriptionName(), wsDesc);
            if (this.wsdlRelativePath != null) {
                wsDesc.setWsdlFile(this.wsdlRelativePath);
            }
            for (PortComponent portComp : wsDesc.getPortComponents()) {
                ServiceImplBean serviceImplBean = portComp.getServiceImplBean();
                String implBeanClassName = (String)wsdlPortName2ImplBeanMapping.get(portComp.getPortComponentName());
                if (implBeanClassName == null) continue;
                if (isEJB) {
                    int index = implBeanClassName.lastIndexOf(46);
                    if (index != -1) {
                        implBeanClassName = implBeanClassName.substring(index + 1);
                    }
                    EJBLink ejbLink = serviceImplBean.getEEJBLink();
                    if (this.ejbName != null) {
                        ejbLink.setEjbLink(this.ejbName);
                        if (this.javaWSDLParam.getSEIName() == null) continue;
                        portComp.setServiceEndpointInterface(this.javaWSDLParam.getSEIName());
                        continue;
                    }
                    ejbLink.setEjbLink(implBeanClassName);
                    continue;
                }
                implBeanClassName = implBeanClassName.replace('.', '_');
                ServletLink servletLink = serviceImplBean.getEServletLink();
                servletLink.setServletLink(implBeanClassName);
            }
        }
    }

    public static WebServices loadResourceFromOutside(String rootPath, boolean isEJB) {
        J2EEInit.init();
        WebServiceInit.init();
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        WsddResourceFactory.registerWith((RendererFactory)new EMF2DOMRendererFactory());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        URIConverterImpl conv = new URIConverterImpl();
        resourceSet.setURIConverter((URIConverter)conv);
        String filePath = String.valueOf(rootPath) + infFolder + File.separator + "webservices.xml";
        filePath = J2EEUtils.removeFileProtocol((String)filePath);
        URI uri = URI.createFileURI((String)filePath);
        try {
            WebServices wss;
            Resource resource = resourceSet.getResource(uri, true);
            WsddResource wsdd = (WsddResource)resource;
            WebServices webServices = wss = wsdd.getWebServices();
            return webServices;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            WsddResourceFactory.register();
        }
        return null;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String getWsdlURI() {
        return this.javaWSDLParam.getInputWsdlLocation();
    }

    public boolean getIsWebProjectStartupRequested() {
        return this.isWebProjectStartupRequested;
    }

    public void setWsdlRelativePath(String wsdlRelativePath) {
        this.wsdlRelativePath = wsdlRelativePath;
    }

    public void setIsFreeFormJ2ee14(boolean isFreeFormJ2ee14) {
        this.isFreeFormJ2ee14_ = isFreeFormJ2ee14;
    }
}

