/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.ast.ws.rd.utils.PostBuildListener;
import com.ibm.ast.ws.rd.utils.SEICreationInfo;
import com.ibm.etools.webservice.was.consumption.command.ValidateEditCommand;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.JavaUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.ws.rd.utils.WRDUtilFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SEICreationCommand
extends AbstractDataModelOperation {
    private StringBuffer fBuffer;
    private SEICreationInfo seiInfo;
    private IProject freeFormProject;
    private IVirtualComponent component;
    private IType javaType;
    private IProject serviceProject;
    private JavaWSDLParameterBase javaWSDLParam;
    private final String JAVA_EXTENSION = ".java";
    private final String CLASS_EXTENSION = ".class";
    private final String SEI = "_SEI";
    private boolean isWrdScenario_;
    private final String NEWLINE = System.getProperty("line.separator");
    private final String SRCFOLDER = "gen/src";
    private boolean computeDeletionsForEjb_ = false;
    private final String PACKAGE = "package";
    private final String PUBLIC = "public";
    private final String INTERFACE = "interface";
    private final String EXTENDS = "extends";
    private final String REMOTE = "java.rmi.Remote";
    private final String SPACE = " ";

    public SEICreationCommand(IProject freeFormProject, IVirtualComponent component, IType javaType) {
        this.isWrdScenario_ = true;
        this.freeFormProject = freeFormProject;
        this.component = component;
        this.javaType = javaType;
        this.fBuffer = new StringBuffer();
        this.seiInfo = new SEICreationInfo();
        this.setSEICreationInfo();
    }

    public SEICreationCommand() {
        this.isWrdScenario_ = false;
        this.fBuffer = new StringBuffer();
        this.seiInfo = new SEICreationInfo();
    }

    public SEICreationCommand(String id) {
        this();
        this.setID(id);
    }

    private void computeDeletions() {
        String javaOutputPathStr = this.javaWSDLParam.getDevelopServerJavaOutput();
        String beanName = this.javaWSDLParam.getBeanName();
        String simpleBeanName = JavaUtils.getSimpleClassNameFromQualifiedName((String)beanName);
        if (Character.isLowerCase(simpleBeanName.charAt(0))) {
            beanName = JavaUtils.capitalizeClassNameFromQualifiedName((String)beanName);
            simpleBeanName = JavaUtils.getSimpleClassNameFromQualifiedName((String)beanName);
        }
        String seiName = this.javaWSDLParam.getSEIName();
        String seiPkg = JavaUtils.getPackageNameFromClassName((String)seiName);
        StringBuffer soapBindingImplClassNameBuffer = new StringBuffer("SoapBindingImpl");
        soapBindingImplClassNameBuffer.insert(0, simpleBeanName);
        if (seiPkg != null) {
            soapBindingImplClassNameBuffer.insert(0, '.');
            soapBindingImplClassNameBuffer.insert(0, seiPkg);
        }
        String soapBindingImplClassName = soapBindingImplClassNameBuffer.toString();
        StringBuffer soapBindingImplFileNameBuffer = new StringBuffer(".java");
        soapBindingImplFileNameBuffer.insert(0, soapBindingImplClassName.replace('.', '/'));
        soapBindingImplFileNameBuffer.insert(0, '/');
        soapBindingImplFileNameBuffer.insert(0, javaOutputPathStr);
        String soapBindingImplFileName = PlatformUtils.getPathFromPlatform(soapBindingImplFileNameBuffer.toString());
        Path soapBindingImplFilePath = new Path(soapBindingImplFileName);
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IFile soapBindingImplFile = workspace.getFile((IPath)soapBindingImplFilePath);
        if (!soapBindingImplFile.exists()) {
            this.javaWSDLParam.setSoapBindingImplFile(soapBindingImplFileName);
        }
        this.javaWSDLParam.addToIgnoredClassList(soapBindingImplClassName);
        if (this.computeDeletionsForEjb_) {
            StringBuffer emitterGeneratedSeiClassNameBuffer = this.javaWSDLParam.generateSEIFile() ? new StringBuffer(beanName) : new StringBuffer(seiName);
            String emitterGeneratedSeiClassName = emitterGeneratedSeiClassNameBuffer.toString();
            StringBuffer emitterGeneratedSeiFileNameBuffer = new StringBuffer(".java");
            emitterGeneratedSeiFileNameBuffer.insert(0, emitterGeneratedSeiClassName.replace('.', '/'));
            emitterGeneratedSeiFileNameBuffer.insert(0, '/');
            emitterGeneratedSeiFileNameBuffer.insert(0, javaOutputPathStr);
            String emitterGeneratedSeiFileName = PlatformUtils.getPathFromPlatform(emitterGeneratedSeiFileNameBuffer.toString());
            Path emitterGeneratedSeiFilePath = new Path(emitterGeneratedSeiFileName);
            IFile emitterGeneratedSeiFile = workspace.getFile((IPath)emitterGeneratedSeiFilePath);
            if (!emitterGeneratedSeiFile.exists()) {
                this.javaWSDLParam.setEmitterGeneratedSEI(emitterGeneratedSeiFileName);
            }
            this.javaWSDLParam.addToIgnoredClassList(emitterGeneratedSeiClassName);
            StringBuffer emitterGeneratedRIClassNameBuffer = this.javaWSDLParam.generateSEIFile() ? new StringBuffer(beanName) : new StringBuffer(seiName);
            emitterGeneratedRIClassNameBuffer.append("_RI");
            String emitterGeneratedRIClassName = emitterGeneratedRIClassNameBuffer.toString();
            StringBuffer emitterGeneratedRIFileNameBuffer = new StringBuffer(".java");
            emitterGeneratedRIFileNameBuffer.insert(0, emitterGeneratedRIClassName.replace('.', '/'));
            emitterGeneratedRIFileNameBuffer.insert(0, '/');
            emitterGeneratedRIFileNameBuffer.insert(0, javaOutputPathStr);
            String emitterGeneratedRIFileName = PlatformUtils.getPathFromPlatform(emitterGeneratedRIFileNameBuffer.toString());
            Path emitterGeneratedRIFilePath = new Path(emitterGeneratedRIFileName);
            IFile emitterGeneratedRIFile = workspace.getFile((IPath)emitterGeneratedRIFilePath);
            if (!emitterGeneratedRIFile.exists()) {
                this.javaWSDLParam.setEmitterGeneratedRI(emitterGeneratedRIFileName);
            }
            this.javaWSDLParam.addToIgnoredClassList(emitterGeneratedRIClassName);
            StringBuffer emitterGeneratedHomeClassNameBuffer = this.javaWSDLParam.generateSEIFile() ? new StringBuffer(beanName) : new StringBuffer(seiName);
            emitterGeneratedHomeClassNameBuffer.append("Home");
            String emitterGeneratedHomeClassName = emitterGeneratedHomeClassNameBuffer.toString();
            StringBuffer emitterGeneratedHomeFileNameBuffer = new StringBuffer(".java");
            emitterGeneratedHomeFileNameBuffer.insert(0, emitterGeneratedHomeClassName.replace('.', '/'));
            emitterGeneratedHomeFileNameBuffer.insert(0, '/');
            emitterGeneratedHomeFileNameBuffer.insert(0, javaOutputPathStr);
            String emitterGeneratedHomeFileName = PlatformUtils.getPathFromPlatform(emitterGeneratedHomeFileNameBuffer.toString());
            Path emitterGeneratedHomeFilePath = new Path(emitterGeneratedHomeFileName);
            IFile emitterGeneratedHomeFile = workspace.getFile((IPath)emitterGeneratedHomeFilePath);
            if (!emitterGeneratedHomeFile.exists()) {
                this.javaWSDLParam.setEmitterGeneratedHI(emitterGeneratedHomeFileName);
            }
            this.javaWSDLParam.addToIgnoredClassList(emitterGeneratedHomeClassName);
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.javaWSDLParam != null) {
            this.computeDeletions();
            if (!this.javaWSDLParam.generateSEIFile()) {
                return Status.OK_STATUS;
            }
        }
        IEnvironment environment = super.getEnvironment();
        this.fBuffer = new StringBuffer();
        Status status = this.writeCodeGen();
        if (status != null) {
            return status;
        }
        status = this.createSEIFile(environment, monitor);
        if (status != null) {
            return status;
        }
        if (this.isWrdScenario_) {
            ResourcesPlugin.getWorkspace().checkpoint(false);
        } else {
            PostBuildListener listener = null;
            try {
                try {
                    listener = new PostBuildListener();
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 16);
                    ResourcesPlugin.getWorkspace().checkpoint(false);
                    ResourcesPlugin.getWorkspace().build(10, monitor);
                    int count = 0;
                    while (!listener.isBuildComplete()) {
                        try {
                            Thread.sleep(300L);
                            if (count++ != 2000) continue;
                            RdPlugin.getDefault().getLog().log(StatusUtils.errorStatus((String)"*** build not complete after 10 minutes"));
                        }
                        catch (InterruptedException e) {
                            RdPlugin.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)e));
                        }
                    }
                }
                catch (CoreException coreException) {
                    if (listener != null) {
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                    }
                }
            }
            finally {
                if (listener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private Status writeCodeGen() {
        String packageName = this.seiInfo.getJavaClass().getJavaPackage().getPackageName();
        if (packageName != null && !packageName.equals("")) {
            this.fBuffer.append("package " + packageName + ";" + this.NEWLINE);
        }
        this.fBuffer.append(this.NEWLINE);
        this.fBuffer.append(this.seiInfo.getSeiImports());
        this.fBuffer.append(this.NEWLINE);
        this.fBuffer.append("public interface " + Signature.getSimpleName((String)this.seiInfo.getSEIName()));
        this.fBuffer.append(" extends java.rmi.Remote" + this.NEWLINE);
        this.fBuffer.append("{" + this.NEWLINE);
        this.addMethods();
        this.fBuffer.append("}");
        return null;
    }

    private void addMethods() {
        String[] m = this.seiInfo.getMethods();
        int i = 0;
        while (i < m.length) {
            this.fBuffer.append(" ").append(" ");
            this.fBuffer.append("public");
            this.fBuffer.append(" ");
            this.fBuffer.append(m[i]);
            this.fBuffer.append(this.NEWLINE);
            ++i;
        }
    }

    private final ResourceContext getResourceContext(IEnvironment env) {
        Object context = null;
        context = env instanceof BaseEclipseEnvironment ? ((BaseEclipseEnvironment)env).getResourceContext() : new TransientResourceContext();
        return context;
    }

    private IStatus createSEIFile(IEnvironment environment, IProgressMonitor monitor) {
        try {
            IProject reflectionProject = this.freeFormProject != null ? this.freeFormProject : this.component.getProject();
            String encoding = reflectionProject.getDefaultCharset();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.fBuffer.toString().getBytes(encoding));
            ResourceContext rcontext = this.getResourceContext(environment);
            rcontext.setOverwriteFilesEnabled(rcontext.isOverwriteFilesEnabled());
            Vector<IPath> pathVector = new Vector<IPath>();
            pathVector.add(this.seiInfo.getSeiPath().makeAbsolute());
            ValidateEditCommand validateEditCmd = new ValidateEditCommand();
            validateEditCmd.setEnvironment(environment);
            validateEditCmd.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
            IStatus validateStatus = validateEditCmd.execute(monitor, null);
            if (!validateStatus.isOK()) {
                return validateStatus;
            }
            IFile seiFile = FileResourceUtils.createFile((ResourceContext)rcontext, (IPath)this.seiInfo.getSeiPath().makeAbsolute(), (InputStream)bais, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
            if (seiFile == null) {
                return StatusUtils.errorStatus((String)"");
            }
        }
        catch (Exception e) {
            WRDUtilFactory.getMonitor().monitor(RdPlugin.getDefault().getMessage("MSG_ERROR_UNEXPECTED"), 4);
            e.printStackTrace();
        }
        return null;
    }

    private void setSEICreationInfo() {
        String className = this.javaType.getFullyQualifiedName();
        String packageName = this.javaType.getPackageFragment().getElementName();
        JavaClass javaClass = this.setJavaMof(className);
        this.seiInfo.setJavaClass(javaClass);
        this.seiInfo.setSEIName(String.valueOf(javaClass.getQualifiedName()) + "_SEI");
        IPath sourcePath = this.freeFormProject != null ? this.freeFormProject.getFolder("gen/src").getFullPath() : this.component.getRootFolder().getUnderlyingFolder().getParent().getFolder((IPath)new Path("gen/src")).getFullPath();
        String source = PlatformUtils.getPlatformURL(sourcePath);
        Path javaSource = new Path(PlatformUtils.getPathFromPlatform(source));
        String SEIName = Signature.getSimpleName((String)this.seiInfo.getSEIName());
        packageName = packageName.replace('.', '/');
        javaSource = javaSource.append(packageName).append(String.valueOf(SEIName) + ".java");
        this.seiInfo.setSeiPath((IPath)javaSource);
        URL platformURL = PlatformUtils.getCommandPlatformURL((IPath)javaSource);
        this.seiInfo.setSEIURL(platformURL);
    }

    private JavaClass setJavaMof(String qName) {
        JavaClass javaClass = null;
        try {
            IProject reflectionProject = this.freeFormProject != null ? this.freeFormProject : this.component.getProject();
            JavaEMFNature jMOF = JavaEMFNature.createRuntime((IProject)reflectionProject);
            javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(qName, jMOF.getResourceSet());
        }
        catch (CoreException coreException) {
            return null;
        }
        if (javaClass.isExistingType()) {
            return javaClass;
        }
        return null;
    }

    public void setMethods(String[] methods) {
        this.seiInfo.setMethods(methods);
    }

    public void setImports(String imports) {
        this.seiInfo.setSeiImports(imports);
    }

    public SEICreationInfo getSeiInfo() {
        return this.seiInfo;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
        this.component = ComponentCore.createComponent((IProject)serviceProject);
        if (this.javaWSDLParam != null) {
            this.setUp();
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        if (this.serviceProject != null) {
            this.setUp();
        }
    }

    private String getQName(String qName) {
        if (qName.toLowerCase().endsWith(".java") || qName.toLowerCase().endsWith(".class")) {
            qName = qName.substring(0, qName.lastIndexOf(46));
        }
        return qName;
    }

    private void setSEIName() {
        if (this.javaWSDLParam.generateSEIFile()) {
            this.javaWSDLParam.setSEIName(String.valueOf(this.seiInfo.getJavaClass().getQualifiedName()) + "_SEI");
        }
        this.seiInfo.setSEIName(this.javaWSDLParam.getSEIName());
    }

    private void setSEIURL() {
        String source = this.javaWSDLParam.getDevelopServerJavaOutput();
        source = PlatformUtils.getPathFromPlatform(source);
        Path javaSource = new Path(source);
        String SEIName = this.removePackage(this.seiInfo.getSEIName());
        String packageName = this.seiInfo.getJavaClass().getJavaPackage().getPackageName();
        packageName = packageName.replace('.', '/');
        javaSource = javaSource.append(packageName).append(String.valueOf(SEIName) + ".java");
        this.seiInfo.setSeiPath((IPath)javaSource);
        URL platformURL = PlatformUtils.getCommandPlatformURL((IPath)javaSource);
        this.seiInfo.setSEIURL(platformURL);
    }

    private void setMethods() {
        Hashtable methods = this.javaWSDLParam.getMethods();
        Vector<String> seiMethods = new Vector<String>();
        for (Method method : this.seiInfo.getJavaClass().getPublicMethodsExtended()) {
            String sig = method.getMethodElementSignature();
            if (methods.get(sig) == null || !((Boolean)methods.get(sig)).booleanValue()) continue;
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(String.valueOf(method.getReturnType().getQualifiedName()) + " ");
            tmpBuf.append(String.valueOf(method.getName()) + "(");
            EList params = method.getParameters();
            int parmSize = params.size();
            int j = 0;
            while (j < parmSize) {
                JavaParameter param = (JavaParameter)params.get(j);
                tmpBuf.append(((JavaHelpers)param.getEType()).getQualifiedName());
                tmpBuf.append(" " + param.getName());
                if (j < params.size() - 1) {
                    tmpBuf.append(",");
                }
                ++j;
            }
            tmpBuf.append(")");
            EList exceptions = method.getJavaExceptions();
            if (exceptions.size() > 0) {
                tmpBuf.append(" throws ");
                int k = 0;
                while (k < exceptions.size()) {
                    JavaClass exception = (JavaClass)exceptions.get(k);
                    tmpBuf.append(exception.getJavaName());
                    if (k < exceptions.size() - 1) {
                        tmpBuf.append(",");
                    }
                    ++k;
                }
            }
            tmpBuf.append(";");
            seiMethods.add(tmpBuf.toString());
        }
        this.seiInfo.setMethods(seiMethods.toArray(new String[seiMethods.size()]));
    }

    private String removePackage(String beanName) {
        if (beanName.lastIndexOf(46) != -1) {
            beanName = beanName.substring(beanName.lastIndexOf(46) + 1, beanName.length());
        }
        return beanName;
    }

    private void setUp() {
        String qName = this.getQName(this.javaWSDLParam.getBeanName());
        this.seiInfo.setJavaClass(this.setJavaMof(qName));
        this.setSEIName();
        this.setSEIURL();
        this.setMethods();
    }

    public void setComputeDeletionsForEjb(boolean computeDeletionsForEjb) {
        this.computeDeletionsForEjb_ = computeDeletionsForEjb;
    }
}

