/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddServiceEndpointToEJBJarXMLCommand
extends AbstractDataModelOperation {
    private IProject ejbProject = null;
    private String ejbName = null;
    private JavaWSDLParameterBase javaWSDLParam = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        EJBArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
            if (artifactEdit.getJ2EEVersion() != 14) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                EJBJar ejbJar = artifactEdit.getEJBJar();
                EList ejbs = ejbJar.getEnterpriseBeans();
                int i = 0;
                while (i < ejbs.size()) {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
                    if (ejb.getName().equals(this.ejbName) && ejb instanceof Session) {
                        ((Session)ejb).setServiceEndpointName(this.javaWSDLParam.getSEIName());
                    }
                    ++i;
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                IStatus errorStatus = StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_EJB_JAR_XML_UPDATING"), (Throwable)e);
                env.getStatusHandler().reportError(errorStatus);
                IStatus iStatus = errorStatus;
                return iStatus;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    public void setEjbProject(IProject ejbProject) {
        this.ejbProject = ejbProject;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }
}

