/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.taghandler.scenarios;

import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.SOAPBindingJms;
import com.ibm.ast.ws.rd.operation.UpdateWEBXMLOperation;
import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.taghandler.WSInfo;
import com.ibm.ast.ws.rd.taghandler.scenarios.BottomUpScenario;
import com.ibm.ast.ws.rd.taghandler.scenarios.SaveWSDLInfo;
import com.ibm.ast.ws.rd.utils.AddServiceEndpointToEJBJarXMLCommand;
import com.ibm.ast.ws.rd.utils.BuildWSDLPort2ImplBeanMappingTask;
import com.ibm.ast.ws.rd.utils.CreateModuleCommand;
import com.ibm.ast.ws.rd.utils.DeleteTempOutputCommand;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.ast.ws.rd.utils.SEICreationCommand;
import com.ibm.ast.ws.rd.utils.SEICreationInfo;
import com.ibm.ast.ws.rd.utils.UpdateIBMWebServicesBndXMICommand;
import com.ibm.ast.ws.rd.utils.UpdateIBMWebServicesExtXMICommand;
import com.ibm.ast.ws.rd.utils.UpdateJMSRouterCommand;
import com.ibm.ast.ws.rd.utils.UpdateWebServicesXmlCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.ManageDeployFlagCommand;
import com.ibm.etools.webservice.was.consumption.command.VerifyIBMJRECommand;
import com.ibm.etools.webservice.was.consumption.registry.EmitterCommandsExtension;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.ws.rd.j2ee.utils.J2EEEnvironment;
import com.ibm.ws.rd.utils.WRDUtilFactory;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

class BeanToEJBWebService
extends BottomUpScenario {
    private String routerProjectName_;
    private final byte ROUTER_TYPE_HTTP = 0;
    private final byte ROUTER_TYPE_JMS = 1;
    private final String ROUTER_TRANSPORT_HTTP = "http";
    private final String ROUTER_TRANSPORT_JMS = "jms";

    BeanToEJBWebService(WSInfo i, IProject fp, IVirtualComponent c) {
        super(i, fp, c);
        if (this.freeFormProject != null) {
            this.component = J2EEEnvironment.getEjbComponent((IProject)fp, (boolean)true);
        }
    }

    protected SaveWSDLInfo invokeSEICodeGeneration() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAdaptable adaptable = null;
        VerifyIBMJRECommand verifyJRECommand = new VerifyIBMJRECommand("com.ibm.ast.ws.rd");
        verifyJRECommand.setEnvironment(this.getPlatformEnvironment());
        IStatus verifyStatus = verifyJRECommand.execute((IProgressMonitor)monitor, adaptable);
        if (verifyStatus.getSeverity() == 4) {
            return null;
        }
        IType javaType = this.td.getJavaType();
        SEICreationCommand cc = new SEICreationCommand(this.freeFormProject, this.component, javaType);
        if (this.freeFormProject == null) {
            EJBArtifactEdit ejbArtifactEdit = null;
            try {
                ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)this.component);
                IVirtualComponent ejbClientComponent = ejbArtifactEdit.getEJBClientJarModule();
                SEICreationInfo seiInfo = cc.getSeiInfo();
                if (ejbClientComponent != null) {
                    String packageName = javaType.getPackageFragment().getElementName();
                    IPath sourcePath = ejbClientComponent.getRootFolder().getUnderlyingFolder().getParent().getFolder((IPath)new Path("gen/src")).getFullPath();
                    String source = PlatformUtils.getPlatformURL(sourcePath);
                    Path javaSource = new Path(PlatformUtils.getPathFromPlatform(source));
                    String seiName = Signature.getSimpleName((String)seiInfo.getSEIName());
                    packageName = packageName.replace('.', '/');
                    javaSource = javaSource.append(packageName).append(String.valueOf(seiName) + ".java");
                    seiInfo.setSeiPath((IPath)javaSource);
                    URL platformURL = PlatformUtils.getCommandPlatformURL((IPath)javaSource);
                    seiInfo.setSEIURL(platformURL);
                }
            }
            finally {
                if (ejbArtifactEdit != null) {
                    ejbArtifactEdit.dispose();
                }
            }
        }
        cc.setImports(this.td.getSeiImports());
        cc.setMethods(this.td.getSeiMethodNames());
        cc.setEnvironment(this.getPlatformEnvironment());
        IStatus cmdStatus = cc.execute((IProgressMonitor)monitor, adaptable);
        if (cmdStatus.getException() != null) {
            RdPlugin.getDefault().getLog().log(cmdStatus);
        }
        if (cmdStatus.getSeverity() != 0) {
            return null;
        }
        this.seiInfo = cc.getSeiInfo();
        SaveWSDLInfo swi = new SaveWSDLInfo(this.td, this.freeFormProject, this.component, this.seiInfo.getSEIName());
        swi.process();
        return swi;
    }

    protected void prepareWsdl2JavaParameter(JavaWSDLParameterBase java2WsdlParm, JavaWSDLParameterBase wsdl2JavaParm, IPath moduleDDPath) {
        super.prepareWsdl2JavaParameter(java2WsdlParm, wsdl2JavaParm, moduleDDPath);
        String bindingTypes = java2WsdlParm.getBindingTypes();
        if (bindingTypes.indexOf("jms") != -1) {
            SOAPBindingJms soapBindingJms = this.td.getWebServicesClassLevelTags().getSOAPBindingJms();
            int jmsDestinationValue = soapBindingJms.getJmsDestination().getValue();
            wsdl2JavaParm.setJmsDestination(jmsDestinationValue == 0 ? "queue" : "topic");
            String activationSpecJndi = soapBindingJms.getActivationSpecJndi();
            if (activationSpecJndi != null) {
                wsdl2JavaParm.setMdbDeploymentMechanism((byte)0);
                wsdl2JavaParm.setMdbActivateName(activationSpecJndi);
            } else {
                String listenerPort = soapBindingJms.getListenerPort();
                wsdl2JavaParm.setMdbDeploymentMechanism((byte)1);
                wsdl2JavaParm.setMdbActivateName(listenerPort);
            }
        }
        EJBArtifactEdit ejbArtifactEdit = null;
        try {
            IVirtualComponent ejbClientComponent;
            ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)this.component);
            IPath genJavaOutputPath = this.freeFormProject != null ? this.freeFormProject.getFolder("gen/src").getFullPath() : ((ejbClientComponent = ejbArtifactEdit.getEJBClientJarModule()) != null ? ejbClientComponent.getRootFolder().getUnderlyingFolder().getParent().getFolder((IPath)new Path("gen/src")).getFullPath() : this.component.getRootFolder().getUnderlyingFolder().getParent().getFolder((IPath)new Path("gen/src")).getFullPath());
            wsdl2JavaParm.setDevelopServerJavaOutput(PlatformUtils.getPlatformURL(genJavaOutputPath));
        }
        finally {
            if (ejbArtifactEdit != null) {
                ejbArtifactEdit.dispose();
            }
        }
    }

    private IVirtualComponent createHttpRouterProject(final EJBArtifactEdit ejbArtifactEdit, final String routerProjectName, String routerModuleUri) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IProject routerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(routerProjectName);
                        if (routerProject.exists()) {
                            if (J2EEUtils.isWebProject((IProject)routerProject)) {
                                BeanToEJBWebService.this.routerProjectName_ = routerProjectName;
                            } else {
                                BeanToEJBWebService.this.routerProjectName_ = null;
                                WRDUtilFactory.getMonitor().monitor(RdPlugin.getDefault().getMessage("MSG_WARN_UNABLE_TO_CREATE_ROUTER", new Object[]{routerProjectName}), 1);
                            }
                            return;
                        }
                        BeanToEJBWebService.this.routerProjectName_ = routerProjectName;
                        int j2eeVersion = ejbArtifactEdit.getJ2EEVersion();
                        IProject ejbProject = ejbArtifactEdit.getProject();
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ejbProject);
                        if (facetedProject == null) {
                            throw new Exception("IFacetedProject is null.");
                        }
                        IRuntime runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getRuntime());
                        String runtimeTypeId = runtime.getRuntimeType().getId();
                        CreateModuleCommand cmd = new CreateModuleCommand();
                        cmd.setEnvironment(BeanToEJBWebService.this.env_);
                        cmd.setJ2eeLevel(J2EEVersionUtil.convertVersionIntToString((int)j2eeVersion));
                        cmd.setModuleName(BeanToEJBWebService.this.routerProjectName_);
                        cmd.setModuleType((byte)0);
                        cmd.setProjectName(BeanToEJBWebService.this.routerProjectName_);
                        IServerType[] serverTypes = ServerCore.getServerTypes();
                        String serverFactoryId = null;
                        IServer[] servers = ServerUtil.getServersByModule((IModule)ServerUtil.getModule((IProject)ejbProject), (IProgressMonitor)monitor);
                        if (servers.length > 0) {
                            cmd.setServerInstanceId(servers[0].getId());
                            serverFactoryId = servers[0].getServerType().getId();
                        } else {
                            int i = 0;
                            while (i < serverTypes.length) {
                                if (serverTypes[i].getRuntimeType().getId().equals(runtimeTypeId)) {
                                    serverFactoryId = serverTypes[i].getId();
                                    break;
                                }
                                ++i;
                            }
                        }
                        cmd.setServerFactoryId(serverFactoryId);
                        cmd.execute(monitor, null);
                        routerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(BeanToEJBWebService.this.routerProjectName_);
                    }
                    catch (Exception e) {
                        IStatus status = StatusUtils.errorStatus((String)e.getMessage(), (Throwable)e);
                        RdPlugin.getDefault().getLog().log(status);
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        if (this.routerProjectName_ != null) {
            IProject routerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.routerProjectName_);
            return ComponentCore.createComponent((IProject)routerProject);
        }
        return null;
    }

    private IVirtualComponent createJmsRouterProject(final EJBArtifactEdit ejbArtifactEdit, final String routerProjectName, String routerModuleUri) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IProject routerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(routerProjectName);
                        if (routerProject.exists()) {
                            if (J2EEUtils.isEJBProject((IProject)routerProject)) {
                                BeanToEJBWebService.this.routerProjectName_ = routerProjectName;
                            } else {
                                BeanToEJBWebService.this.routerProjectName_ = null;
                                WRDUtilFactory.getMonitor().monitor(RdPlugin.getDefault().getMessage("MSG_WARN_UNABLE_TO_CREATE_ROUTER", new Object[]{routerProjectName}), 1);
                            }
                            return;
                        }
                        BeanToEJBWebService.this.routerProjectName_ = routerProjectName;
                        int j2eeVersion = ejbArtifactEdit.getJ2EEVersion();
                        IProject ejbProject = ejbArtifactEdit.getProject();
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ejbProject);
                        if (facetedProject == null) {
                            throw new Exception("IFacetedProject is null.");
                        }
                        IRuntime runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getRuntime());
                        String runtimeTypeId = runtime.getRuntimeType().getId();
                        CreateModuleCommand cmd = new CreateModuleCommand();
                        cmd.setEnvironment(BeanToEJBWebService.this.env_);
                        cmd.setJ2eeLevel(J2EEVersionUtil.convertVersionIntToString((int)j2eeVersion));
                        cmd.setModuleName(BeanToEJBWebService.this.routerProjectName_);
                        cmd.setModuleType((byte)1);
                        cmd.setProjectName(BeanToEJBWebService.this.routerProjectName_);
                        IServerType[] serverTypes = ServerCore.getServerTypes();
                        String serverFactoryId = null;
                        IServer[] servers = ServerUtil.getServersByModule((IModule)ServerUtil.getModule((IProject)ejbProject), (IProgressMonitor)monitor);
                        if (servers.length > 0) {
                            cmd.setServerInstanceId(servers[0].getId());
                            serverFactoryId = servers[0].getServerType().getId();
                        } else {
                            int i = 0;
                            while (i < serverTypes.length) {
                                if (serverTypes[i].getRuntimeType().getId().equals(runtimeTypeId)) {
                                    serverFactoryId = serverTypes[i].getId();
                                    break;
                                }
                                ++i;
                            }
                        }
                        cmd.setServerFactoryId(serverFactoryId);
                        cmd.execute(monitor, null);
                        routerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(BeanToEJBWebService.this.routerProjectName_);
                    }
                    catch (Exception e) {
                        IStatus status = StatusUtils.errorStatus((String)e.getMessage(), (Throwable)e);
                        RdPlugin.getDefault().getLog().log(status);
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        if (this.routerProjectName_ != null) {
            IProject routerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.routerProjectName_);
            return ComponentCore.createComponent((IProject)routerProject);
        }
        return null;
    }

    private IVirtualComponent[] getHttpRouters(EJBArtifactEdit ejbArtifactEdit) {
        return this.getRouters(ejbArtifactEdit, (byte)0);
    }

    private final void populateRouterRequestInfo(ArrayList routerComponentsList, ArrayList earComponentsNeedingRouter, IVirtualComponent[] earComponents, String routerModuleUri) {
        int i = 0;
        while (i < earComponents.length) {
            EARArtifactEdit earArtifactEdit = null;
            try {
                earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)earComponents[i]);
                IVirtualComponent routerComponent = earArtifactEdit.getModule(routerModuleUri);
                if (routerComponent == null) {
                    earComponentsNeedingRouter.add(earComponents[i]);
                } else {
                    routerComponentsList.add(routerComponent);
                    this.routerProjectName_ = routerComponent.getProject().getName();
                }
            }
            finally {
                if (earArtifactEdit != null) {
                    earArtifactEdit.dispose();
                }
            }
            ++i;
        }
    }

    private final IVirtualComponent[] getRouters(EJBArtifactEdit ejbArtifactEdit, byte routerType) {
        String routerModuleTransport;
        String routerModuleUri;
        String routerProjectName;
        ArrayList<IVirtualComponent> routerComponentsList = new ArrayList<IVirtualComponent>();
        IVirtualComponent ejbComponent = ejbArtifactEdit.getComponent();
        IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)this.component.getProject());
        if (earProjects.length == 0) {
            return new IVirtualComponent[0];
        }
        IVirtualComponent[] earComponents = new IVirtualComponent[earProjects.length];
        int i = 0;
        while (i < earProjects.length) {
            earComponents[i] = ComponentCore.createComponent((IProject)earProjects[i]);
            ++i;
        }
        ArrayList earComponentsNeedingRouter = new ArrayList();
        StringBuffer routerModuleUriPrefix = new StringBuffer(ejbComponent.getProject().getName()).append('_').append(this.component.getName());
        if (routerType == 0) {
            routerProjectName = routerModuleUriPrefix.append("_http_router").toString();
            routerModuleUri = routerModuleUriPrefix.append(".war").toString();
            routerModuleTransport = "http";
        } else {
            routerProjectName = routerModuleUriPrefix.append("_jms_router").toString();
            routerModuleUri = routerModuleUriPrefix.append(".jar").toString();
            routerModuleTransport = "jms";
        }
        WsbndArtifactEdit wsBndArtifactEdit = null;
        try {
            wsBndArtifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IVirtualComponent)ejbComponent);
            WSBinding wsBinding = wsBndArtifactEdit.getWSBinding();
            EList routerModules = wsBinding.getRouterModules();
            if (routerModules.size() > 0) {
                boolean foundMatchingRouter = false;
                for (RouterModule r : routerModules) {
                    if (!r.getTransport().equalsIgnoreCase(routerModuleTransport)) continue;
                    routerModuleUri = r.getName();
                    this.populateRouterRequestInfo(routerComponentsList, earComponentsNeedingRouter, earComponents, routerModuleUri);
                    foundMatchingRouter = true;
                    break;
                }
                if (!foundMatchingRouter) {
                    this.populateRouterRequestInfo(routerComponentsList, earComponentsNeedingRouter, earComponents, routerModuleUri);
                }
            } else {
                this.populateRouterRequestInfo(routerComponentsList, earComponentsNeedingRouter, earComponents, routerModuleUri);
            }
        }
        finally {
            if (wsBndArtifactEdit != null) {
                wsBndArtifactEdit.dispose();
            }
        }
        ArrayList<IVirtualComponent> addArchives = new ArrayList<IVirtualComponent>();
        for (IVirtualComponent earComponentNeedingRouter : earComponentsNeedingRouter) {
            IVirtualComponent routerComponent;
            IVirtualComponent iVirtualComponent = routerComponent = routerType == 1 ? this.createJmsRouterProject(ejbArtifactEdit, routerProjectName, routerModuleUri) : this.createHttpRouterProject(ejbArtifactEdit, routerProjectName, routerModuleUri);
            if (routerComponent == null) continue;
            routerComponentsList.add(routerComponent);
            addArchives.clear();
            addArchives.add(routerComponent);
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
            model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComponentNeedingRouter);
            model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", addArchives);
            try {
                model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                IStatus status = StatusUtils.errorStatus((String)e.getMessage(), (Throwable)e);
                RdPlugin.getDefault().getLog().log(status);
            }
        }
        IVirtualComponent[] routerComponents = new IVirtualComponent[routerComponentsList.size()];
        routerComponentsList.toArray(routerComponents);
        return routerComponents;
    }

    private IVirtualComponent[] getJmsRouters(EJBArtifactEdit ejbArtifactEdit) {
        return this.getRouters(ejbArtifactEdit, (byte)1);
    }

    private final IStatus updateDeploymentDescriptors(IProject targetProject, IVirtualComponent[] httpRouterModules, IVirtualComponent[] jmsRouterModules, JavaWSDLParameterBase wsdl2JavaParm, AbstractEmitterCommand wsdl2JavaCommand, SaveWSDLInfo swi) {
        int i;
        IStatus status = Status.OK_STATUS;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAdaptable adaptable = null;
        BuildWSDLPort2ImplBeanMappingTask task = new BuildWSDLPort2ImplBeanMappingTask(wsdl2JavaParm, false);
        task.setWsdl2JavaCommand(wsdl2JavaCommand);
        task.setWSParser((WebServicesParser)new WebServicesParserExt());
        task.setEnvironment(this.env_);
        status = task.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() >= 4) {
            return status;
        }
        UpdateWebServicesXmlCommand updateWebServicesXmlCmd = new UpdateWebServicesXmlCommand();
        updateWebServicesXmlCmd.setIsFreeFormJ2ee14(this.freeFormProject != null && swi.getTargetJ2eeVersion().equals("1.4"));
        updateWebServicesXmlCmd.setJavaWSDLParam(wsdl2JavaParm);
        updateWebServicesXmlCmd.setEJBProjectName(targetProject.getName());
        updateWebServicesXmlCmd.setEjbName(swi.getEJBName());
        updateWebServicesXmlCmd.setEnvironment(this.env_);
        status = updateWebServicesXmlCmd.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() >= 4) {
            return status;
        }
        if (wsdl2JavaParm.getBindingTypes().indexOf("http") != -1) {
            UpdateWEBXMLOperation updateWebXmlCmd = new UpdateWEBXMLOperation();
            updateWebXmlCmd.setJavaWSDLParam(wsdl2JavaParm);
            i = 0;
            while (i < httpRouterModules.length) {
                updateWebXmlCmd.setServiceProject(httpRouterModules[i].getProject());
                updateWebXmlCmd.setEnvironment(this.env_);
                status = updateWebXmlCmd.execute((IProgressMonitor)monitor, adaptable);
                if (status.getSeverity() >= 4) {
                    return status;
                }
                ++i;
            }
        }
        if (wsdl2JavaParm.getBindingTypes().indexOf("jms") != -1) {
            UpdateJMSRouterCommand updateJmsRouterCmd = new UpdateJMSRouterCommand();
            updateJmsRouterCmd.setJavaWSDLParam(wsdl2JavaParm);
            i = 0;
            while (i < jmsRouterModules.length) {
                updateJmsRouterCmd.setServiceProject(jmsRouterModules[i].getProject());
                updateJmsRouterCmd.setEnvironment(this.env_);
                status = updateJmsRouterCmd.execute((IProgressMonitor)monitor, adaptable);
                if (status.getSeverity() >= 4) {
                    return status;
                }
                ++i;
            }
        }
        AddServiceEndpointToEJBJarXMLCommand addServiceEndpointToEJBJarXMLCommand = new AddServiceEndpointToEJBJarXMLCommand();
        addServiceEndpointToEJBJarXMLCommand.setJavaWSDLParam(wsdl2JavaParm);
        addServiceEndpointToEJBJarXMLCommand.setEjbProject(targetProject);
        addServiceEndpointToEJBJarXMLCommand.setEjbName(swi.getEJBName());
        addServiceEndpointToEJBJarXMLCommand.setEnvironment(this.env_);
        status = addServiceEndpointToEJBJarXMLCommand.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() >= 4) {
            return status;
        }
        UpdateIBMWebServicesExtXMICommand updateIBMWebServicesExtXMICmd = new UpdateIBMWebServicesExtXMICommand();
        updateIBMWebServicesExtXMICmd.setJavaWSDLParam(wsdl2JavaParm);
        updateIBMWebServicesExtXMICmd.setEJBProjectName(targetProject.getName());
        updateIBMWebServicesExtXMICmd.setEnvironment(this.env_);
        status = updateIBMWebServicesExtXMICmd.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() >= 4) {
            return status;
        }
        UpdateIBMWebServicesBndXMICommand updateIBMWebServicesBndXMICmd = new UpdateIBMWebServicesBndXMICommand();
        updateIBMWebServicesBndXMICmd.setJavaWSDLParam(wsdl2JavaParm);
        updateIBMWebServicesBndXMICmd.setEJBProjectName(targetProject.getName());
        if (httpRouterModules != null && httpRouterModules.length > 0) {
            updateIBMWebServicesBndXMICmd.setServiceProject(httpRouterModules[0].getProject());
        } else {
            updateIBMWebServicesBndXMICmd.setServiceProject(null);
        }
        if (jmsRouterModules != null && jmsRouterModules.length > 0) {
            updateIBMWebServicesBndXMICmd.setJmsRouterProject(jmsRouterModules[0].getProject());
        } else {
            updateIBMWebServicesBndXMICmd.setJmsRouterProject(null);
        }
        updateIBMWebServicesBndXMICmd.setEnvironment(this.env_);
        status = updateIBMWebServicesBndXMICmd.execute((IProgressMonitor)monitor, adaptable);
        if (status.getSeverity() >= 4) {
            return status;
        }
        DeleteTempOutputCommand deleteTempOutputCmd = new DeleteTempOutputCommand();
        deleteTempOutputCmd.setJavaWSDLParam(wsdl2JavaParm);
        deleteTempOutputCmd.execute((IProgressMonitor)monitor, adaptable);
        ManageDeployFlagCommand manageDeployCmd = new ManageDeployFlagCommand();
        manageDeployCmd.setEnvironment(this.env_);
        manageDeployCmd.setProject(targetProject);
        manageDeployCmd.execute((IProgressMonitor)monitor, adaptable);
        return status;
    }

    private final IStatus deleteUnwantedRIHomeGeneratedFiles(JavaWSDLParameterBase wsdl2JavaParm) {
        IPath riFilePath;
        IStatus status = Status.OK_STATUS;
        String rootPathString = PlatformUtils.getPathFromPlatform(wsdl2JavaParm.getDevelopServerJavaOutput());
        IPath rootPath = new Path(rootPathString).addTrailingSeparator();
        String beanName = wsdl2JavaParm.getBeanName();
        String beanNameAsPaths = beanName.replace('.', '/');
        ArrayList ejbIntfAndHomeClassNames = this.td.getEjbInterfaceAndHomeClasses();
        if (!ejbIntfAndHomeClassNames.contains(String.valueOf(beanName) + "_RI") && (status = this.deleteUnwantedFile(riFilePath = rootPath.append(String.valueOf(beanNameAsPaths) + "_RI.java"))).getSeverity() >= 4) {
            return status;
        }
        if (!ejbIntfAndHomeClassNames.contains(String.valueOf(beanName) + "Home")) {
            IPath homeFile = rootPath.append(String.valueOf(beanNameAsPaths) + "Home.java");
            status = this.deleteUnwantedFile(homeFile);
        }
        return status;
    }

    protected void processSaveWSDLInfo(SaveWSDLInfo swi) {
        IStatus status;
        IVirtualComponent[] httpRouterModules = null;
        IVirtualComponent[] jmsRouterModules = null;
        boolean hasSoapBindingHttp = this.td.hasSoapBindingHttp();
        boolean hasSoapBindingJms = this.td.hasSoapBindingJms();
        boolean hasEjbBinding = this.td.hasEjbBinding();
        EJBArtifactEdit ejbArtifactEdit = null;
        String httpRouterProjectName = null;
        try {
            ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)this.component);
            if (hasSoapBindingHttp) {
                httpRouterModules = this.getHttpRouters(ejbArtifactEdit);
                httpRouterProjectName = this.routerProjectName_;
            }
            if (hasSoapBindingJms) {
                jmsRouterModules = this.getJmsRouters(ejbArtifactEdit);
            }
            if (!(hasSoapBindingHttp || hasSoapBindingJms || hasEjbBinding)) {
                httpRouterModules = this.getHttpRouters(ejbArtifactEdit);
                httpRouterProjectName = this.routerProjectName_;
            }
        }
        finally {
            if (ejbArtifactEdit != null) {
                ejbArtifactEdit.dispose();
            }
        }
        JavaWSDLParameterBase java2WsdlParm = swi.getJava2WSDLParameter();
        EmitterCommandsExtension emitterExtension = swi.getEmitterExtension();
        IVirtualFolder metaInfFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)this.component);
        IPath targetWsdlRootPath = metaInfFolder.getWorkspaceRelativePath();
        String portComponentName = swi.getBeanName();
        if (httpRouterProjectName != null) {
            this.setHttpEndpointUrlInfo(java2WsdlParm, ResourcesPlugin.getWorkspace().getRoot().getProject(httpRouterProjectName), portComponentName);
        }
        if ((status = this.invokeJava2Wsdl(java2WsdlParm, emitterExtension.getJava2WsdlCommand(), targetWsdlRootPath, portComponentName)).getSeverity() >= 4) {
            WRDUtilFactory.getMonitor().monitor(status.getMessage(), 4);
            return;
        }
        IPath moduleDDPath = this.component.getRootFolder().getWorkspaceRelativePath();
        JavaWSDLParameterBase wsdl2JavaParm = emitterExtension.getJavaWSDLParam();
        this.prepareWsdl2JavaParameter(java2WsdlParm, wsdl2JavaParm, moduleDDPath);
        AbstractEmitterCommand wsdl2JavaCommand = emitterExtension.getWsdl2JavaCommand();
        status = this.invokeWsdl2Java(wsdl2JavaParm, wsdl2JavaCommand);
        if (status.getSeverity() >= 4) {
            WRDUtilFactory.getMonitor().monitor(status.getMessage(), 4);
            return;
        }
        status = this.deleteUnwantedRIHomeGeneratedFiles(wsdl2JavaParm);
        if (status.getSeverity() >= 4) {
            WRDUtilFactory.getMonitor().monitor(status.getMessage(), 4);
            return;
        }
        status = this.deleteUnwantedSEI(wsdl2JavaParm);
        if (status.getSeverity() >= 4) {
            WRDUtilFactory.getMonitor().monitor(status.getMessage(), 4);
            return;
        }
        status = this.deleteUnwantedSoapBindingImpl(wsdl2JavaParm);
        if (status.getSeverity() >= 4) {
            WRDUtilFactory.getMonitor().monitor(status.getMessage(), 4);
            return;
        }
        status = this.updateDeploymentDescriptors(this.component.getProject(), httpRouterModules, jmsRouterModules, wsdl2JavaParm, wsdl2JavaCommand, swi);
        if (status.getSeverity() >= 4) {
            WRDUtilFactory.getMonitor().monitor(status.getMessage(), 4);
            return;
        }
    }
}

