/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.taghandler;

import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebServicesClassLevelTags;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebServicesMethodLevelTags;
import com.ibm.ast.ws.rd.taghandler.WSConstants;
import com.ibm.etools.annotations.EjbDoclet.EjbClassLevelTags;
import com.ibm.etools.annotations.EjbDoclet.Home;
import com.ibm.etools.annotations.EjbDoclet.Interface;
import com.ibm.etools.wrd.extensions.util.AnnotationUtil;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class WSInfo {
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private EjbClassLevelTags ejbClassLevelTags_;
    private boolean hasEjbSessionTag_;
    private boolean hasEjbBeanTag_;
    private String ejbName_;
    private boolean hasSoapBindingHttp_;
    private boolean hasSoapBindingJms_;
    private boolean hasEjbBinding_;
    private ArrayList ejbIntfAndHomeClassNames_;
    private WebServicesClassLevelTags wsClassLevelTags_;
    private ArrayList allWsMethodLevelTags_;
    private ArrayList seiMethods;
    private IType javaType_;

    WSInfo(IType javaType) {
        this.javaType_ = javaType;
        this.seiMethods = new ArrayList();
        this.ejbIntfAndHomeClassNames_ = new ArrayList();
        this.wsClassLevelTags_ = null;
        this.ejbClassLevelTags_ = null;
        this.allWsMethodLevelTags_ = new ArrayList();
    }

    public void setWebServicesClassLevelTags(WebServicesClassLevelTags wsClassLevelTags) {
        this.wsClassLevelTags_ = wsClassLevelTags;
        this.hasSoapBindingHttp_ = this.wsClassLevelTags_.getSOAPBinding() != null;
        this.hasSoapBindingJms_ = this.wsClassLevelTags_.getSOAPBindingJms() != null;
        this.hasEjbBinding_ = this.wsClassLevelTags_.getEJBBinding() != null;
    }

    public WebServicesClassLevelTags getWebServicesClassLevelTags() {
        return this.wsClassLevelTags_;
    }

    public void addWebServicesMethodLevelTags(WebServicesMethodLevelTags wsMethodLevelTags) {
        this.allWsMethodLevelTags_.add(wsMethodLevelTags);
        if (wsMethodLevelTags.getWebMethod() != null) {
            IMethod method = (IMethod)AnnotationUtil.INSTANCE.getJavaElementFromDoclet((EObject)wsMethodLevelTags);
            this.seiMethods.add(method);
        }
    }

    public ArrayList getAllWebServicesMethodLevelTags() {
        return this.allWsMethodLevelTags_;
    }

    public ArrayList getSeiMethods() {
        return this.seiMethods;
    }

    public String[] getSeiMethodNames() {
        ArrayList<String> results = new ArrayList<String>();
        StringBuffer resultBuffer = new StringBuffer();
        int i = 0;
        while (i < this.seiMethods.size()) {
            boolean addRemoteException = true;
            resultBuffer.setLength(0);
            IMethod m = (IMethod)this.seiMethods.get(i);
            try {
                resultBuffer.append(Signature.toString((String)m.getSignature(), (String)m.getElementName(), (String[])m.getParameterNames(), (boolean)true, (boolean)true));
                String[] exceptionTypes = m.getExceptionTypes();
                resultBuffer.append(" throws ");
                int j = 0;
                while (j < exceptionTypes.length) {
                    if (j > 0) {
                        resultBuffer.append(", ");
                    }
                    String exceptionType = Signature.toString((String)exceptionTypes[j]);
                    resultBuffer.append(exceptionType);
                    if (addRemoteException) {
                        String[][] resolvedTypes = this.javaType_.resolveType(exceptionType);
                        int k = 0;
                        while (k < resolvedTypes.length) {
                            if (resolvedTypes[k][0].equals("java.rmi") && resolvedTypes[k][1].equals("RemoteException")) {
                                addRemoteException = false;
                            }
                            ++k;
                        }
                    }
                    if (j == exceptionTypes.length - 1) {
                        if (addRemoteException) {
                            resultBuffer.append(", ");
                        } else {
                            resultBuffer.append(';');
                        }
                    }
                    ++j;
                }
                if (addRemoteException) {
                    resultBuffer.append("java.rmi.RemoteException;");
                }
                results.add(resultBuffer.toString());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        String[] seiMethodNames = new String[results.size()];
        results.toArray(seiMethodNames);
        return seiMethodNames;
    }

    public void setJavaType(IType javaType) {
        this.javaType_ = javaType;
    }

    public IType getJavaType() {
        return this.javaType_;
    }

    public void setSeiMethods(ArrayList list) {
        this.seiMethods = list;
    }

    public String getSeiImports() {
        StringBuffer seiImports = new StringBuffer();
        try {
            IImportDeclaration[] imports = this.javaType_.getCompilationUnit().getImports();
            int i = 0;
            while (i < imports.length) {
                seiImports.append("import ").append(imports[i].getElementName()).append(';').append(this.LINE_SEPARATOR);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return seiImports.toString();
    }

    public boolean hasSoapBindingHttp() {
        return this.hasSoapBindingHttp_;
    }

    public boolean hasSoapBindingJms() {
        return this.hasSoapBindingJms_;
    }

    public boolean hasEjbBinding() {
        return this.hasEjbBinding_;
    }

    public boolean hasEjbSessionTag() {
        return this.hasEjbSessionTag_;
    }

    public boolean hasEjbBeanTag() {
        return this.hasEjbBeanTag_;
    }

    public boolean isEjbWebServiceScenario() {
        return this.hasEjbSessionTag_ || this.hasEjbBeanTag_;
    }

    public String getEjbName() {
        return this.ejbName_;
    }

    private final void addEjbInterfaceAndHomeClasses(String remoteClass, String localClass) {
        if (remoteClass != null) {
            this.ejbIntfAndHomeClassNames_.add(remoteClass);
        }
        if (localClass != null) {
            this.ejbIntfAndHomeClassNames_.add(localClass);
        }
    }

    public ArrayList getEjbInterfaceAndHomeClasses() {
        return this.ejbIntfAndHomeClassNames_;
    }

    public void setEjbClassLevelTags(EjbClassLevelTags ejbClassLevelTags) {
        this.ejbClassLevelTags_ = ejbClassLevelTags;
        this.hasEjbBeanTag_ = true;
        this.ejbName_ = this.ejbClassLevelTags_.getBean().getName();
        Interface ejbInterface = this.ejbClassLevelTags_.getInterface();
        Home ejbHome = this.ejbClassLevelTags_.getHome();
        if (ejbInterface != null) {
            this.addEjbInterfaceAndHomeClasses(ejbInterface.getRemoteClass(), ejbInterface.getLocalClass());
        }
        if (ejbHome != null) {
            this.addEjbInterfaceAndHomeClasses(ejbHome.getRemoteClass(), ejbHome.getLocalClass());
        }
    }

    public void collectImplicitSEIMethods() {
        IMethod[] methods = null;
        try {
            methods = this.javaType_.getMethods();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        boolean isEjbScenario = this.ejbClassLevelTags_ != null;
        int i = 0;
        while (i < methods.length) {
            try {
                int flags = methods[i].getFlags();
                if (!(!Flags.isPublic((int)flags) || Flags.isStatic((int)flags) || methods[i].isConstructor() || isEjbScenario && this.isEJBMethod(methods[i]))) {
                    this.seiMethods.add(methods[i]);
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
    }

    private boolean isEJBMethod(IMethod m) {
        String name = m.getElementName();
        if (name.equals(WSConstants.ejbRemove)) {
            return true;
        }
        if (name.equals(WSConstants.ejbActivate)) {
            return true;
        }
        if (name.equals(WSConstants.ejbCreate)) {
            return true;
        }
        if (name.equals(WSConstants.ejbPassivate)) {
            return true;
        }
        if (name.equals(WSConstants.setSessionContext) && m.getNumberOfParameters() == 1) {
            return true;
        }
        return name.equals(WSConstants.getSessionContext);
    }
}

