/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.taghandler;

import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebServicesClassLevelTags;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebServicesDocletPackage;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebServicesMethodLevelTags;
import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.taghandler.WSInfo;
import com.ibm.ast.ws.rd.taghandler.WSModelContentHandler;
import com.ibm.ast.ws.rd.taghandler.scenarios.WSTagProcessor;
import com.ibm.etools.annotations.EjbDoclet.EjbClassLevelTags;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.wrd.extensions.dynamic.model.DynamicModelAnnotationTagHandler;
import com.ibm.etools.wrd.extensions.dynamic.model.DynamicModelTagSetRegistrationOptions;
import com.ibm.etools.wrd.extensions.transform.ModelContentHandler;
import com.ibm.ws.rd.WRDFreeFormNature;
import com.ibm.ws.rd.annotations.core.MethodTagData;
import com.ibm.ws.rd.annotations.core.TagData;
import com.ibm.ws.rd.annotations.core.TagProcessingException;
import com.ibm.ws.rd.annotations.core.TypeTagData;
import com.ibm.ws.rd.j2ee.utils.J2EEEnvironment;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WASWSHandler
extends DynamicModelAnnotationTagHandler {
    public static final String EANNOTATION_SOURCE = "com.ibm.ast.ws.rd";
    private boolean isWebSphereWebServiceTagPresent_;
    private boolean hasErrors_;

    public WASWSHandler() {
        DynamicModelTagSetRegistrationOptions options = new DynamicModelTagSetRegistrationOptions((EPackage)WebServicesDocletPackage.eINSTANCE);
        options.setParentTagSet("ejb");
        options.setTypeName(0, "WebServicesMethodLevelTags");
        options.setTypeName(1, "WebServicesClassLevelTags");
        this.registerTags(options);
    }

    protected void doBeginResource(IResource res) throws TagProcessingException {
        this.isWebSphereWebServiceTagPresent_ = false;
        this.hasErrors_ = false;
    }

    protected void doEndBuild(IProject project) {
        super.doEndBuild(project);
        if (this.hasErrors_) {
            return;
        }
        if (this.hasAnyChanges()) {
            WSModelContentHandler handler = new WSModelContentHandler(project);
            this.transformAll((ModelContentHandler)handler);
        }
        Set annotatedCUs = this.getAnnotatedCUs();
        if (WRDFreeFormNature.hasNature((IProject)project)) {
            this.processCompilationUnits(project, null, annotatedCUs);
        } else {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            if (J2EEUtils.isWebProject((IProject)project) || J2EEUtils.isEJBProject((IProject)project)) {
                this.processCompilationUnits(null, vc, annotatedCUs);
            }
        }
    }

    private void processCompilationUnits(IProject freeFormProject, IVirtualComponent component, Collection compilationUnits) {
        String componentFolderPathStr = "";
        if (component != null) {
            componentFolderPathStr = component.getRootFolder().getUnderlyingFolder().getParent().getFullPath().addTrailingSeparator().toString();
        }
        Iterator i = compilationUnits.iterator();
        while (i.hasNext()) {
            ICompilationUnit compilationUnit = (ICompilationUnit)i.next();
            IType[] javaTypes = null;
            try {
                if (!compilationUnit.getCorrespondingResource().getFullPath().toString().startsWith(componentFolderPathStr)) continue;
                javaTypes = compilationUnit.getTypes();
            }
            catch (JavaModelException javaModelException) {
                javaTypes = new IType[]{};
            }
            int j = 0;
            while (j < javaTypes.length) {
                WSInfo wsInfo = new WSInfo(javaTypes[j]);
                EClass eClass = this.getJavaClass(javaTypes[j]);
                EAnnotation eAnn = eClass.getEAnnotation(EANNOTATION_SOURCE);
                if (eAnn != null && !eAnn.getContents().isEmpty()) {
                    WebServicesClassLevelTags classLevelTags = (WebServicesClassLevelTags)eAnn.getContents().get(0);
                    wsInfo.setWebServicesClassLevelTags(classLevelTags);
                }
                if ((eAnn = eClass.getEAnnotation("com.ibm.ws.rd.j2ee.taghandlers.ejb")) != null && !eAnn.getContents().isEmpty()) {
                    EjbClassLevelTags ejbClassLevelTags = (EjbClassLevelTags)eAnn.getContents().get(0);
                    wsInfo.setEjbClassLevelTags(ejbClassLevelTags);
                }
                EList eOperationsList = eClass.getEOperations();
                for (EOperation eOp : eOperationsList) {
                    eAnn = eOp.getEAnnotation(EANNOTATION_SOURCE);
                    if (eAnn == null || eAnn.getContents().isEmpty()) continue;
                    WebServicesMethodLevelTags methodLevelTags = (WebServicesMethodLevelTags)eAnn.getContents().get(0);
                    wsInfo.addWebServicesMethodLevelTags(methodLevelTags);
                }
                if (wsInfo.getSeiMethods().isEmpty()) {
                    wsInfo.collectImplicitSEIMethods();
                }
                WSTagProcessor.process(wsInfo, freeFormProject, component);
                ++j;
            }
            i.remove();
        }
    }

    protected String getEAnnotationSource() {
        return EANNOTATION_SOURCE;
    }

    protected URI getMetaURI() {
        return null;
    }

    protected String getMetaBundleName() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doValidateTag(TagData tagData) {
        MethodTagData methodTagData;
        if (tagData.isTypeTag()) {
            TypeTagData typeTagData = (TypeTagData)tagData;
            String typeTagDataName = typeTagData.getName();
            if (typeTagDataName.equals("WebSphere.WebService")) {
                this.isWebSphereWebServiceTagPresent_ = true;
                return true;
            }
            if (typeTagDataName.equals("WebSphere.SOAPBinding")) {
                if (this.isWebSphereWebServiceTagPresent_) {
                    return true;
                }
                tagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.13"));
                this.hasErrors_ = true;
                return false;
            }
            if (typeTagDataName.equals("WebSphere.SOAPBinding-jms")) {
                String listenerPort = typeTagData.get("listenerPort");
                String activationSpecJndi = typeTagData.get("activationSpecJndi");
                if (listenerPort != null && activationSpecJndi != null) {
                    tagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.19"));
                    this.hasErrors_ = true;
                    return false;
                }
                if (listenerPort == null && activationSpecJndi == null) {
                    tagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.20"));
                    this.hasErrors_ = true;
                    return false;
                }
                IProject freeFormProject = tagData.getResource().getProject();
                IVirtualComponent earComponent = J2EEEnvironment.getApplicationComponent((IProject)freeFormProject, (boolean)true);
                if (earComponent == null) {
                } else {
                    earComponent.getProject();
                }
                if (this.isWebSphereWebServiceTagPresent_) {
                    return true;
                }
                tagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.11"));
                this.hasErrors_ = true;
                return false;
            }
            if (typeTagDataName.equals("WebSphere.EJBBinding")) {
                if (this.isWebSphereWebServiceTagPresent_) {
                    return true;
                }
                tagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.15"));
                this.hasErrors_ = true;
                return false;
            }
            if (!typeTagDataName.equals("@ejb.session") && !typeTagDataName.equals("ejb.bean")) return true;
            if (!this.isWebSphereWebServiceTagPresent_) {
                return true;
            }
            String beanType = typeTagData.get("type");
            if (beanType == null) {
                return true;
            }
            if (beanType.equalsIgnoreCase("Stateless")) {
                String beanName = typeTagData.get("name");
                if (beanName != null) return true;
                return true;
            }
            tagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.17"));
            this.hasErrors_ = true;
            return false;
        }
        if (!tagData.isMethodTag() || !(methodTagData = (MethodTagData)tagData).getName().equals("WebSphere.WebMethod")) return true;
        if (!this.isWebSphereWebServiceTagPresent_) {
            methodTagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.6"));
            this.hasErrors_ = true;
            return false;
        }
        MethodDeclaration m = methodTagData.getMethodDeclaration();
        int modifiers = m.getModifiers();
        if (!Modifier.isPublic((int)modifiers)) {
            methodTagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.7"));
            this.hasErrors_ = true;
            return false;
        }
        if (Modifier.isStatic((int)modifiers)) {
            methodTagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.8"));
            this.hasErrors_ = true;
            return false;
        }
        if (!m.isConstructor()) return true;
        methodTagData.addErr(RdPlugin.getDefault().getMessage("WASWSHandler.9"));
        this.hasErrors_ = true;
        return false;
    }
}

