/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.operation;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.Hashtable;
import java.util.Map;
import javax.wsdl.Port;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebapplicationFactoryImpl;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateWEBXMLOperation
extends AbstractDataModelOperation {
    private final String ejbDisplayName = "Web Services Router Servlet";
    private final String ejbServletClass = "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet";
    private final String serviceUrlPatternPrefix = "services/";
    private JavaWSDLParameterBase javaWSDLParam = null;
    private IProject serviceProject;
    private Hashtable servletClassCount;

    public UpdateWEBXMLOperation() {
    }

    public UpdateWEBXMLOperation(JavaWSDLParameterBase javaWSDLParam) {
        this();
        this.javaWSDLParam = javaWSDLParam;
    }

    public UpdateWEBXMLOperation(String name, String description, JavaWSDLParameterBase javaWSDLParam) {
        this(javaWSDLParam);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = super.getEnvironment();
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"));
        }
        if (this.javaWSDLParam.getServerSide() == 2) {
            return this.executeEJB(environment);
        }
        return this.executeJavaBean(environment);
    }

    private IStatus executeJavaBean(IEnvironment environment) {
        if (this.serviceProject != null) {
            String implBeanClassName;
            Map wsdlPort2ImplBeanMapping = this.javaWSDLParam.getWSDLPort2ImplBeanMapping();
            try {
                this.servletClassCount = new Hashtable();
                for (Port port : wsdlPort2ImplBeanMapping.keySet()) {
                    implBeanClassName = (String)wsdlPort2ImplBeanMapping.get(port);
                    if (this.servletClassCount.containsKey(implBeanClassName)) {
                        Integer originalCnt = (Integer)this.servletClassCount.get(implBeanClassName);
                        this.servletClassCount.put(implBeanClassName, new Integer(originalCnt + 1));
                        continue;
                    }
                    this.servletClassCount.put(implBeanClassName, new Integer(1));
                }
            }
            catch (Exception exception) {}
            for (Port port : wsdlPort2ImplBeanMapping.keySet()) {
                implBeanClassName = (String)wsdlPort2ImplBeanMapping.get(port);
                this.addServlet(this.serviceProject, implBeanClassName.replace('.', '_'), implBeanClassName, false, port.getName());
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus executeEJB(IEnvironment environment) {
        if (this.serviceProject != null) {
            Map wsdlPort2ImplBeanMapping = this.javaWSDLParam.getWSDLPort2ImplBeanMapping();
            for (Port port : wsdlPort2ImplBeanMapping.keySet()) {
                this.addServlet(this.serviceProject, port.getName(), "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet", true, null);
            }
        }
        return Status.OK_STATUS;
    }

    public void addServlet(IProject webProject, String servletName, String servletClass, boolean isEJB, String servletMappingName) {
        block22: {
            WebArtifactEdit webEdit = null;
            try {
                try {
                    Integer referenceCnt;
                    WebApp webapp = null;
                    webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)webProject);
                    if (webEdit == null) break block22;
                    webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
                    boolean foundServlet = false;
                    Servlet foundServletInstance = null;
                    EList theServlets = webapp.getServlets();
                    int i = 0;
                    while (i < theServlets.size()) {
                        Servlet aServlet = (Servlet)theServlets.get(i);
                        if (aServlet.getServletName().equals(servletName)) {
                            foundServlet = true;
                            foundServletInstance = aServlet;
                            break;
                        }
                        ++i;
                    }
                    boolean needToAddMapping = true;
                    if (this.servletClassCount != null && this.servletClassCount.containsKey(servletClass) && (referenceCnt = (Integer)this.servletClassCount.get(servletClass)) > 1) {
                        needToAddMapping = false;
                    }
                    if (foundServlet) {
                        boolean foundServletMapping = false;
                        StringBuffer servletURLPattern = new StringBuffer();
                        if (isEJB) {
                            servletURLPattern.append("services/").append(servletName);
                        } else {
                            servletURLPattern.append("services/").append(servletMappingName);
                        }
                        EList servletMappings = webapp.getServletMappings();
                        int i2 = 0;
                        while (i2 < servletMappings.size()) {
                            ServletMapping servletMapping = (ServletMapping)servletMappings.get(i2);
                            if (servletMapping.getServlet() != null && servletMapping.getServlet().equals(foundServletInstance) && servletMapping.getUrlPattern() != null && servletMapping.getUrlPattern().equals(servletURLPattern.toString())) {
                                foundServletMapping = true;
                                break;
                            }
                            ++i2;
                        }
                        if (needToAddMapping && !foundServletMapping) {
                            WebapplicationFactoryImpl factory = new WebapplicationFactoryImpl();
                            ServletMapping servletMapping1 = factory.createServletMapping();
                            servletMapping1.setServlet(foundServletInstance);
                            servletMapping1.setUrlPattern(servletURLPattern.toString());
                            webapp.getServletMappings().add((Object)servletMapping1);
                            webEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        }
                        break block22;
                    }
                    WebapplicationFactoryImpl factory = new WebapplicationFactoryImpl();
                    Servlet servlet = factory.createServlet();
                    ServletType servletType = factory.createServletType();
                    ServletMapping servletMapping1 = factory.createServletMapping();
                    servletType.setClassName(servletClass);
                    servlet.setServletName(servletName);
                    if (isEJB) {
                        servlet.setDisplayName("Web Services Router Servlet");
                    } else {
                        servlet.setLoadOnStartup(new Integer(1));
                    }
                    servlet.setWebType((WebType)servletType);
                    if (needToAddMapping && isEJB) {
                        servletMapping1.setServlet(servlet);
                        servletMapping1.setUrlPattern("services/" + servletName);
                    } else if (needToAddMapping && servletMappingName != null) {
                        servletMapping1.setServlet(servlet);
                        servletMapping1.setUrlPattern("services/" + servletMappingName);
                    }
                    webapp.getServlets().add((Object)servlet);
                    if (needToAddMapping && (isEJB || servletMappingName != null)) {
                        webapp.getServletMappings().add((Object)servletMapping1);
                    }
                    webEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
            finally {
                if (webEdit != null) {
                    webEdit.dispose();
                }
            }
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }
}

