/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.finder;

import com.ibm.ast.ws.rd.finder.AbstractFinder;
import com.ibm.ast.ws.rd.utils.WebServiceMetadataUtil;
import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFinder
extends AbstractFinder {
    @Override
    protected String getCategoryId() {
        return "jaxrpc.service";
    }

    private List<?> getWebServiceDescriptions(IProject project) {
        List descriptions = Collections.EMPTY_LIST;
        WSDDArtifactEdit wsdd = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)project);
        if (wsdd != null) {
            try {
                try {
                    WebServices webServices = wsdd.getWebServices();
                    if (webServices != null) {
                        descriptions = webServices.getWebServiceDescriptions();
                    }
                }
                catch (Exception exception) {
                    wsdd.dispose();
                }
            }
            finally {
                wsdd.dispose();
            }
        }
        return descriptions;
    }

    @Override
    protected void addWebServices(IFile file) {
        IProject project = file.getProject();
        for (Object object : this.getWebServiceDescriptions(project)) {
            String name;
            WebServiceDescription description = (WebServiceDescription)object;
            if (WebServiceMetadataUtil.isJaxWsService(project, description) || (name = description.getWebServiceDescriptionName()) == null) continue;
            this.callback.add(this.newWSInfo(file, name, description));
        }
    }

    @Override
    protected void changeWebServices(IFile file) {
        IProject project = file.getProject();
        List<WSInfo> infos = this.getWebServicesInProject(project);
        for (Object object : this.getWebServiceDescriptions(project)) {
            String name;
            WebServiceDescription description = (WebServiceDescription)object;
            if (WebServiceMetadataUtil.isJaxWsService(project, description) || (name = description.getWebServiceDescriptionName()) == null) continue;
            WSInfo info = this.newEmptyWSInfo(project, name);
            if (infos.contains(info)) {
                infos.remove(info);
                this.callback.clear(info);
                continue;
            }
            this.callback.add(this.newWSInfo(file, name, description));
        }
        for (WSInfo info : infos) {
            this.callback.remove(info);
        }
    }

    @Override
    protected boolean canHandle(IFile file) {
        IProject project = file.getProject();
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder folder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
            return folder.getUnderlyingFolder().equals((Object)file.getParent());
        }
        if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder folder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
            return folder.getUnderlyingFolder().equals((Object)file.getParent());
        }
        return false;
    }

    public Object getWebServiceObject(WSInfo info, IProgressMonitor monitor) {
        IProject project = info.getProject();
        if (project != null) {
            String name = info.getProperty("_ws_name_");
            for (Object object : this.getWebServiceDescriptions(project)) {
                WebServiceDescription description = (WebServiceDescription)object;
                if (!name.equals(description.getWebServiceDescriptionName())) continue;
                return description;
            }
        }
        return null;
    }

    private String[] getPortInfo(IProject project, WebServiceDescription description) {
        EList portComponents = description.getPortComponents();
        if (portComponents.isEmpty()) {
            return null;
        }
        StringBuffer ports = new StringBuffer();
        String linkValue = null;
        for (Object object : portComponents) {
            PortComponent port = (PortComponent)object;
            ports.append(port.getPortComponentName()).append(',');
            if (linkValue != null) continue;
            linkValue = WebServiceMetadataUtil.getServiceImplBean(project, port, true);
        }
        return new String[]{ports.deleteCharAt(ports.length() - 1).toString(), linkValue};
    }

    public void fillProperties(Object webServiceObject, Map<String, String> properties) {
        WebServiceDescription description = (WebServiceDescription)webServiceObject;
        properties.put("_wsinfo_label_", description.getWebServiceDescriptionName());
        properties.put("_wsinfo_icon_", "icons/obj16/stopped_service.gif");
        properties.put("_wsinfo_icon_started_", "icons/obj16/webservicedesc_obj.gif");
        this.setProperty(properties, "_ws_wsdl_file_", description.getWsdlFile());
        Path path = new Path(properties.get("_ws_dd_path_"));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        String[] portInfo = this.getPortInfo(project, description);
        if (portInfo != null) {
            this.setProperty(properties, "_ws_ports_", portInfo[0]);
            this.setProperty(properties, "_ws_src_name_", portInfo[1]);
        }
    }
}

