/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.finder;

import com.ibm.ccl.ws.finder.core.FinderCore;
import com.ibm.ccl.ws.finder.core.IFilter;
import com.ibm.ccl.ws.finder.core.IWebServiceRegistryCallback;
import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ccl.ws.finder.core.observer.IResourceChangeObserver;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFinder
implements IResourceChangeObserver {
    protected IWebServiceRegistryCallback callback;

    public void setCallback(IWebServiceRegistryCallback callback) {
        this.callback = callback;
    }

    private String genId(IProject project, String name) {
        return String.valueOf(project.getName()) + "<>" + name;
    }

    protected WSInfo newEmptyWSInfo(IProject project, String name) {
        String id = this.genId(project, name);
        return new WSInfo(this.getCategoryId(), this.getClass().getName(), id);
    }

    protected WSInfo newWSInfo(IFile file, String name, Object content) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("_wsinfo_icon_plugin_id_", "com.ibm.etools.webservice.atk.was.v6.ui");
        properties.put("_ws_dd_path_", file.getFullPath().toString());
        properties.put("_ws_name_", name);
        IProject project = file.getProject();
        String id = this.genId(project, name);
        return new WSInfo(this.getCategoryId(), this.getClass().getName(), id, project, properties, content);
    }

    protected List<WSInfo> getWebServicesInProject(final IProject project) {
        final String finderId = this.getClass().getName();
        return FinderCore.getWebServiceRegistry().getWebServices(this.getCategoryId(), new IFilter(){

            public boolean accept(WSInfo.WSInfoProxy info) {
                return info.getFinderClassId().equals(finderId) && info.getProject().equals((Object)project);
            }
        });
    }

    private void removeWebServices(IFile file) {
        final String finderId = this.getClass().getName();
        final String filePath = file.getFullPath().toString();
        List infos = FinderCore.getWebServiceRegistry().getWebServices(this.getCategoryId(), new IFilter(){

            public boolean accept(WSInfo.WSInfoProxy info) {
                return info.getFinderClassId().equals(finderId) && filePath.equals(info.getProperty("_ws_dd_path_"));
            }
        });
        for (WSInfo info : infos) {
            this.callback.remove(info);
        }
    }

    public void resourceChanged(IResource resource, int kind) {
        IFile file = (IFile)resource;
        switch (kind) {
            case 1: {
                if (!this.canHandle(file)) break;
                this.addWebServices(file);
                break;
            }
            case 2: {
                this.removeWebServices(file);
                break;
            }
            case 4: {
                if (!this.canHandle(file)) break;
                this.changeWebServices(file);
            }
        }
    }

    public boolean exists(WSInfo info, boolean remove) {
        boolean exists;
        boolean bl = exists = info.getContent(null) != null;
        if (!exists && remove) {
            this.callback.remove(info);
        }
        return exists;
    }

    protected void setProperty(Map<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        } else {
            properties.remove(key);
        }
    }

    public void beginSave() {
    }

    public void endSave() {
    }

    protected abstract String getCategoryId();

    protected abstract void addWebServices(IFile var1);

    protected abstract void changeWebServices(IFile var1);

    protected abstract boolean canHandle(IFile var1);
}

