/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.deployer;

import com.ibm.ast.ws.deployer.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClasspathResolver {
    public static final boolean INCLUDE_EXT_DIRS = true;
    public static final boolean EXCLUDE_EXT_DIRS = false;
    private String[] _extdirs;
    private StringBuffer _buffer;
    private boolean _hasEntries;
    private HashSet<String> _seenPaths;
    private HashSet<IProject> _seenProjects;
    private LinkedList<IProject> _todo;
    private IJavaModel _javaModel;
    private boolean _quoteEntries = true;

    public ClasspathResolver(String excludeDirs) {
        if (excludeDirs != null && excludeDirs.length() > 0) {
            ArrayList<String> array = new ArrayList<String>();
            StringTokenizer strtok = new StringTokenizer(excludeDirs, File.pathSeparator);
            while (strtok.hasMoreTokens()) {
                array.add(strtok.nextToken());
            }
            this._extdirs = array.toArray(new String[array.size()]);
        } else {
            this._extdirs = new String[0];
        }
    }

    public void setQuoteEntries(boolean value) {
        this._quoteEntries = value;
    }

    public String getClasspath(IProject project) throws JavaModelException {
        this.initialize();
        this.addEntries(project, true);
        while (this._todo.size() > 0) {
            project = this._todo.removeFirst();
            this.addEntries(project, false);
        }
        return this._buffer.toString();
    }

    private void initialize() {
        this._buffer = new StringBuffer();
        this._hasEntries = false;
        this._seenPaths = new HashSet();
        this._seenProjects = new HashSet();
        this._todo = new LinkedList();
    }

    private void addEntries(IProject project, boolean addAllEntries) throws JavaModelException {
        this._seenProjects.add(project);
        this.addPathElement(PathUtil.getOSOutputDirectory(project));
        IClasspathEntry[] entries = JavaCore.create((IProject)project).getResolvedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                IPath path = entries[i].getOutputLocation();
                if (path != null) {
                    this.addPathElement(PathUtil.makeOSAbsolute(project, path));
                }
            } else if (addAllEntries || entries[i].isExported()) {
                if (entries[i].getEntryKind() == 2) {
                    IProject p = this.getProjectFromEntry(entries[i]);
                    if (!this._seenProjects.contains(p)) {
                        this._todo.add(p);
                    }
                } else {
                    this.addPathElement(PathUtil.makeOSAbsolute(project, entries[i].getPath()));
                }
            }
            ++i;
        }
    }

    private void addPathElement(String path) {
        if (!this._seenPaths.contains(path) && !this.isInExtDir(path)) {
            if (this._hasEntries) {
                this._buffer.append(File.pathSeparator);
            } else {
                this._hasEntries = true;
            }
            if (this._quoteEntries) {
                this._buffer.append(PathUtil.encloseInQuotes(path));
            } else {
                this._buffer.append(path);
            }
            this._seenPaths.add(path);
        }
    }

    private IProject getProjectFromEntry(IClasspathEntry entry) {
        String name = entry.getPath().lastSegment();
        IJavaProject javaProject = this.getJavaModel().getJavaProject(name);
        return javaProject.getProject();
    }

    private IJavaModel getJavaModel() {
        if (this._javaModel == null) {
            this._javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        }
        return this._javaModel;
    }

    private boolean isInExtDir(String jar) {
        int i = 0;
        while (i < this._extdirs.length) {
            if (jar.startsWith(this._extdirs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

