/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ui.widget;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationDefaults;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWSTopDownWidget
extends SimpleWidgetDataContributor {
    private final String pluginId = "com.ibm.ast.ws.jaxws.creation.ui";
    private IProject project;
    private boolean soap12Binding = false;
    private boolean assembleService = false;
    private Composite parent;
    private Listener statusListener;
    private ArrayList<String> validTargetPaths;
    private String targetPath;
    private String annotationProcessorGenSrcDir;
    private Text wsdlBindings;
    private List<JAXWSWebServiceService> services;
    private Combo sourceCombo;
    private final String INFOPOP_WSTD_COMBO_SOURCE = "WSTD0001";
    private Combo packageCombo;
    private final String INFOPOP_WSTD_TEXT_PACKAGE = "WSTD0002";
    private Button browsePackageButton;
    private final String INFOPOP_WSTD_BUTTON_BROWSE = "WSTD0003";
    private Button enableWrapperStyleCheckBox;
    private final String INFOPOP_WSTD_BUTTON_ENABLEWRAPPER = "WSTD0004";
    private Button copyWSDLCheckBox;
    private final String INFOPOP_WSTD_BUTTON_COPYWSDL = "WSTD0005";
    private Button genWSDDCheckBox;
    private final String INFOPOP_WSTD_BUTTON_GENWSDD = "WSBU0007";
    private Button specifyJAXBCheckBox;
    private final String INFOPOP_WSTD_BUTTON_JAXB_FILES = "WSTD0006";
    private Button customizeImplClassCheckBox;
    private final String INFOPOP_WSTD_BUTTON_IMPL_NAME = "WSTD0007";
    private Button enableMTOMCheckBox;
    private final String INFOPOP_WSTD_BUTTON_ENABLEMTOM = "WSTD0009";
    private Button generateSchemaProjectCheckBox;
    private final String INFOPOP_WSTD_BUTTON_XSD_PROJECT = "WSTD0010";
    private Combo versionForJAXWSCombo;
    private final String INFOPOP_WSTD_COMBO_JAXWS_CODE_VERSION = "WSTD0011";
    private Button switchBindingButton;
    private String INFOPOP_PTEB_BUTTON_HTTP = "WSTD0021";
    private boolean isEjb = false;

    public JaxWSTopDownWidget() {
    }

    public JaxWSTopDownWidget(boolean isEjb) {
        this.isEjb = isEjb;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxws.creation.ui");
        this.parent = parent;
        this.statusListener = statusListener;
        Composite mainComposite = uiUtils.createComposite(parent, 2);
        this.sourceCombo = this.createCombo(mainComposite, Messages.LABEL_TOPDOWN_SOURCEFOLDER, Messages.TOOLTIP_TOPDOWN_SOURCEFOLDER, "WSTD0001", 2060);
        Label label = new Label(mainComposite, 64);
        label.setText(Messages.LABEL_TOPDOWN_PACKAGE);
        label.setToolTipText(Messages.TOOLTIP_TOPDOWN_PACKAGE);
        Composite subComposite = uiUtils.createComposite(mainComposite, 2);
        this.packageCombo = new Combo(subComposite, 2052);
        GridData griddata = new GridData(800);
        this.packageCombo.setLayoutData((Object)griddata);
        this.packageCombo.setToolTipText(Messages.TOOLTIP_TOPDOWN_PACKAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.packageCombo, "WSTD0002");
        this.packageCombo.add(Messages.TEXT_TOPDOWN_NAMESPACE_PACKAGE);
        this.packageCombo.select(0);
        this.packageCombo.addModifyListener((ModifyListener)new PackageModifyListener());
        this.browsePackageButton = uiUtils.createPushButton(subComposite, Messages.TEXT_TOPDOWN_BROWSE, Messages.TOOLTIP_TOPDOWN_BROWSE, "WSTD0003");
        this.browsePackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSTopDownWidget.this.handlePackageBrowseButtonEvent();
            }
        });
        if (this.isEjb) {
            Group group = uiUtils.createGroup(parent, Messages.LABEL_BINDINGS_SELECTION, Messages.TOOLTIP_BINDINGS_SELECTION, null);
            Composite composite = uiUtils.createComposite((Composite)group, 2);
            this.wsdlBindings = uiUtils.createText(composite, Messages.LABEL_WSDL_BINDINGS, Messages.TOOLTIP_BINDINGS_SELECTION, null, 2056);
            String switchButtonText = Messages.LABEL_SWITCH_JMS_BINDING.length() > Messages.LABEL_SWITCH_HTTP_BINDING.length() ? Messages.LABEL_SWITCH_JMS_BINDING : Messages.LABEL_SWITCH_HTTP_BINDING;
            this.switchBindingButton = uiUtils.createCheckbox((Composite)group, switchButtonText, Messages.TOOLTIP_BINDING_BUTTON_HTTP, this.INFOPOP_PTEB_BUTTON_HTTP);
            this.switchBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (JAXWSWebServiceService service : JaxWSTopDownWidget.this.services) {
                        service.setHTTPBinding(false);
                        service.setJMSBinding(false);
                        for (JAXWSWebServiceBinding binding : service.getBindings()) {
                            for (JAXWSWebServicePort port : binding.getPorts()) {
                                if (port.getPortType().equals("http")) {
                                    port.setPortType("jms");
                                    service.setJMSBinding(true);
                                    continue;
                                }
                                port.setPortType("http");
                                service.setHTTPBinding(true);
                            }
                        }
                    }
                }
            });
        }
        mainComposite = uiUtils.createComposite(parent, 1);
        Composite versionForJAXWSComposite = uiUtils.createComposite(parent, 2, 0, 0);
        this.versionForJAXWSCombo = uiUtils.createCombo(versionForJAXWSComposite, Messages.LABEL_GEN_JAXWS_CODE_VERSION, Messages.TOOLTIP_GEN_JAXWS_CODE_VERSION, "WSTD0011", 12);
        GridData vcgd = (GridData)this.versionForJAXWSCombo.getLayoutData();
        vcgd.grabExcessHorizontalSpace = false;
        this.versionForJAXWSCombo.setItems(CodeGenerationDefaults.TARGET_JAXWS_VERSIONS);
        this.enableWrapperStyleCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_TOPDOWN_ENABLEWRAPPER, Messages.TOOLTIP_TOPDOWN_ENABLEWRAPPER, "WSTD0004");
        this.enableMTOMCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_BOTTOMUP_MTOM, Messages.TOOLTIP_BOTTOMUP_MTOM, "WSTD0009");
        uiUtils.createHorizontalSeparator(parent, 2);
        mainComposite = uiUtils.createComposite(parent, 1);
        this.copyWSDLCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_TOPDOWN_COPYWSDL, Messages.TOOLTIP_TOPDOWN_COPYWSDL, "WSTD0005");
        this.specifyJAXBCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_TOPDOWN_JAXB_FILES, Messages.TOOLTIP_TOPDOWN_JAXB_FILES, "WSTD0006");
        this.customizeImplClassCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_TOPDOWN_IMPL_NAME, Messages.TOOLTIP_TOPDOWN_IMPL_NAME, "WSTD0007");
        this.generateSchemaProjectCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_TOPDOWN_GENERATE_SCHEMA_PROJECT, Messages.TOOLTIP_TOPDOWN_GENERATE_SCHEMA_PROJECT, "WSTD0010");
        this.genWSDDCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_BOTTOMUP_GENWSDD, Messages.TOOLTIP_BOTTOMUP_GENWSDD, "WSBU0007");
        return this;
    }

    public IStatus getStatus() {
        IStatus retStatus = this.validatePackage();
        if (retStatus.getSeverity() == 4) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_INVALIDPACKAGENAME, (Object[])new String[]{retStatus.getMessage() != null ? retStatus.getMessage() : this.getRawTargetPackage()}));
        }
        return Status.OK_STATUS;
    }

    private IStatus validatePackage() {
        String packName = this.getRawTargetPackage();
        if (packName == null || packName.length() == 0) {
            return Status.OK_STATUS;
        }
        return JavaConventions.validatePackageName((String)packName);
    }

    private void handlePackageBrowseButtonEvent() {
        IPackageFragment packageFragment = this.choosePackage();
        if (packageFragment != null) {
            this.packageCombo.setText(packageFragment.getElementName());
        }
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        IJavaProject jproject = JavaCore.create((IProject)this.project);
        IResource res = ResourceUtils.findResource((String)this.sourceCombo.getText());
        return jproject.getPackageFragmentRoot(res);
    }

    protected IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.parent.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(Messages.TEXT_SELECT_PACKAGE);
        dialog.setMessage(Messages.TEXT_SELECT_PACKAGE);
        dialog.setEmptyListMessage(Messages.TEXT_TOPDOWN_DEFAULT_PACKAGE);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private void initSourceCombo() {
        this.sourceCombo.deselectAll();
        int i = 0;
        while (i < this.validTargetPaths.size()) {
            if (!this.validTargetPaths.get(i).equals(this.annotationProcessorGenSrcDir)) {
                this.sourceCombo.add(this.validTargetPaths.get(i));
            }
            ++i;
        }
        this.sourceCombo.setText(this.targetPath);
    }

    public void setProject(IProject project) {
        this.project = project;
        if (J2EEUtil.getJ2EEVersion((IProject)project).equals("5.0")) {
            this.genWSDDCheckBox.setVisible(true);
        } else {
            this.genWSDDCheckBox.setVisible(false);
        }
    }

    public void setAnnotationProcessorGenSrcDir(String annotationProcessorGenSrcDir) {
        this.annotationProcessorGenSrcDir = annotationProcessorGenSrcDir;
        if (this.targetPath != null && this.validTargetPaths != null && annotationProcessorGenSrcDir != null && this.sourceCombo.indexOf(annotationProcessorGenSrcDir) > -1) {
            this.sourceCombo.remove(annotationProcessorGenSrcDir);
        }
    }

    public void setValidTargetPaths(ArrayList<String> validTargetPaths) {
        this.validTargetPaths = validTargetPaths;
        if (this.targetPath != null) {
            this.initSourceCombo();
        }
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
        if (this.validTargetPaths != null) {
            this.initSourceCombo();
        }
    }

    public String getTargetPath() {
        return this.sourceCombo.getText();
    }

    private String getRawTargetPackage() {
        if (this.packageCombo != null) {
            if (this.packageCombo.getText().equals(Messages.TEXT_TOPDOWN_NAMESPACE_PACKAGE)) {
                return null;
            }
            return this.packageCombo.getText().trim();
        }
        return null;
    }

    public String getTargetPackage() {
        return this.removeWhiteSpacesInPakcage(this.getRawTargetPackage());
    }

    private String removeWhiteSpacesInPakcage(String originalPackageName) {
        try {
            return originalPackageName.replace(" ", "");
        }
        catch (Exception exception) {
            return originalPackageName;
        }
    }

    public void setCopyWSDL(Boolean bool) {
        this.copyWSDLCheckBox.setSelection(bool.booleanValue());
    }

    public boolean getCopyWSDL() {
        if (this.copyWSDLCheckBox == null) {
            return false;
        }
        return this.copyWSDLCheckBox.getSelection();
    }

    public boolean getGenWSDD() {
        if (this.genWSDDCheckBox != null && this.genWSDDCheckBox.getVisible()) {
            return this.genWSDDCheckBox.getSelection();
        }
        return false;
    }

    public void setGenWSDD(boolean bool) {
        this.genWSDDCheckBox.setSelection(bool);
    }

    public boolean getSpecifyJAXBFiles() {
        if (this.specifyJAXBCheckBox == null) {
            return false;
        }
        return this.specifyJAXBCheckBox.getSelection();
    }

    public void setDisableWrapperStyle(Boolean b) {
        this.enableWrapperStyleCheckBox.setSelection(b == false);
    }

    public boolean getDisableWrapperStyle() {
        return !this.enableWrapperStyleCheckBox.getSelection();
    }

    public boolean getCustomizeImplName() {
        if (this.customizeImplClassCheckBox == null) {
            return false;
        }
        return this.customizeImplClassCheckBox.getSelection();
    }

    public void setEnableMTOM(boolean enableMTOM) {
        this.enableMTOMCheckBox.setSelection(enableMTOM);
    }

    public void setGenXSDProjects(boolean genXSD) {
        this.generateSchemaProjectCheckBox.setSelection(genXSD);
    }

    public void setAssembleService(boolean assembleService) {
        this.assembleService = assembleService;
        if (!assembleService) {
            this.generateSchemaProjectCheckBox.setSelection(false);
            this.generateSchemaProjectCheckBox.setEnabled(false);
        } else {
            this.generateSchemaProjectCheckBox.setEnabled(true);
        }
    }

    public boolean getEnableMTOM() {
        if (this.enableMTOMCheckBox == null) {
            return false;
        }
        return this.enableMTOMCheckBox.getSelection();
    }

    public boolean getGenXSDProjects() {
        if (this.generateSchemaProjectCheckBox == null || !this.assembleService) {
            return false;
        }
        return this.generateSchemaProjectCheckBox.getSelection();
    }

    public void setSoap12Binding(boolean soap12) {
        this.soap12Binding = soap12;
        if (this.soap12Binding) {
            this.copyWSDLCheckBox.setSelection(true);
            this.copyWSDLCheckBox.setEnabled(false);
        } else {
            this.copyWSDLCheckBox.setEnabled(true);
        }
    }

    public Combo createCombo(Composite parent, String labelName, String tooltip, String infopop, int style) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        GridData griddata = new GridData(800);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, infopop);
        }
        return combo;
    }

    public void setWasFacetVersion(String wasFacetVersion) {
        if (wasFacetVersion != null && wasFacetVersion.equals("7.0")) {
            this.versionForJAXWSCombo.setEnabled(true);
        } else {
            this.versionForJAXWSCombo.setEnabled(false);
            this.versionForJAXWSCombo.getParent().setVisible(false);
            this.versionForJAXWSCombo.setText("");
            GridData ld = (GridData)this.versionForJAXWSCombo.getParent().getLayoutData();
            ld.exclude = true;
            this.versionForJAXWSCombo.getParent().getParent().layout();
        }
    }

    public String getTargetVersion() {
        return this.versionForJAXWSCombo.getText();
    }

    public void setTargetVersion(String targetVersion) {
        if (this.versionForJAXWSCombo.getEnabled()) {
            this.versionForJAXWSCombo.setText(targetVersion);
        } else {
            this.versionForJAXWSCombo.setText("");
        }
    }

    public List<JAXWSWebServiceService> getServices() {
        return this.services;
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
        if (this.isEjb) {
            boolean jmsBinding = services.get(0).isJMSBinding();
            boolean httpBinding = services.get(0).isHTTPBinding();
            this.switchBindingButton.setEnabled(!jmsBinding || !httpBinding);
            if (httpBinding && jmsBinding) {
                this.wsdlBindings.setText(Messages.LABEL_BINDINGS_JMS_HTTP);
                this.switchBindingButton.setVisible(false);
            } else if (jmsBinding) {
                this.switchBindingButton.setVisible(true);
                this.wsdlBindings.setText(Messages.LABEL_BINDING_JMS);
                this.switchBindingButton.setText(Messages.LABEL_SWITCH_HTTP_BINDING);
            } else {
                this.switchBindingButton.setVisible(true);
                this.wsdlBindings.setText(Messages.LABEL_BINDING_HTTP);
                this.switchBindingButton.setText(Messages.LABEL_SWITCH_JMS_BINDING);
            }
        }
    }

    private class PackageModifyListener
    implements ModifyListener {
        private PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            JaxWSTopDownWidget.this.statusListener.handleEvent(null);
        }
    }
}

