/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ui.widget;

import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationDefaults;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWSClientWidget
extends SimpleWidgetDataContributor {
    private final String pluginId = "com.ibm.ast.ws.jaxws.creation.ui";
    private IProject project;
    private Composite parent;
    private Listener statusListener_;
    private ArrayList<String> validTargetPaths;
    private String targetPath;
    private String annotationProcessorGenSrcDir;
    private Combo sourceCombo;
    private final String INFOPOP_WSCL_COMBO_SOURCE = "WSCL0001";
    private Combo packageCombo;
    private final String INFOPOP_WSCL_TEXT_PACKAGE = "com.ibm.ast.ws.jaxws.creation.ui.WSCL0002";
    private Button browsePackageButton;
    private final String INFOPOP_WSCL_BUTTON_BROWSE = "WSCL0003";
    private boolean userSpecifyAsnycOption = false;
    private Button enableAsyncCheckBox;
    private final String INFOPOP_WSCL_BUTTON_ENABLE_ASYNC = "WSCL0004";
    private Button specifyJAXBCheckBox;
    private final String INFOPOP_WSCL_BUTTON_JAXB_FILES = "WSCL0005";
    private Button customizeProxyClassCheckBox;
    private final String INFOPOP_WSCL_BUTTON_PROXY_NAME = "WSCL0006";
    private boolean userSpecifyCopyWSDLOption = false;
    private Button copyWSDLCheckBox;
    private final String INFOPOP_WSCL_BUTTON_COPY_WSDL = "WSCL0007";
    private Combo versionForJAXWSCombo;
    private final String INFOPOP_WSCL_BUTTON_JAXWS_CODE_VERSION = "WSCL0008";
    private Button genWSDDCheckBox;
    private final String INFOPOP_WSTD_BUTTON_GENWSDD = "WSBU0007";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxws.creation.ui");
        this.parent = parent;
        this.statusListener_ = statusListener;
        Composite mainComposite = uiUtils.createComposite(parent, 2);
        this.sourceCombo = this.createCombo(mainComposite, Messages.LABEL_CLIENT_SOURCEFOLDER, Messages.TOOLTIP_CLIENT_SOURCEFOLDER, "WSCL0001", 2060);
        Label label = new Label(mainComposite, 64);
        label.setText(Messages.LABEL_CLIENT_PACKAGE);
        label.setToolTipText(Messages.TOOLTIP_CLIENT_PACKAGE);
        Composite subComposite = uiUtils.createComposite(mainComposite, 2);
        this.packageCombo = new Combo(subComposite, 2052);
        GridData griddata = new GridData(800);
        this.packageCombo.setLayoutData((Object)griddata);
        this.packageCombo.setToolTipText(Messages.TOOLTIP_CLIENT_PACKAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.packageCombo, "com.ibm.ast.ws.jaxws.creation.ui.WSCL0002");
        this.packageCombo.add(Messages.TEXT_CLIENT_NAMESPACE_PACKAGE);
        this.packageCombo.select(0);
        this.packageCombo.addModifyListener((ModifyListener)new PackageModifyListener());
        this.browsePackageButton = uiUtils.createButton(8, subComposite, Messages.TEXT_CLIENT_BROWSE, Messages.TOOLTIP_CLIENT_BROWSE, "WSCL0003");
        this.browsePackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientWidget.this.handlePackageBrowseButtonEvent();
            }
        });
        mainComposite = uiUtils.createComposite(parent, 1);
        Composite versionForJAXWSComposite = uiUtils.createComposite(parent, 2, 0, 0);
        this.versionForJAXWSCombo = uiUtils.createCombo(versionForJAXWSComposite, Messages.LABEL_GEN_JAXWS_CODE_VERSION, Messages.TOOLTIP_GEN_JAXWS_CODE_VERSION, "WSCL0008", 12);
        GridData vcgd = (GridData)this.versionForJAXWSCombo.getLayoutData();
        vcgd.grabExcessHorizontalSpace = false;
        this.versionForJAXWSCombo.setItems(CodeGenerationDefaults.TARGET_JAXWS_VERSIONS);
        this.copyWSDLCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_CLIENT_COPY_WSDL, Messages.TOOLTIP_CLIENT_COPY_WSDL, "WSCL0007");
        this.copyWSDLCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientWidget.this.userSpecifyCopyWSDLOption = true;
            }
        });
        this.enableAsyncCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_CLIENT_ENABLE_ASYNC, Messages.TOOLTIP_CLIENT_ENABLE_ASYNC, "WSCL0004");
        this.enableAsyncCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientWidget.this.userSpecifyAsnycOption = true;
            }
        });
        this.specifyJAXBCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_CLIENT_JAXB_FILES, Messages.TOOLTIP_CLIENT_JAXB_FILES, "WSCL0005");
        this.specifyJAXBCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.customizeProxyClassCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_CLIENT_PROXY_NAME, Messages.TOOLTIP_CLIENT_PROXY_NAME, "WSCL0006");
        this.customizeProxyClassCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.genWSDDCheckBox = uiUtils.createCheckbox(mainComposite, Messages.LABEL_BOTTOMUP_GENWSDD, Messages.TOOLTIP_BOTTOMUP_GENWSDD, "WSBU0007");
        this.genWSDDCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientWidget.this.statusListener_.handleEvent(null);
            }
        });
        return this;
    }

    public IStatus getStatus() {
        IStatus retStatus = this.validatePackage();
        if (retStatus.getSeverity() == 4) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_INVALIDPACKAGENAME, (Object[])new String[]{retStatus.getMessage() != null ? retStatus.getMessage() : this.getRawTargetPackage()}));
        }
        return Status.OK_STATUS;
    }

    private IStatus validatePackage() {
        String packName = this.getRawTargetPackage();
        if (packName == null || packName.length() == 0) {
            return Status.OK_STATUS;
        }
        return JavaConventions.validatePackageName((String)packName);
    }

    private void handlePackageBrowseButtonEvent() {
        IPackageFragment packageFragment = this.choosePackage();
        if (packageFragment != null) {
            this.packageCombo.setText(packageFragment.getElementName());
        }
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        IJavaProject jproject = JavaCore.create((IProject)this.project);
        this.sourceCombo.getSelectionIndex();
        IResource res = ResourceUtils.findResource((String)this.sourceCombo.getText());
        return jproject.getPackageFragmentRoot(res);
    }

    protected IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.parent.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(Messages.TEXT_SELECT_PACKAGE);
        dialog.setMessage(Messages.TEXT_SELECT_PACKAGE);
        dialog.setEmptyListMessage(Messages.TEXT_CLIENT_DEFAULT_PACKAGE);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private void initSourceCombo() {
        this.sourceCombo.deselectAll();
        int i = 0;
        while (i < this.validTargetPaths.size()) {
            if (!this.validTargetPaths.get(i).equals(this.annotationProcessorGenSrcDir)) {
                this.sourceCombo.add(this.validTargetPaths.get(i));
            }
            ++i;
        }
        this.sourceCombo.setText(this.targetPath);
    }

    public void setProject(IProject project) {
        this.project = project;
        if (JavaUtil.isUnmanagedProject((IProject)project) || J2EEUtil.isWebProject((IProject)project) || J2EEUtil.isEJBProject((IProject)project) || J2EEUtil.isAppClientProject((IProject)project) || J2EEUtil.isJavaUtilityProject((IProject)project)) {
            this.copyWSDLCheckBox.setEnabled(true);
        } else {
            this.copyWSDLCheckBox.setSelection(false);
            this.copyWSDLCheckBox.setEnabled(false);
        }
        if ("5.0".equals(J2EEUtil.getJ2EEVersion((IProject)project))) {
            this.genWSDDCheckBox.setVisible(true);
        } else {
            this.genWSDDCheckBox.setVisible(false);
        }
    }

    public void setAnnotationProcessorGenSrcDir(String annotationProcessorGenSrcDir) {
        this.annotationProcessorGenSrcDir = annotationProcessorGenSrcDir;
        if (this.targetPath != null && this.validTargetPaths != null && annotationProcessorGenSrcDir != null) {
            this.sourceCombo.remove(annotationProcessorGenSrcDir);
        }
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
        if (this.validTargetPaths != null) {
            this.initSourceCombo();
        }
    }

    public void setValidTargetPaths(ArrayList<String> validTargetPaths) {
        this.validTargetPaths = validTargetPaths;
        if (this.targetPath != null) {
            this.initSourceCombo();
        }
    }

    public String getTargetPath() {
        return this.sourceCombo.getText();
    }

    private String getRawTargetPackage() {
        if (this.packageCombo != null) {
            if (this.packageCombo.getText().equals(Messages.TEXT_CLIENT_NAMESPACE_PACKAGE)) {
                return null;
            }
            return this.packageCombo.getText().trim();
        }
        return null;
    }

    public String getTargetPackage() {
        return this.removeWhiteSpacesInPakcage(this.getRawTargetPackage());
    }

    private String removeWhiteSpacesInPakcage(String originalPackageName) {
        try {
            return originalPackageName.replace(" ", "");
        }
        catch (Exception exception) {
            return originalPackageName;
        }
    }

    public boolean getAsyncMapping() {
        if (this.enableAsyncCheckBox == null) {
            return false;
        }
        return this.enableAsyncCheckBox.getSelection();
    }

    public void setAsyncMapping(boolean bool) {
        if (!this.userSpecifyAsnycOption) {
            this.enableAsyncCheckBox.setSelection(bool);
        }
    }

    public boolean getCopyWSDL() {
        if (this.copyWSDLCheckBox == null) {
            return false;
        }
        return this.copyWSDLCheckBox.getSelection();
    }

    public void setCopyWSDL(boolean bool) {
        if (!this.userSpecifyCopyWSDLOption && this.copyWSDLCheckBox.getEnabled()) {
            this.copyWSDLCheckBox.setSelection(bool);
        }
    }

    public boolean getSpecifyJAXBFiles() {
        if (this.specifyJAXBCheckBox == null) {
            return false;
        }
        return this.specifyJAXBCheckBox.getSelection();
    }

    public boolean getCustomizeProxyName() {
        if (this.customizeProxyClassCheckBox == null) {
            return false;
        }
        return this.customizeProxyClassCheckBox.getSelection();
    }

    public boolean getGenWSDD() {
        if (this.genWSDDCheckBox != null && this.genWSDDCheckBox.getVisible()) {
            return this.genWSDDCheckBox.getSelection();
        }
        return false;
    }

    public void setGenWSDD(boolean bool) {
        this.genWSDDCheckBox.setSelection(bool);
    }

    public void setWasFacetVersion(String wasFacetVersion) {
        if (wasFacetVersion != null && wasFacetVersion.equals("7.0")) {
            this.versionForJAXWSCombo.setEnabled(true);
        } else {
            this.versionForJAXWSCombo.setEnabled(false);
            this.versionForJAXWSCombo.getParent().setVisible(false);
            this.versionForJAXWSCombo.setText("");
            GridData ld = (GridData)this.versionForJAXWSCombo.getParent().getLayoutData();
            ld.exclude = true;
            this.versionForJAXWSCombo.getParent().getParent().layout();
        }
    }

    public String getTargetVersion() {
        return this.versionForJAXWSCombo.getText();
    }

    public void setTargetVersion(String targetVersion) {
        if (this.versionForJAXWSCombo.getEnabled()) {
            this.versionForJAXWSCombo.setText(targetVersion);
        } else {
            this.versionForJAXWSCombo.setText("");
        }
    }

    public Combo createCombo(Composite parent, String labelName, String tooltip, String infopop, int style) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        GridData griddata = new GridData(800);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, infopop);
        }
        return combo;
    }

    private class PackageModifyListener
    implements ModifyListener {
        private PackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            JaxWSClientWidget.this.statusListener_.handleEvent(null);
        }
    }
}

