/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ui.widget;

import com.ibm.ast.ws.jaxws.creation.command.GenerateProxyCommand;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.creation.ui.widget.CustomProxyClassNameObject;
import com.ibm.ast.ws.jaxws.creation.ui.widget.CustomizeProxyClassNameDialog;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWSClientProxyWidget
extends SimpleWidgetDataContributor {
    private Hashtable<String, String> originalValues;
    private int DEFAULT_TABLE_HEIGHT_HINT = 100;
    private int DEFAULT_COLUMN_WIDTH = 80;
    private final String pluginId = "com.ibm.ast.ws.jaxws.creation.ui";
    private Table mappingTable;
    private Composite parent_;
    private final String INFOPOP_WSCP_PROXYBEAN_TABLE = "WSCP0000";
    private Button editButton;
    private final String INFOPOP_WSCP_BUTTON_EDIT = "WSCP0001";
    private Button restoreDefaultButton;
    private final String INFOPOP_WSCP_BUTTON_DEFAULT = "WSCP0002";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxws.creation.ui");
        this.parent_ = parent;
        Group mainGroup = uiUtils.createGroup(parent, Messages.LABEL_PROXYBEAN_TABLE, null, "WSCP0000", 2, -1, -1);
        this.mappingTable = uiUtils.createTable((Composite)mainGroup, Messages.LABEL_PROXYBEAN_TABLE, "WSCP0000", 2052);
        String[] columns = new String[]{Messages.LABEL_COLUMN_PORT, Messages.LABEL_COLUMN_PROXY};
        GridData gd = new GridData(1808);
        gd.heightHint = this.DEFAULT_TABLE_HEIGHT_HINT;
        this.mappingTable.setLayoutData((Object)gd);
        this.mappingTable.setHeaderVisible(true);
        this.mappingTable.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int maxWidth = this.DEFAULT_COLUMN_WIDTH;
        int i = 0;
        while (i < columns.length) {
            TableColumn tableColumn = new TableColumn(this.mappingTable, 0);
            tableColumn.setText(columns[i]);
            tableColumn.pack();
            int tableColumnWidth = Math.max(this.DEFAULT_COLUMN_WIDTH, tableColumn.getWidth());
            maxWidth = Math.max(maxWidth, tableColumnWidth);
            ColumnWeightData columnData = new ColumnWeightData(tableColumnWidth, tableColumnWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)columnData);
            ++i;
        }
        this.mappingTable.setLayout((Layout)tableLayout);
        Composite buttonsCompo = uiUtils.createComposite(parent, 2);
        this.editButton = uiUtils.createPushButton(buttonsCompo, Messages.LABEL_EDIT, null, "WSCP0001");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int selectedRow = JaxWSClientProxyWidget.this.mappingTable.getSelectionIndex();
                TableItem itemToEdit = JaxWSClientProxyWidget.this.mappingTable.getItem(selectedRow);
                CustomProxyClassNameObject object = new CustomProxyClassNameObject(itemToEdit.getText(0), itemToEdit.getText(1));
                CustomizeProxyClassNameDialog dialog = new CustomizeProxyClassNameDialog(JaxWSClientProxyWidget.this.parent_.getShell(), Messages.LABEL_PROXYBEAN_TABLE, object, Messages.LABEL_COLUMN_PROXY);
                if (dialog.open() == 0) {
                    object = dialog.getData();
                    itemToEdit.setText(new String[]{object.getPortName(), object.getClassName()});
                }
            }
        });
        this.restoreDefaultButton = uiUtils.createPushButton(buttonsCompo, Messages.LABEL_RESTORE_DEFAULT, Messages.TOOLTIP_RESTORE_DEFAULT, "WSCP0002");
        this.restoreDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSClientProxyWidget.this.mappingTable.removeAll();
                JaxWSClientProxyWidget.this.handleRestore();
            }
        });
        return this;
    }

    private void handleRestore() {
        for (String port : this.originalValues.keySet()) {
            TableItem itemToEdit = new TableItem(this.mappingTable, 8);
            itemToEdit.setText(new String[]{port, this.originalValues.get(port)});
        }
        if (this.mappingTable.getItemCount() > 0) {
            this.mappingTable.select(0);
        }
    }

    public void setPortSEIMapping(Hashtable<QName, String> mapping) {
        if (this.originalValues == null) {
            this.originalValues = new Hashtable();
            for (QName port : mapping.keySet()) {
                String portName = port.getLocalPart();
                if (this.originalValues.containsKey(portName)) continue;
                this.originalValues.put(portName, GenerateProxyCommand.getDefaultProxyClassName(portName));
            }
            this.handleRestore();
        }
    }

    public Hashtable<String, String> getCustomizedProxyNames() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        int i = 0;
        while (i < this.mappingTable.getItemCount()) {
            TableItem itemToEdit = this.mappingTable.getItem(i);
            table.put(itemToEdit.getText(0), itemToEdit.getText(1));
            ++i;
        }
        return table;
    }
}

