/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ui.ddgen;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLService;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class GenerateServiceDDCommand
extends AbstractDataModelOperation {
    private static final String FQ_STATELESS = "javax.ejb.Stateless";
    private static final String STATELESS = "Stateless";
    private ServiceData service = null;
    private String ejbName = null;
    private boolean isProvider;
    private WebServiceDescription matchedWebServiceDescription;
    private PortComponent matchedPortComponent;
    private IStatus status;
    private Map<String, List<String>> namesMap = new Hashtable<String, List<String>>();

    private String getEJBName() {
        block7: {
            this.ejbName = null;
            try {
                IAnnotation[] iAnnotationArray = this.service.getType().getAnnotations();
                int n = iAnnotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    if (FQ_STATELESS.equals(annotation.getElementName()) || STATELESS.equals(annotation.getElementName())) {
                        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                        int n3 = iMemberValuePairArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemberValuePair pair = iMemberValuePairArray[n4];
                            if (pair.getMemberName().equals("name")) {
                                this.ejbName = pair.getValue().toString();
                                break block7;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (this.ejbName == null) {
            this.ejbName = this.service.getClassName();
        }
        return this.ejbName;
    }

    private String getLink(ServiceImplBean implBean) {
        String strLink = null;
        if (implBean != null) {
            if (JavaEEProjectUtilities.isEJBProject((IProject)this.service.getProject())) {
                EJBLink link = implBean.getEEJBLink();
                if (link != null) {
                    strLink = link.getEjbLink();
                }
            } else {
                ServletLink link = implBean.getEServletLink();
                if (link != null) {
                    strLink = link.getServletLink();
                }
            }
        }
        return strLink;
    }

    private void findBestMatch(List webServiceDescriptions) {
        String name = JavaEEProjectUtilities.isEJBProject((IProject)this.service.getProject()) ? this.getEJBName() : this.service.getFullyQualifiedClassName();
        String wsdl = this.service.getWsdlLocation();
        for (Object w : webServiceDescriptions) {
            WebServiceDescription webServiceDescription = (WebServiceDescription)w;
            ArrayList<String> portNames = new ArrayList<String>();
            for (Object p : webServiceDescription.getPortComponents()) {
                PortComponent portComponent = (PortComponent)p;
                if (name.equals(this.getLink(portComponent.getServiceImplBean()))) {
                    this.matchedPortComponent = portComponent;
                    return;
                }
                portNames.add(portComponent.getPortComponentName());
            }
            this.namesMap.put(webServiceDescription.getWebServiceDescriptionName(), portNames);
            if (this.matchedWebServiceDescription != null || wsdl == null || wsdl.length() <= 0 || !wsdl.equals(webServiceDescription.getWsdlFile())) continue;
            this.matchedWebServiceDescription = webServiceDescription;
        }
    }

    private void genWebServiceDescription() {
        Set<String> names = this.namesMap.keySet();
        String name = this.service.getServiceName();
        int i = 1;
        while (names.contains(name)) {
            name = String.valueOf(this.service.getServiceName()) + i++;
        }
        this.matchedWebServiceDescription = WsddFactory.eINSTANCE.createWebServiceDescription();
        this.matchedWebServiceDescription.setWebServiceDescriptionName(name);
        this.matchedWebServiceDescription.setWsdlFile(this.service.getWsdlLocation());
    }

    private void setLink(ServiceImplBean implBean) {
        if (JavaEEProjectUtilities.isEJBProject((IProject)this.service.getProject())) {
            EJBLink link = WsddFactory.eINSTANCE.createEJBLink();
            link.setEjbLink(this.ejbName);
            implBean.setEEJBLink(link);
        } else {
            ServletLink link = WsddFactory.eINSTANCE.createServletLink();
            link.setServletLink(this.service.getFullyQualifiedClassName());
            implBean.setEServletLink(link);
        }
    }

    private void genPortComponent() {
        List<String> names = this.namesMap.get(this.matchedWebServiceDescription.getWebServiceDescriptionName());
        String name = this.service.getPortTypeName();
        if (names != null && names.contains(name)) {
            name = this.service.getFullyQualifiedClassName();
        }
        this.matchedPortComponent = WsddFactory.eINSTANCE.createPortComponent();
        this.matchedPortComponent.setPortComponentName(name);
        WSDLService wsdlService = WsddFactory.eINSTANCE.createWSDLService();
        wsdlService.setValues("pfx", this.service.getTargetNamespace(), this.service.getServiceName());
        this.matchedPortComponent.setWsdlService(wsdlService);
        WSDLPort wsdlPort = WsddFactory.eINSTANCE.createWSDLPort();
        wsdlPort.setValues("pfx", this.service.getTargetNamespace(), this.service.getPortName());
        this.matchedPortComponent.setWsdlPort(wsdlPort);
        this.matchedPortComponent.setEnableMtom(this.service.isMTOMBinding());
        if (!this.isProvider) {
            this.matchedPortComponent.setServiceEndpointInterface(this.service.getEndpointInterface());
        }
        ServiceImplBean implBean = WsddFactory.eINSTANCE.createServiceImplBean();
        this.setLink(implBean);
        this.matchedPortComponent.setServiceImplBean(implBean);
    }

    private void inspectAnnotation(IType type) throws ExecutionException {
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().endsWith("WebServiceProvider")) {
                    this.isProvider = true;
                    return;
                }
                ++n2;
            }
            this.isProvider = false;
        }
        catch (JavaModelException e) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD, (Throwable)e);
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        if (this.service == null) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD);
        }
        this.inspectAnnotation(this.service.getType());
        this.matchedWebServiceDescription = null;
        this.matchedPortComponent = null;
        this.status = Status.OK_STATUS;
        this.namesMap.clear();
        final WSDDArtifactEdit wsdd = WSDDArtifactEdit.getWSDDArtifactEditForWrite((IProject)this.service.getProject());
        if (wsdd == null) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD);
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    WebServices webServices = wsdd.getWebServices();
                    if (webServices == null) {
                        webServices = (WebServices)wsdd.createModelRoot(12);
                    }
                    EList webServiceDescriptions = webServices.getWebServiceDescriptions();
                    GenerateServiceDDCommand.this.findBestMatch((List)webServiceDescriptions);
                    if (GenerateServiceDDCommand.this.matchedPortComponent != null) {
                        GenerateServiceDDCommand.this.status = StatusUtils.infoStatus((String)Messages.MSG_INFO_NO_CHANGE);
                    } else {
                        if (GenerateServiceDDCommand.this.matchedWebServiceDescription == null) {
                            GenerateServiceDDCommand.this.genWebServiceDescription();
                            webServiceDescriptions.add(GenerateServiceDDCommand.this.matchedWebServiceDescription);
                        }
                        GenerateServiceDDCommand.this.genPortComponent();
                        GenerateServiceDDCommand.this.matchedWebServiceDescription.getPortComponents().add((Object)GenerateServiceDDCommand.this.matchedPortComponent);
                        wsdd.save(monitor);
                    }
                }
            }, monitor);
            IStatus iStatus = this.status;
            return iStatus;
        }
        catch (CoreException e) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD, (Throwable)e);
        }
        finally {
            wsdd.dispose();
        }
    }

    public void setSelected(Object selected) {
        this.service = selected instanceof ServiceData ? (ServiceData)selected : null;
    }
}

