/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ui.ddgen;

import com.ibm.ast.ws.jaxws.creation.ui.ddgen.GenerateClientDDCommand;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.ServiceRef;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateClientEjbDDCommand
extends GenerateClientDDCommand {
    private Object targetBean = null;
    private List<Object> targetServiceRefList = null;
    private boolean beanAdded;

    private List<Object> findServiceRefList(EnterpriseBeans enterpriseBeans) {
        this.beanAdded = false;
        if (this.targetBean instanceof SessionBean) {
            SessionBean targetSessionBean = (SessionBean)this.targetBean;
            for (Object object : enterpriseBeans.getSessionBeans()) {
                SessionBean bean = (SessionBean)object;
                if (!targetSessionBean.getEjbName().equals(bean.getEjbName())) continue;
                this.targetServiceRefList = targetSessionBean.getServiceRefs();
                return bean.getServiceRefs();
            }
            enterpriseBeans.getSessionBeans().add(targetSessionBean);
            this.beanAdded = true;
            return targetSessionBean.getServiceRefs();
        }
        if (this.targetBean instanceof MessageDrivenBean) {
            MessageDrivenBean targetMessageDrivenBean = (MessageDrivenBean)this.targetBean;
            for (Object object : enterpriseBeans.getMessageDrivenBeans()) {
                MessageDrivenBean bean = (MessageDrivenBean)object;
                if (!targetMessageDrivenBean.getEjbName().equals(bean.getEjbName())) continue;
                this.targetServiceRefList = targetMessageDrivenBean.getServiceRefs();
                return bean.getServiceRefs();
            }
            enterpriseBeans.getMessageDrivenBeans().add(targetMessageDrivenBean);
            this.beanAdded = true;
            return targetMessageDrivenBean.getServiceRefs();
        }
        EntityBean targetEntityBean = (EntityBean)this.targetBean;
        for (Object object : enterpriseBeans.getEntityBeans()) {
            EntityBean bean = (EntityBean)object;
            if (!targetEntityBean.getEjbName().equals(bean.getEjbName())) continue;
            this.targetServiceRefList = targetEntityBean.getServiceRefs();
            return bean.getServiceRefs();
        }
        enterpriseBeans.getEntityBeans().add(targetEntityBean);
        this.beanAdded = true;
        return targetEntityBean.getServiceRefs();
    }

    private ServiceRef findServiceRef(List<Object> serviceRefList, boolean collectNames) {
        for (Object object : serviceRefList) {
            ServiceRef ref = (ServiceRef)object;
            if (this.client.getFullyQualifiedClassName().equals(ref.getServiceInterface())) {
                return ref;
            }
            if (!collectNames) continue;
            this.serviceRefNames.add(ref.getServiceRefName());
        }
        return null;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        if (this.client == null || this.targetBean == null) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD);
        }
        this.status = Status.OK_STATUS;
        this.serviceRefNames.clear();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IModelProvider provider = ModelProviderManager.getModelProvider((IProject)GenerateClientEjbDDCommand.this.client.getProject());
                    Object modelObj = provider.getModelObject((IPath)new Path("META-INF/ejb-jar.xml"));
                    if (!(modelObj instanceof EJBJar)) {
                        throw new CoreException(StatusUtils.errorStatus((String)Messages.MSG_ERROR_NO_EJB_MODEL));
                    }
                    final EJBJar ejbJar = (EJBJar)modelObj;
                    provider.modify(new Runnable(){

                        public void run() {
                            if (ejbJar.getEnterpriseBeans() == null) {
                                ejbJar.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
                            }
                            List matchedServiceRefList = GenerateClientEjbDDCommand.this.findServiceRefList(ejbJar.getEnterpriseBeans());
                            ServiceRef matchedServiceRef = GenerateClientEjbDDCommand.this.findServiceRef(matchedServiceRefList, true);
                            if (!GenerateClientEjbDDCommand.this.beanAdded && matchedServiceRef != null) {
                                (this).GenerateClientEjbDDCommand.this.status = StatusUtils.infoStatus((String)Messages.MSG_INFO_NO_CHANGE_CLIENT_EJB);
                            } else if (!GenerateClientEjbDDCommand.this.beanAdded && matchedServiceRef == null) {
                                matchedServiceRef = GenerateClientEjbDDCommand.this.findServiceRef(GenerateClientEjbDDCommand.this.targetServiceRefList, false);
                                if (matchedServiceRef != null) {
                                    matchedServiceRefList.add(matchedServiceRef);
                                } else {
                                    matchedServiceRefList.add(GenerateClientEjbDDCommand.this.genServiceRef());
                                }
                            } else if (GenerateClientEjbDDCommand.this.beanAdded && matchedServiceRef == null) {
                                matchedServiceRefList.add(GenerateClientEjbDDCommand.this.genServiceRef());
                            }
                        }
                    }, IModelProvider.FORCESAVE);
                }
            }, monitor);
            return this.status;
        }
        catch (CoreException e) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD, (Throwable)e);
        }
    }

    public void setTargetBean(Object bean) {
        this.targetBean = bean;
    }
}

