/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ui.ddgen;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.PortInfo;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.PortComponentRef;
import org.eclipse.jst.javaee.core.ServiceRef;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.project.facet.IWebCreateDeploymentFilesDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class GenerateClientDDCommand
extends AbstractDataModelOperation {
    protected ClientData client = null;
    protected boolean isPortable = false;
    protected IStatus status;
    protected List<String> serviceRefNames = new ArrayList<String>();

    protected ServiceRef genServiceRef() {
        String prefix;
        String name = prefix = "service/" + this.client.getName();
        int i = 1;
        while (this.serviceRefNames.contains(name)) {
            name = String.valueOf(prefix) + i++;
        }
        ServiceRef ref = JavaeeFactory.eINSTANCE.createServiceRef();
        ref.setServiceRefName(name);
        ref.setServiceInterface(this.client.getFullyQualifiedClassName());
        if (this.isPortable) {
            String wsdl = this.client.getWsdlLocation();
            if (wsdl.startsWith("file:/")) {
                wsdl = wsdl.substring("file:/".length());
            }
            while (wsdl.startsWith("/")) {
                wsdl = wsdl.substring(1);
            }
            ref.setWsdlFile(wsdl);
        }
        for (PortInfo port : this.client.getPortInfoHash().values()) {
            PortComponentRef portRef = JavaeeFactory.eINSTANCE.createPortComponentRef();
            portRef.setServiceEndpointInterface(port.getSeiTypeName());
            ref.getPortComponentRefs().add(portRef);
        }
        return ref;
    }

    private List getServiceRefs(Object model) {
        List serviceRefs = null;
        serviceRefs = model instanceof WebApp ? ((WebApp)model).getServiceRefs() : ((ApplicationClient)model).getServiceRefs();
        for (Object object : serviceRefs) {
            ServiceRef ref = (ServiceRef)object;
            if (this.client.getFullyQualifiedClassName().equals(ref.getServiceInterface())) {
                return null;
            }
            this.serviceRefNames.add(ref.getServiceRefName());
        }
        return serviceRefs;
    }

    private boolean hasDD() {
        IVirtualFolder folder = J2EEUtil.getWebDeploymentDescriptorFolder((IProject)this.client.getProject());
        IVirtualFile file = folder.getFile("web.xml");
        return file.exists();
    }

    private void genBaseDD(IProgressMonitor monitor) throws CoreException {
        Class<IWebCreateDeploymentFilesDataModelProperties> dataModelClass = IWebCreateDeploymentFilesDataModelProperties.class;
        IDataModel dataModel = DataModelFactory.createDataModel(dataModelClass);
        dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.client.getProject());
        try {
            dataModel.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            throw new CoreException(StatusUtils.errorStatus((Throwable)e));
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        if (this.client == null) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD);
        }
        this.status = Status.OK_STATUS;
        this.serviceRefNames.clear();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IModelProvider provider;
                    List serviceRefs;
                    if (JavaEEProjectUtilities.isDynamicWebProject((IProject)GenerateClientDDCommand.this.client.getProject()) && !GenerateClientDDCommand.this.hasDD()) {
                        GenerateClientDDCommand.this.genBaseDD(monitor);
                    }
                    if ((serviceRefs = GenerateClientDDCommand.this.getServiceRefs((provider = ModelProviderManager.getModelProvider((IProject)GenerateClientDDCommand.this.client.getProject())).getModelObject())) == null) {
                        GenerateClientDDCommand.this.status = StatusUtils.infoStatus((String)Messages.MSG_INFO_NO_CHANGE_CLIENT);
                    } else {
                        provider.modify(new Runnable(){

                            public void run() {
                                serviceRefs.add(GenerateClientDDCommand.this.genServiceRef());
                            }
                        }, IModelProvider.FORCESAVE);
                    }
                }
            }, monitor);
            return this.status;
        }
        catch (CoreException e) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD, (Throwable)e);
        }
    }

    public void setSelected(Object selected) {
        this.client = selected instanceof ClientData ? (ClientData)selected : null;
    }

    public void setIsPortable(boolean isPortable) {
        this.isPortable = isPortable;
    }
}

