/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class VerifyServerForWSFPCommand
extends AbstractDataModelOperation {
    private IProject project;
    private Boolean installProject;
    private String serverInstanceId;
    protected boolean useStubRuntimeForCodeGen = false;

    private boolean runtimeHasJaxWsSupport(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime) {
        IRuntime serverRuntime = facetRuntime != null ? FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetRuntime) : null;
        return this.runtimeHasJaxWsSupport(serverRuntime);
    }

    private boolean runtimeHasJaxWsSupport(IRuntime serverRuntime) {
        if (WASRuntimeUtil.isWASv61Runtime((IRuntime)serverRuntime)) {
            return serverRuntime.isStub() ? true : WASRuntimeUtil.isFeaturePackInstalled((IRuntime)serverRuntime, (String)"WEBSERVICES");
        }
        return WASRuntimeUtil.isWASv70Runtime((IRuntime)serverRuntime);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        block9: {
            try {
                IServer server;
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)this.project);
                if (facetProject == null) {
                    return Status.OK_STATUS;
                }
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetProject.getPrimaryRuntime();
                if (!this.runtimeHasJaxWsSupport(facetRuntime)) {
                    IStatus warningStatus = StatusUtils.warningStatus((String)Messages.MSG_WARN_TARGET_NONWSFP_RUNTIME);
                    IEnvironment env = super.getEnvironment();
                    try {
                        env.getStatusHandler().report(warningStatus);
                        this.useStubRuntimeForCodeGen = true;
                        return Status.OK_STATUS;
                    }
                    catch (StatusException statusException) {
                        return StatusUtils.errorStatus((String)"");
                    }
                }
                if (this.installProject != null && this.installProject.booleanValue() && this.serverInstanceId != null && (server = ServerCore.findServer((String)this.serverInstanceId)) != null && !this.runtimeHasJaxWsSupport(server.getRuntime())) {
                    IStatus warningStatus = StatusUtils.warningStatus((String)Messages.MSG_WARN_SELECT_NONWSFP_RUNTIME);
                    IEnvironment env = super.getEnvironment();
                    try {
                        env.getStatusHandler().report(warningStatus);
                        return Status.OK_STATUS;
                    }
                    catch (StatusException statusException) {
                        return StatusUtils.errorStatus((String)"");
                    }
                }
            }
            catch (Exception e) {
                if (!Activator.isTraceMode()) break block9;
                IStatus status = StatusUtils.errorStatus((Throwable)e);
                Activator.getDefault().getLog().log(status);
            }
        }
        return Status.OK_STATUS;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setInstallProject(Boolean installProject) {
        this.installProject = installProject;
    }

    public boolean getUseStubRuntimeForCodeGen() {
        return this.useStubRuntimeForCodeGen;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

