/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.command.WsGenCommand;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.wsi.validation.WSIValidationUtils;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.ant.AntEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;
import org.eclipse.wst.ws.internal.preferences.WSIComplianceUtils;

public class ValidateWSIComplianceCommand
extends AbstractDataModelOperation {
    private Vector<Status> statusList = null;
    private IProject project;
    private boolean soap12Binding = false;
    private boolean mtom = false;
    private boolean isBottomUp = false;
    private WsGenCommand.BINDING_TYPE bindingType;
    private WsGenCommand.BINDING_TYPE bindingTypeImplBean;
    private boolean genDelegate = false;

    public ValidateWSIComplianceCommand() {
    }

    public ValidateWSIComplianceCommand(String id) {
        this();
        this.setID(id);
    }

    public ValidateWSIComplianceCommand(String id, boolean isBottomUp) {
        this(id);
        this.isBottomUp = isBottomUp;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        IEnvironment environment = super.getEnvironment();
        if (environment instanceof AntEnvironment) {
            return Status.OK_STATUS;
        }
        this.statusList = new Vector();
        if (this.isBottomUp) {
            if (this.genDelegate) {
                this.setUpBindingType(this.bindingType);
            } else {
                this.setUpBindingType(this.bindingTypeImplBean);
            }
        }
        PersistentWSIContext wsiContext = new PersistentWSIContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)this.project, (PersistentWSIContext)wsiContext);
        int severity_12 = WSIValidationUtils.getWSISeverity((String)WSIValidationUtils.getProjectWSICompliance((IProject)this.project, (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibp12"));
        int severity_20 = WSIValidationUtils.getWSISeverity((String)WSIValidationUtils.getProjectWSICompliance((IProject)this.project, (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibp20"));
        if (severity != 1) {
            this.checkSOAP12(severity);
            this.checkMTOM(severity);
            Status[] statuses = this.statusList.toArray(new Status[this.statusList.size()]);
            if (statuses.length == 0 || WSIComplianceUtils.checkWSICompliance((IStatusHandler)environment.getStatusHandler(), (Status[])statuses, (IProject)this.project, (PersistentWSIContext)wsiContext)) {
                return Status.OK_STATUS;
            }
            return StatusUtils.errorStatus((String)"");
        }
        severity = severity_12;
        if (severity != 1) {
            this.checkSOAP12(severity);
            Status[] statuses = this.statusList.toArray(new Status[this.statusList.size()]);
            if (statuses.length == 0 || WSIValidationUtils.checkWSICompliance((IStatusHandler)environment.getStatusHandler(), (Status[])statuses, (IProject)this.project, (int)severity, (String)(severity == 4 ? Messages.WSI_BP12_ERROR : Messages.WSI_BP12_WARNING), (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibp12")) {
                return Status.OK_STATUS;
            }
            return StatusUtils.errorStatus((String)"");
        }
        severity = severity_20;
        if (severity != 1) {
            this.checkSOAP11(severity);
            Status[] statuses = this.statusList.toArray(new Status[this.statusList.size()]);
            if (statuses.length == 0 || WSIValidationUtils.checkWSICompliance((IStatusHandler)environment.getStatusHandler(), (Status[])statuses, (IProject)this.project, (int)severity, (String)(severity == 4 ? Messages.WSI_BP20_ERROR : Messages.WSI_BP20_WARNING), (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibp20")) {
                return Status.OK_STATUS;
            }
            return StatusUtils.errorStatus((String)"");
        }
        return Status.OK_STATUS;
    }

    private void checkSOAP11(int severity) {
        if (!this.soap12Binding) {
            this.statusList.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_SOAP11, null));
        }
    }

    private void checkSOAP12(int severity) {
        if (this.soap12Binding) {
            this.statusList.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_SOAP12, null));
        }
    }

    private void checkMTOM(int severity) {
        if (this.mtom) {
            this.statusList.add(new Status(severity, "ValidateWSIComplianceCommand", 0, Messages.WSI_INCOMPLIANCE_MTOM, null));
        }
    }

    public void setMtom(boolean mtom) {
        this.mtom = mtom;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setSoap12Binding(boolean soap12Binding) {
        this.soap12Binding = soap12Binding;
    }

    public void setBindingType(WsGenCommand.BINDING_TYPE bindingType) {
        this.bindingType = bindingType;
    }

    public void setBindingTypeImplBean(WsGenCommand.BINDING_TYPE bindingType) {
        this.bindingTypeImplBean = bindingType;
    }

    public void setIsImplBeanAnnotated(boolean bool) {
        this.genDelegate = !bool;
    }

    private void setUpBindingType(WsGenCommand.BINDING_TYPE bindingType) {
        if (bindingType == WsGenCommand.BINDING_TYPE.SOAP12HTTP) {
            this.setSoap12Binding(true);
            this.setMtom(false);
        } else if (bindingType == WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM) {
            this.setSoap12Binding(true);
            this.setMtom(true);
        } else if (bindingType == WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM) {
            this.setSoap12Binding(false);
            this.setMtom(true);
        } else {
            this.setSoap12Binding(false);
            this.setMtom(false);
        }
    }
}

