/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ValidateJavaBeanSelectionCommand
extends AbstractDataModelOperation {
    private String javaBeanName;
    private IProject serviceProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        if (this.javaBeanName == null || this.javaBeanName.length() == 0) {
            IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_NO_JAVA_BEAN);
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.serviceProject);
        try {
            IType javaType = javaProject.findType(this.javaBeanName);
            if (javaType == null) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_CANNOT_LOAD_JAVA_BEAN, (Object[])new String[]{this.javaBeanName, this.serviceProject.getName()}));
                env.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
            if (javaType.isInterface()) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_NO_JAVA_BEAN);
                env.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
            if (!javaType.isBinary()) {
                ICompilationUnit icu = javaType.getCompilationUnit();
                CompilationUnit cu = this.parseForCompilationUnit(icu);
                IProblem[] problems = cu.getProblems();
                boolean hasCompilationErrors = false;
                if (problems.length > 0) {
                    IProblem[] iProblemArray = problems;
                    int n = problems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProblem problem = iProblemArray[n2];
                        if (problem.isError()) {
                            hasCompilationErrors = true;
                            break;
                        }
                        ++n2;
                    }
                    if (hasCompilationErrors) {
                        IStatus errorStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_CANNOT_LOAD_JAVA_BEAN, (Object[])new String[]{this.javaBeanName, this.serviceProject.getName()}));
                        env.getStatusHandler().reportError(errorStatus);
                        return errorStatus;
                    }
                }
            }
            return Status.OK_STATUS;
        }
        catch (JavaModelException e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return Status.OK_STATUS;
        }
    }

    protected CompilationUnit parseForCompilationUnit(ICompilationUnit icu) {
        ASTParser parser_ = ASTParser.newParser((int)3);
        parser_.setSource(icu);
        parser_.setResolveBindings(true);
        return (CompilationUnit)parser_.createAST(null);
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setJavaBeanName(String javaBeanName) {
        this.javaBeanName = javaBeanName;
    }
}

