/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.ServerUtils;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class SelectWSFPRuntimeCommand
extends AbstractDataModelOperation {
    private WebServiceInfo wsInfo;
    private WebServiceClientInfo wsClientInfo;

    public SelectWSFPRuntimeCommand(WebServiceInfo ws, WebServiceClientInfo wsClientInfo) {
        this.wsInfo = ws;
        this.wsClientInfo = wsClientInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.wsInfo == null && this.wsClientInfo == null) {
            return Status.OK_STATUS;
        }
        String serverInstanceId = this.getServerInstanceId();
        if (serverInstanceId != null) {
            return Status.OK_STATUS;
        }
        String serverFactoryId = this.getServerFactoryId();
        if (serverFactoryId == null) {
            return Status.OK_STATUS;
        }
        if (!serverFactoryId.contains("61")) {
            return Status.OK_STATUS;
        }
        try {
            IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
            if (serverType != null) {
                String serverRuntimeTypeId = serverType.getRuntimeType().getId();
                IRuntime[] runtimes = ServerCore.getRuntimes();
                IRuntime selectedRuntime = null;
                IRuntime[] iRuntimeArray = runtimes;
                int n = runtimes.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntime runtime = iRuntimeArray[n2];
                    if (runtime.getRuntimeType().getId().equals(serverRuntimeTypeId) && ServerUtils.hasJaxWsSupport((IRuntime)runtime)) {
                        if (!runtime.isStub()) {
                            this.wsInfo.setServerRuntimeId(runtime.getId());
                            return Status.OK_STATUS;
                        }
                        selectedRuntime = runtime;
                    }
                    ++n2;
                }
                if (selectedRuntime != null) {
                    this.wsInfo.setServerRuntimeId(selectedRuntime.getId());
                    return Status.OK_STATUS;
                }
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
        }
        return Status.OK_STATUS;
    }

    private String getServerInstanceId() {
        if (this.wsInfo != null) {
            return this.wsInfo.getServerInstanceId();
        }
        if (this.wsClientInfo != null) {
            return this.wsClientInfo.getServerInstanceId();
        }
        return null;
    }

    private String getServerFactoryId() {
        if (this.wsInfo != null) {
            return this.wsInfo.getServerFactoryId();
        }
        if (this.wsClientInfo != null) {
            return this.wsClientInfo.getServerFactoryId();
        }
        return null;
    }
}

