/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.command.ValidateEditCommand;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateProxyCommand
extends AbstractDataModelOperation {
    private final String JAVAX_XML_WS_WEBENDPOINT = "javax.xml.ws.WebEndpoint";
    private final String JAVAX_XML_WS_WEBSERVICECLIENT = "javax.xml.ws.WebServiceClient";
    private final String ATTR_WEBENDPOINT_NAME = "name";
    private final String ATTR_WEBSERVICECLIENT_NAME = "name";
    private final String NEW_LINE = System.getProperty("line.separator");
    private final String PROXY_INSTANCE = "_proxy";
    private final String SERVICE_INSTANCE = "_service";
    private final String INIT_COMMON_METHOD = "initCommon";
    protected ASTParser parser_ = null;
    private IProject project;
    private Hashtable<String, String> customizedProxyNames = null;
    private Hashtable<QName, List<QName>> servicePortsMapping;
    private Hashtable<QName, String> serviceClassNameMapping;
    private Hashtable<QName, String> portSEIMapping;
    private IPath outputPath;
    private String proxyBeanName_;
    private IType serviceClass_;
    private HashSet<String> ignoreImports;
    private boolean isJEE5OrHigher_ = false;
    String[] clientImportDeclarations = new String[]{"javax.xml.namespace.QName", "javax.xml.transform.Source", "javax.xml.ws.BindingProvider", "javax.xml.ws.Dispatch", "javax.xml.ws.Service"};

    public GenerateProxyCommand() {
        this.setUpIgnoreImports();
    }

    private void setUpIgnoreImports() {
        String[] ignoreImportArray = new String[]{"javax.jws.Oneway", "javax.jws.WebMethod", "javax.jws.WebParam", "javax.jws.WebResult", "javax.jws.WebService", "javax.jws.soap.SOAPBinding", "javax.jws.soap.SOAPBinding.ParameterStyle", "javax.xml.ws.RequestWrapper", "javax.xml.ws.ResponseWrapper", "javax.xml.bind.annotation.XmlSeeAlso"};
        this.ignoreImports = new HashSet();
        int i = 0;
        while (i < ignoreImportArray.length) {
            this.ignoreImports.add(ignoreImportArray[i]);
            ++i;
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        String projectJeeVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)this.project);
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project) && "2.5".compareTo(projectJeeVersion) <= 0 || JavaEEProjectUtilities.isEJBProject((IProject)this.project) && "3.0".compareTo(projectJeeVersion) <= 0 || JavaEEProjectUtilities.isApplicationClientProject((IProject)this.project) && "5.0".compareTo(projectJeeVersion) <= 0) {
            this.isJEE5OrHigher_ = true;
        }
        Enumeration<QName> services = this.servicePortsMapping.keys();
        while (services.hasMoreElements()) {
            QName serviceQName = services.nextElement();
            List<QName> portsList = this.servicePortsMapping.get(serviceQName);
            for (QName port : portsList) {
                IStatus status = this.writeProxy(serviceQName, port, monitor, info);
                if (status.getSeverity() != 4) continue;
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus writeProxy(QName serviceQName, QName portQName, IProgressMonitor monitor, IAdaptable info) {
        String proxyQualifiedClassName;
        String seiQualifiedClassName = this.portSEIMapping.get(portQName);
        StringBuffer sbProxyClass = new StringBuffer();
        String packageName = JavaUtil.getPackageNameFromClassName((String)seiQualifiedClassName);
        if (packageName != null && packageName.length() > 0) {
            sbProxyClass.append(packageName).append(".");
        }
        sbProxyClass.append(this.calculateProxyClassName(portQName.getLocalPart()));
        this.proxyBeanName_ = proxyQualifiedClassName = sbProxyClass.toString();
        String serviceQualifiedClassName = this.serviceClassNameMapping.get(serviceQName);
        String proxyInstanceName = this.getProxyInstanceName(this.getSimpleClassNameFromQualifiedName(seiQualifiedClassName));
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IType javaType = javaProject.findType(seiQualifiedClassName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            PrintWriter pw = new PrintWriter(new BufferedWriter(writer));
            this.writePackage(pw, this.getPackageNameFromClassName(proxyQualifiedClassName));
            ICompilationUnit compilationUnit = javaType.getCompilationUnit();
            if (compilationUnit != null) {
                IImportDeclaration[] importDeclarations = compilationUnit.getImports();
                this.writeClientImports(pw, importDeclarations);
                this.newLine(pw);
            }
            this.writeClassNameDeclaration(pw, this.getSimpleClassNameFromQualifiedName(proxyQualifiedClassName));
            this.writeClassAttributes(pw);
            this.writeDescriptor(pw, serviceQualifiedClassName, seiQualifiedClassName, portQName, proxyInstanceName);
            this.writeConstructors(pw, this.getSimpleClassNameFromQualifiedName(proxyQualifiedClassName));
            this.writeGetDescriptorMethod(pw);
            int i = 0;
            while (i < javaType.getMethods().length) {
                IMethod method = javaType.getMethods()[i];
                this.writeMethod(pw, method);
                ++i;
            }
            pw.write("}");
            pw.close();
            baos.close();
            StringBuffer sb = new StringBuffer(proxyQualifiedClassName.replace('.', '/'));
            sb.append(".java");
            try {
                ValidateEditCommand validateEditCommand = new ValidateEditCommand();
                validateEditCommand.setEnvironment(super.getEnvironment());
                Vector<IPath> pathVector = new Vector<IPath>();
                pathVector.add(this.outputPath.append((IPath)new Path(sb.toString())));
                validateEditCommand.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
                IStatus validateStatus = validateEditCommand.execute(monitor, info);
                if (!validateStatus.isOK()) {
                    return validateStatus;
                }
            }
            catch (Exception e) {
                IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
                Activator.getDefault().getLog().log(errStatus);
            }
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            FileResourceUtils.createFile((ResourceContext)((BaseEclipseEnvironment)this.getEnvironment()).getResourceContext(), (IPath)this.outputPath.append((IPath)new Path(sb.toString())), (InputStream)bais, (IProgressMonitor)monitor, (IStatusHandler)super.getEnvironment().getStatusHandler());
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    private void writePackage(Writer pw, String packageName) throws IOException {
        if (packageName != null) {
            pw.write("package ");
            pw.write(packageName);
            pw.write(";");
            this.newLine(pw);
            this.newLine(pw);
        }
    }

    private void writeClientImports(Writer pw, IImportDeclaration[] impDecls) throws IOException {
        if (this.isJEE5OrHigher_) {
            pw.write("import javax.naming.InitialContext;");
            this.newLine(pw);
            pw.write("import javax.naming.NamingException;");
            this.newLine(pw);
            this.newLine(pw);
        }
        pw.write("import java.net.URL;");
        this.newLine(pw);
        this.newLine(pw);
        pw.write("import javax.xml.namespace.QName;");
        this.newLine(pw);
        pw.write("import javax.xml.transform.Source;");
        this.newLine(pw);
        pw.write("import javax.xml.ws.BindingProvider;");
        this.newLine(pw);
        pw.write("import javax.xml.ws.Dispatch;");
        this.newLine(pw);
        pw.write("import javax.xml.ws.Service;");
        this.newLine(pw);
        int i = 0;
        while (i < impDecls.length) {
            String impElementName = impDecls[i].getElementName();
            boolean bFound = false;
            int k = 0;
            while (k < this.clientImportDeclarations.length) {
                if (this.clientImportDeclarations[k].equals(impElementName)) {
                    bFound = true;
                }
                ++k;
            }
            if (!bFound && this.ignoreImports.contains(impElementName)) {
                bFound = true;
            }
            if (!bFound) {
                pw.write("import ");
                pw.write(impElementName);
                pw.write(";");
                this.newLine(pw);
            }
            ++i;
        }
    }

    private void writeClassNameDeclaration(Writer pw, String className) throws IOException {
        pw.write("public class ");
        pw.write(className);
        pw.write("{");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeClassAttributes(Writer pw) throws IOException {
        this.indent(pw, 1);
        pw.write("protected Descriptor _descriptor;");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeDescriptor(Writer pw, String serviceQualifiedClassName, String seiQualifiedClassName, QName portQName, String proxyInstanceName) throws IOException {
        this.indent(pw, 1);
        pw.write("public class Descriptor {");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("private " + serviceQualifiedClassName + " " + "_service" + " = null;");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("private " + seiQualifiedClassName + " " + "_proxy" + " = null;");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("private Dispatch<Source> _dispatch = null;");
        this.newLine(pw);
        this.newLine(pw);
        ITypeBinding serviceClassTypeBinding = this.getServiceClassTypeBinding(serviceQualifiedClassName);
        String portName = portQName.getLocalPart();
        this.writeDescriptorConstructors(pw, serviceClassTypeBinding, proxyInstanceName, portName);
        String endpointGetterName = this.getEndpointGetter(serviceClassTypeBinding, portName);
        this.writeInitCommon(pw, endpointGetterName, portQName, seiQualifiedClassName);
        this.writeGetProxyMethod(pw, seiQualifiedClassName);
        this.writeGetDispatchMethod(pw, portQName);
        this.writeGetEndpointMethod(pw);
        this.writeSetEndpointMethod(pw);
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private String getProxyInstanceName(String seiName) {
        return "_" + Character.toLowerCase(seiName.charAt(0)) + seiName.substring(1);
    }

    private String getWebServiceClientAnnotationNameAttr(ITypeBinding serviceClassTypeBinding) {
        IAnnotationBinding[] annotations;
        IAnnotationBinding[] iAnnotationBindingArray = annotations = serviceClassTypeBinding.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if ("javax.xml.ws.WebServiceClient".equals(annotation.getAnnotationType().getQualifiedName())) {
                IMemberValuePairBinding[] memberValuePairs;
                IMemberValuePairBinding[] iMemberValuePairBindingArray = memberValuePairs = annotation.getDeclaredMemberValuePairs();
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n4];
                    String attrName = memberValuePair.getName();
                    if ("name".equals(attrName)) {
                        return (String)memberValuePair.getValue();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private void writeDescriptorConstructors(Writer pw, ITypeBinding serviceClassTypeBinding, String proxyInstanceName, String portName) throws IOException {
        String serviceQualifiedClassName = serviceClassTypeBinding.getQualifiedName();
        this.indent(pw, 2);
        pw.write("public Descriptor() {");
        this.newLine(pw);
        String webServiceClientNameAttrValue = this.getWebServiceClientAnnotationNameAttr(serviceClassTypeBinding);
        if (this.isJEE5OrHigher_ && webServiceClientNameAttrValue != null) {
            this.indent(pw, 3);
            pw.write("try");
            this.newLine(pw);
            this.indent(pw, 3);
            pw.write("{");
            this.newLine(pw);
            this.indent(pw, 4);
            pw.write("InitialContext ctx = new InitialContext();");
            this.newLine(pw);
            this.indent(pw, 4);
            pw.write("_service = (" + serviceQualifiedClassName + ")ctx.lookup(\"java:comp/env/service/" + webServiceClientNameAttrValue + "\");");
            this.newLine(pw);
            this.indent(pw, 3);
            pw.write("}");
            this.newLine(pw);
            this.indent(pw, 3);
            pw.write("catch (NamingException e)");
            this.newLine(pw);
            this.indent(pw, 3);
            pw.write("{");
            this.newLine(pw);
            this.indent(pw, 3);
            pw.write("}");
            this.newLine(pw);
            this.newLine(pw);
        }
        this.indent(pw, 3);
        if (this.isJEE5OrHigher_ && webServiceClientNameAttrValue != null) {
            pw.write("if (_service == null)");
            this.newLine(pw);
            this.indent(pw, 4);
        }
        pw.write("_service = new " + serviceQualifiedClassName + "();");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("initCommon();");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("public Descriptor(URL wsdlLocation, QName serviceName) {");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("_service = new " + serviceQualifiedClassName + "(wsdlLocation, serviceName);");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("initCommon();");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeInitCommon(Writer pw, String endpointGetterName, QName portQName, String seiQualifiedClassName) throws IOException {
        this.indent(pw, 2);
        pw.write("private void initCommon() {");
        this.newLine(pw);
        this.indent(pw, 3);
        if (endpointGetterName != null) {
            pw.write("_proxy = _service." + endpointGetterName + "();");
        } else {
            pw.write("_proxy = _service.getPort(new QName(\"" + portQName.getNamespaceURI() + "\", \"" + portQName.getLocalPart() + "\"), " + seiQualifiedClassName + ".class);");
        }
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeGetProxyMethod(Writer pw, String seiQualifiedClassName) throws IOException {
        this.indent(pw, 2);
        pw.write("public " + seiQualifiedClassName + " getProxy() {");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("return _proxy;");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeGetDispatchMethod(Writer pw, QName portQName) throws IOException {
        this.indent(pw, 2);
        pw.write("public Dispatch<Source> getDispatch() {");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("if(_dispatch == null ) {");
        this.newLine(pw);
        this.indent(pw, 4);
        pw.write("QName portQName = new QName(\"" + portQName.getNamespaceURI() + "\", \"" + portQName.getLocalPart() + "\");");
        this.newLine(pw);
        this.indent(pw, 4);
        pw.write("_dispatch = _service.createDispatch(portQName, Source.class, Service.Mode.MESSAGE);");
        this.newLine(pw);
        this.newLine(pw);
        this.indent(pw, 4);
        pw.write("String proxyEndpointUrl = getEndpoint();");
        this.newLine(pw);
        this.indent(pw, 4);
        pw.write("BindingProvider bp = (BindingProvider) _dispatch;");
        this.newLine(pw);
        this.indent(pw, 4);
        pw.write("String dispatchEndpointUrl = (String) bp.getRequestContext().get(BindingProvider.ENDPOINT_ADDRESS_PROPERTY);");
        this.newLine(pw);
        this.indent(pw, 4);
        pw.write("if(!dispatchEndpointUrl.equals(proxyEndpointUrl))");
        this.newLine(pw);
        this.indent(pw, 5);
        pw.write("bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, proxyEndpointUrl);");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("}");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("return _dispatch;");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeGetEndpointMethod(Writer pw) throws IOException {
        this.indent(pw, 2);
        pw.write("public String getEndpoint() {");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("BindingProvider bp = (BindingProvider) _proxy;");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("return (String) bp.getRequestContext().get(BindingProvider.ENDPOINT_ADDRESS_PROPERTY);");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeSetEndpointMethod(Writer pw) throws IOException {
        this.indent(pw, 2);
        pw.write("public void setEndpoint(String endpointUrl) {");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("BindingProvider bp = (BindingProvider) _proxy;");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpointUrl);");
        this.newLine(pw);
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("if(_dispatch != null ) {");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("bp = (BindingProvider) _dispatch;");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpointUrl);");
        this.newLine(pw);
        this.indent(pw, 3);
        pw.write("}");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("}");
        this.newLine(pw);
    }

    private void writeConstructors(Writer pw, String proxyClassName) throws IOException {
        this.indent(pw, 1);
        pw.write("public " + proxyClassName + "() {");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("_descriptor = new Descriptor();");
        this.newLine(pw);
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
        this.indent(pw, 1);
        pw.write("public " + proxyClassName + "(URL wsdlLocation, QName serviceName) {");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("_descriptor = new Descriptor(wsdlLocation, serviceName);");
        this.newLine(pw);
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeGetDescriptorMethod(Writer pw) throws IOException {
        this.indent(pw, 1);
        pw.write("public Descriptor _getDescriptor() {");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("return _descriptor;");
        this.newLine(pw);
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeMethod(Writer pw, IMethod method) throws IOException, JavaModelException {
        this.indent(pw, 1);
        pw.write("public ");
        pw.write(Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)true, (boolean)true));
        this.writeMethodException(pw, method.getExceptionTypes());
        pw.write(" {");
        this.newLine(pw);
        this.indent(pw, 2);
        if (!method.getReturnType().equals("V")) {
            pw.write("return ");
        }
        pw.write("_getDescriptor().getProxy()." + method.getElementName() + "(");
        String[] paramNames = method.getParameterNames();
        int i = 0;
        while (i < paramNames.length) {
            if (i < paramNames.length - 1) {
                pw.write(String.valueOf(paramNames[i]) + ",");
            } else {
                pw.write(paramNames[i]);
            }
            ++i;
        }
        pw.write(");");
        this.newLine(pw);
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeMethodException(Writer pw, String[] exceptions) throws IOException {
        if (exceptions.length == 0) {
            return;
        }
        pw.write(" throws ");
        int i = 0;
        while (i < exceptions.length) {
            if (i != 0) {
                pw.write(", ");
            }
            pw.write(Signature.getSignatureSimpleName((String)exceptions[i]));
            ++i;
        }
    }

    private String getPackageNameFromClassName(String className) {
        int lastDot = className.lastIndexOf(".");
        if (lastDot > 0) {
            return className.substring(0, lastDot);
        }
        return null;
    }

    private String getSimpleClassNameFromQualifiedName(String className) {
        int lastDot = className.lastIndexOf(".");
        if (lastDot == -1) {
            return className;
        }
        return className.substring(lastDot + 1);
    }

    private String calculateProxyClassName(String seiName) {
        if (this.customizedProxyNames != null && this.customizedProxyNames.get(seiName) != null) {
            return this.customizedProxyNames.get(seiName);
        }
        return GenerateProxyCommand.getDefaultProxyClassName(seiName);
    }

    private void newLine(Writer pw) throws IOException {
        pw.write(this.NEW_LINE);
    }

    private void indent(Writer pw, int indentCount) throws IOException {
        int i = 0;
        while (i < indentCount) {
            pw.write("    ");
            ++i;
        }
    }

    private ITypeBinding getServiceClassTypeBinding(String serviceClassName) {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            IType javaType;
            this.serviceClass_ = javaType = javaProject.findType(serviceClassName);
            ICompilationUnit icu = javaType.getCompilationUnit();
            CompilationUnit cu = this.parseForCompilationUnit(icu);
            List cuTypes = cu.types();
            for (Object cuTypeObject : cuTypes) {
                if (!(cuTypeObject instanceof TypeDeclaration)) continue;
                TypeDeclaration typeDecl = (TypeDeclaration)cuTypeObject;
                String serviceSimpleClassName = this.getSimpleClassNameFromQualifiedName(serviceClassName);
                if (!typeDecl.getName().getIdentifier().equals(serviceSimpleClassName)) continue;
                return typeDecl.resolveBinding();
            }
        }
        catch (JavaModelException e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
        }
        return null;
    }

    private String getEndpointGetter(ITypeBinding serviceClassTypeBinding, String portName) {
        return this.parseForMethods(serviceClassTypeBinding, portName);
    }

    private String parseForMethods(ITypeBinding typeBinding, String portName) {
        IMethodBinding[] methodBindings;
        if (typeBinding == null) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = methodBindings = typeBinding.getDeclaredMethods();
        int n = methodBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            if (!methodBinding.isConstructor() && Modifier.isPublic((int)methodBinding.getModifiers())) {
                IAnnotationBinding[] annotations;
                IAnnotationBinding[] iAnnotationBindingArray = annotations = methodBinding.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotationBinding annotation = iAnnotationBindingArray[n4];
                    if (annotation.getAnnotationType().getQualifiedName().equals("javax.xml.ws.WebEndpoint")) {
                        IMemberValuePairBinding[] memberValuePairs;
                        IMemberValuePairBinding[] iMemberValuePairBindingArray = memberValuePairs = annotation.getDeclaredMemberValuePairs();
                        int n5 = memberValuePairs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String endpointName;
                            IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n6];
                            String attrName = memberValuePair.getName();
                            if ("name".equals(attrName) && (endpointName = (String)memberValuePair.getValue()).equals(portName)) {
                                return methodBinding.getName();
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    protected CompilationUnit parseForCompilationUnit(ICompilationUnit icu) {
        if (this.parser_ == null) {
            this.parser_ = ASTParser.newParser((int)3);
        }
        this.parser_.setSource(icu);
        this.parser_.setResolveBindings(true);
        return (CompilationUnit)this.parser_.createAST(null);
    }

    public void setCustomizedProxyNames(Hashtable<String, String> customizedProxyNames) {
        this.customizedProxyNames = customizedProxyNames;
    }

    public void setServicePortsMapping(Hashtable<QName, List<QName>> sqMapping) {
        this.servicePortsMapping = sqMapping;
    }

    public void setServiceClassNameMapping(Hashtable<QName, String> mapping) {
        this.serviceClassNameMapping = mapping;
    }

    public void setPortSEIMapping(Hashtable<QName, String> mapping) {
        this.portSEIMapping = mapping;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setOutputPath(IPath outputPath) {
        this.outputPath = outputPath;
    }

    public String getProxyBean() {
        return this.proxyBeanName_;
    }

    public IType getServiceClassId() {
        return this.serviceClass_;
    }

    public static String getDefaultProxyClassName(String className) {
        if (className != null) {
            StringBuffer sb = new StringBuffer(JavaUtil.getProperJavaClassName((String)className));
            sb.append("Proxy");
            return sb.toString();
        }
        return className;
    }
}

