/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLService;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateMultiPortServiceDDCommand
extends AbstractDataModelOperation {
    private static final String STATELESS = "Stateless";
    private List<JAXWSWebServiceService> services;
    private IProject project;
    private IStatus status;

    private String getLink(ServiceImplBean implBean) {
        if (JavaEEProjectUtilities.isEJBProject((IProject)this.project)) {
            EJBLink link = implBean.getEEJBLink();
            return link.getEjbLink();
        }
        ServletLink link = implBean.getEServletLink();
        return link.toString();
    }

    private PortComponent findMatchingPortComponent(JAXWSWebServiceBinding binding, JAXWSWebServicePort port, WebServiceDescription description) {
        for (Object p : description.getPortComponents()) {
            PortComponent portComponent = (PortComponent)p;
            String name = String.valueOf(port.getPortName().getLocalPart()) + STATELESS;
            if (!name.equals(this.getLink(portComponent.getServiceImplBean())) || !portComponent.getPortComponentName().equals(port.getPortName().getLocalPart()) && !portComponent.getPortComponentName().equals(name)) continue;
            return portComponent;
        }
        return null;
    }

    private WebServiceDescription findMatchingWebServiceDescription(List<WebServiceDescription> webServiceDescriptions, JAXWSWebServiceService service) {
        for (WebServiceDescription w : webServiceDescriptions) {
            if (!w.getWebServiceDescriptionName().equals(service.getServiceName().getLocalPart()) && !w.getWsdlFile().equals(service.getWsdlLocation())) continue;
            return w;
        }
        WebServiceDescription description = WsddFactory.eINSTANCE.createWebServiceDescription();
        description.setWebServiceDescriptionName(service.getServiceName().getLocalPart());
        description.setWsdlFile(service.getWsdlLocation());
        webServiceDescriptions.add(description);
        return description;
    }

    private void setLink(ServiceImplBean implBean, String portName, String serviceName) {
        if (JavaEEProjectUtilities.isEJBProject((IProject)this.project)) {
            EJBLink link = WsddFactory.eINSTANCE.createEJBLink();
            link.setEjbLink(String.valueOf(portName) + STATELESS);
            implBean.setEEJBLink(link);
        } else {
            ServletLink link = WsddFactory.eINSTANCE.createServletLink();
            link.setServletLink(serviceName);
            implBean.setEServletLink(link);
        }
    }

    private void genPortComponent(JAXWSWebServiceService service, JAXWSWebServiceBinding binding, JAXWSWebServicePort port, WebServiceDescription description, PortComponent portComponent) {
        if (portComponent == null) {
            portComponent = WsddFactory.eINSTANCE.createPortComponent();
            description.getPortComponents().add((Object)portComponent);
        }
        portComponent.setPortComponentName(port.getPortName().getLocalPart());
        WSDLService wsdlService = WsddFactory.eINSTANCE.createWSDLService();
        wsdlService.setValues("pfx", service.getServiceName().getNamespaceURI(), service.getServiceName().getLocalPart());
        portComponent.setWsdlService(wsdlService);
        WSDLPort wsdlPort = WsddFactory.eINSTANCE.createWSDLPort();
        wsdlPort.setValues("pfx", service.getServiceName().getNamespaceURI(), port.getPortName().getLocalPart());
        portComponent.setWsdlPort(wsdlPort);
        portComponent.setEnableMtom(service.isMTOMBinding());
        ServiceImplBean implBean = WsddFactory.eINSTANCE.createServiceImplBean();
        this.setLink(implBean, port.getPortName().getLocalPart(), binding.getImplementationBean());
        portComponent.setServiceImplBean(implBean);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        this.status = Status.OK_STATUS;
        final WSDDArtifactEdit wsdd = WSDDArtifactEdit.getWSDDArtifactEditForWrite((IProject)this.project);
        if (wsdd == null) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD);
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    WebServices webServices = wsdd.getWebServices();
                    if (webServices == null) {
                        webServices = (WebServices)wsdd.createModelRoot(12);
                    }
                    EList webServiceDescriptions = webServices.getWebServiceDescriptions();
                    for (JAXWSWebServiceService service : GenerateMultiPortServiceDDCommand.this.services) {
                        WebServiceDescription description = GenerateMultiPortServiceDDCommand.this.findMatchingWebServiceDescription((List)webServiceDescriptions, service);
                        for (JAXWSWebServiceBinding binding : service.getBindings()) {
                            for (JAXWSWebServicePort port : binding.getPorts()) {
                                PortComponent foundPortComponent = GenerateMultiPortServiceDDCommand.this.findMatchingPortComponent(binding, port, description);
                                if (foundPortComponent != null) {
                                    GenerateMultiPortServiceDDCommand.this.status = StatusUtils.infoStatus((String)Messages.MSG_INFO_NO_CHANGE);
                                }
                                GenerateMultiPortServiceDDCommand.this.genPortComponent(service, binding, port, description, foundPortComponent);
                            }
                        }
                        wsdd.save(monitor);
                    }
                    GenerateMultiPortServiceDDCommand.this.project.build(15, monitor);
                }
            }, monitor);
            IStatus iStatus = this.status;
            return iStatus;
        }
        catch (CoreException e) {
            throw new ExecutionException(Messages.MSG_ERROR_GEN_DD, (Throwable)e);
        }
        finally {
            wsdd.dispose();
        }
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

