/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.command.ValidateEditCommand;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentMergeContext;
import org.eclipse.wst.ws.internal.wsrt.IMerger;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateImplCommand
extends AbstractDataModelOperation {
    private IProject project;
    protected List<JAXWSWebServiceService> services;
    private final String NEW_LINE = System.getProperty("line.separator");
    private IPath outputPath;
    protected Hashtable<String, String> customizedImplName = null;
    private WebServiceInfo wsInfo;
    protected String wsdlLocation;
    protected boolean copyWSDL;
    private HashSet<String> ignoreImports;
    protected boolean soap12Binding = false;
    protected HashSet<QName> portsWithSOAP12Binding;
    protected boolean enableMTOM = false;
    private boolean genXSDProjects = false;
    private boolean delayImplGen = false;
    private String implClassName;

    public GenerateImplCommand(WebServiceInfo info) {
        this.wsInfo = info;
        this.setUpIgnoreImports();
    }

    public GenerateImplCommand(WebServiceInfo info, boolean delayImplGen) {
        this(info);
        this.delayImplGen = delayImplGen;
    }

    public GenerateImplCommand(WebServiceInfo info, boolean delayImplGen, String id) {
        this(info, delayImplGen);
        this.setID(id);
    }

    private void setUpIgnoreImports() {
        String[] ignoreImportArray = new String[]{"javax.jws.Oneway", "javax.jws.WebMethod", "javax.jws.WebParam", "javax.jws.WebResult", "javax.jws.WebService", "javax.jws.soap.SOAPBinding", "javax.jws.soap.SOAPBinding.ParameterStyle", "javax.xml.ws.RequestWrapper", "javax.xml.ws.ResponseWrapper", "javax.xml.bind.annotation.XmlSeeAlso"};
        this.ignoreImports = new HashSet();
        int i = 0;
        while (i < ignoreImportArray.length) {
            this.ignoreImports.add(ignoreImportArray[i]);
            ++i;
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.delayImplGen && this.genXSDProjects) {
            PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
            if (mergeContext.isSkeletonMergeEnabled()) {
                this.wsInfo.setImplURLs(new String[0]);
            }
            return Status.OK_STATUS;
        }
        if (!this.delayImplGen && !this.genXSDProjects) {
            return Status.OK_STATUS;
        }
        Set<Object> pathNames = new HashSet();
        PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
        if (mergeContext.isSkeletonMergeEnabled()) {
            for (JAXWSWebServiceService service : this.services) {
                for (JAXWSWebServiceBinding binding : service.getBindings()) {
                    pathNames.add(this.getImplBeanPath(service, binding));
                }
            }
            String[] implPaths = new String[pathNames.size()];
            this.wsInfo.setImplURLs(pathNames.toArray(implPaths));
        }
        try {
            GenerateImplBeanOperation implBeanOp = new GenerateImplBeanOperation();
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)implBeanOp, monitor);
            if (!mergeContext.isSkeletonMergeEnabled()) {
                pathNames = implBeanOp.getPathNames();
                String[] implPaths = new String[pathNames.size()];
                this.wsInfo.setImplURLs(pathNames.toArray(implPaths));
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
        if (!this.delayImplGen && this.genXSDProjects) {
            IStatus status;
            IMerger merger = this.wsInfo.getMerger();
            if (mergeContext.isSkeletonMergeEnabled() && merger != null && (status = merger.merge(monitor, this.getEnvironment().getStatusHandler())).getSeverity() == 4) {
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private String getImplBeanPath(JAXWSWebServiceService service, JAXWSWebServiceBinding binding) {
        String seiName = binding.getSei();
        StringBuffer sb = new StringBuffer();
        String packageName = JavaUtil.getPackageNameFromClassName((String)seiName);
        if (packageName != null && packageName.length() > 0) {
            sb.append(packageName).append(".");
        }
        sb.append(this.calculateImplClassName(binding.getBindingName().getLocalPart()));
        this.implClassName = sb.toString();
        binding.setImplementationBean(this.implClassName);
        String implClassFilePath = String.valueOf(this.implClassName.replace('.', '/')) + ".java";
        return PlatformUtil.getFileURLFromPath((IPath)this.outputPath.append((IPath)new Path(implClassFilePath)));
    }

    private IStatus writeBean(JAXWSWebServiceService service, JAXWSWebServiceBinding binding, IProgressMonitor monitor, IAdaptable info) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            String seiName = binding.getSei();
            IType javaType = javaProject.findType(seiName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            PrintWriter pw = new PrintWriter(new BufferedWriter(writer));
            this.writePackage(pw, JavaUtil.getPackageNameFromClassName((String)seiName));
            ICompilationUnit compilationUnit = javaType.getCompilationUnit();
            if (compilationUnit != null) {
                IImportDeclaration[] importDeclarations = compilationUnit.getImports();
                int i = 0;
                while (i < importDeclarations.length) {
                    if (!this.ignoreImports.contains(importDeclarations[i].getElementName())) {
                        this.writeImport(pw, importDeclarations[i]);
                    }
                    ++i;
                }
                this.newLine(pw);
                this.newLine(pw);
            }
            if (binding.isMultiportBinding()) {
                this.writeClassAnnotation(pw, service.getServiceName(), null, seiName);
            } else {
                this.writeClassAnnotation(pw, service.getServiceName(), binding.getPorts().get(0).getPortName(), seiName);
            }
            this.writeClassNameDeclaration(pw, JavaUtil.getSimpleClassNameFromQualifiedName((String)this.calculateImplClassName(binding.getBindingName().getLocalPart())));
            int i = 0;
            while (i < javaType.getMethods().length) {
                IMethod method = javaType.getMethods()[i];
                this.writeMethod(pw, method);
                ++i;
            }
            pw.write("}");
            pw.close();
            baos.close();
            StringBuffer sb = new StringBuffer();
            String packageName = JavaUtil.getPackageNameFromClassName((String)seiName);
            if (packageName != null && packageName.length() > 0) {
                sb.append(packageName).append(".");
            }
            sb.append(this.calculateImplClassName(binding.getBindingName().getLocalPart()));
            this.implClassName = sb.toString();
            String implClassFilePath = String.valueOf(this.implClassName.replace('.', '/')) + ".java";
            try {
                ValidateEditCommand validateEditCommand = new ValidateEditCommand();
                validateEditCommand.setEnvironment(super.getEnvironment());
                Vector<IPath> pathVector = new Vector<IPath>();
                pathVector.add(this.outputPath.append((IPath)new Path(implClassFilePath)));
                validateEditCommand.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
                IStatus validateStatus = validateEditCommand.execute(monitor, info);
                if (!validateStatus.isOK()) {
                    return validateStatus;
                }
            }
            catch (Exception e) {
                IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
                Activator.getDefault().getLog().log(errStatus);
            }
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            FileResourceUtils.createFile((ResourceContext)((BaseEclipseEnvironment)this.getEnvironment()).getResourceContext(), (IPath)this.outputPath.append((IPath)new Path(implClassFilePath)), (InputStream)bais, (IProgressMonitor)monitor, (IStatusHandler)super.getEnvironment().getStatusHandler());
            return StatusUtils.infoStatus((String)PlatformUtil.getPlatformFromPath((String)this.outputPath.append((IPath)new Path(implClassFilePath)).toString()));
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    private void writePackage(Writer pw, String packageName) throws IOException {
        if (packageName != null) {
            pw.write("package ");
            pw.write(packageName);
            pw.write(";");
            this.newLine(pw);
            this.newLine(pw);
        }
    }

    private void writeImport(Writer pw, IImportDeclaration importDeclaration) throws IOException {
        pw.write("import ");
        pw.write(importDeclaration.getElementName());
        pw.write(";");
        this.newLine(pw);
    }

    protected void writeClassAnnotation(Writer pw, QName serviceQName, QName portQName, String seiName) throws IOException {
        pw.write("@javax.jws.WebService (endpointInterface=\"");
        pw.write(seiName);
        pw.write("\", targetNamespace=\"");
        pw.write(serviceQName.getNamespaceURI());
        pw.write("\", serviceName=\"");
        pw.write(serviceQName.getLocalPart());
        if (portQName != null) {
            pw.write("\", portName=\"");
            pw.write(portQName.getLocalPart());
        }
        if (this.wsdlLocation != null && (this.copyWSDL || this.soap12Binding)) {
            pw.write("\", wsdlLocation=\"");
            pw.write(this.wsdlLocation);
        }
        pw.write("\")");
        this.newLine(pw);
        if (this.soap12Binding && this.portsWithSOAP12Binding != null && this.portsWithSOAP12Binding.contains(portQName)) {
            if (this.enableMTOM) {
                pw.write("@javax.xml.ws.BindingType (value=javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_MTOM_BINDING)");
                this.newLine(pw);
            } else {
                pw.write("@javax.xml.ws.BindingType (value=javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)");
                this.newLine(pw);
            }
        } else if (this.enableMTOM) {
            pw.write("@javax.xml.ws.BindingType (value=javax.xml.ws.soap.SOAPBinding.SOAP11HTTP_MTOM_BINDING)");
            this.newLine(pw);
        }
    }

    private void writeClassNameDeclaration(Writer pw, String className) throws IOException {
        pw.write("public class ");
        pw.write(className);
        pw.write("{");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeMethod(Writer pw, IMethod method) throws IOException, JavaModelException {
        this.indent(pw, 1);
        pw.write("public ");
        pw.write(Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)true, (boolean)true));
        this.writeMethodException(pw, method.getExceptionTypes());
        pw.write(" {");
        this.newLine(pw);
        this.indent(pw, 2);
        pw.write("// TODO ");
        pw.write(Messages.GENERATE_IMPLMETHOD_TODO_COMMENT);
        this.newLine(pw);
        this.indent(pw, 2);
        this.writeReturn(pw, method.getReturnType());
        this.indent(pw, 1);
        pw.write("}");
        this.newLine(pw);
        this.newLine(pw);
    }

    private void writeMethodException(Writer pw, String[] exceptions) throws IOException {
        if (exceptions.length == 0) {
            return;
        }
        pw.write(" throws ");
        int i = 0;
        while (i < exceptions.length) {
            if (i != 0) {
                pw.write(", ");
            }
            pw.write(Signature.getSignatureSimpleName((String)exceptions[i]));
            ++i;
        }
    }

    private void writeReturn(Writer pw, String returnType) throws IOException {
        if (Signature.getElementType((String)returnType).equals("V")) {
            pw.write("return;");
        } else if (Signature.getArrayCount((String)returnType) > 0) {
            pw.write("return null;");
        } else if (Signature.getElementType((String)returnType).equals("Z")) {
            pw.write("return false;");
        } else if (Signature.getElementType((String)returnType).equals("B")) {
            pw.write("return (byte)-3;");
        } else if (Signature.getElementType((String)returnType).equals("C")) {
            pw.write("return (char)-3;");
        } else if (Signature.getElementType((String)returnType).equals("D")) {
            pw.write("return -3;");
        } else if (Signature.getElementType((String)returnType).equals("F")) {
            pw.write("return -3;");
        } else if (Signature.getElementType((String)returnType).equals("I")) {
            pw.write("return -3;");
        } else if (Signature.getElementType((String)returnType).equals("J")) {
            pw.write("return -3;");
        } else if (Signature.getElementType((String)returnType).equals("S")) {
            pw.write("return (short)-3;");
        } else {
            pw.write("return null;");
        }
        this.newLine(pw);
    }

    public static String getDefaultImplClassName(String className) {
        if (className != null) {
            StringBuffer sb = new StringBuffer(JavaUtil.getProperJavaClassName((String)className));
            sb.append("Impl");
            return sb.toString();
        }
        return className;
    }

    private String calculateImplClassName(String portName) {
        if (this.customizedImplName != null && this.customizedImplName.get(portName) != null) {
            return this.customizedImplName.get(portName);
        }
        return GenerateImplCommand.getDefaultImplClassName(portName);
    }

    protected void newLine(Writer pw) throws IOException {
        pw.write(this.NEW_LINE);
    }

    private void indent(Writer pw, int indentCount) throws IOException {
        int i = 0;
        while (i < indentCount) {
            pw.write("    ");
            ++i;
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setOutputPath(IPath outputPath) {
        if (outputPath != null) {
            this.outputPath = outputPath;
        }
    }

    public void setTempOutputPath(IPath outputPath) {
        this.setOutputPath(outputPath);
    }

    public void setCustomizedImplNames(Hashtable<String, String> customizedImplName) {
        this.customizedImplName = customizedImplName;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setCopyWSDL(Boolean b) {
        this.copyWSDL = b;
    }

    public void setSoap12Binding(boolean soap12Binding) {
        this.soap12Binding = soap12Binding;
    }

    public void setPortsWithSOAP12Binding(HashSet<QName> portsWithSOAP12Binding) {
        this.portsWithSOAP12Binding = portsWithSOAP12Binding;
    }

    public void setEnableMTOM(boolean enableMTOM) {
        this.enableMTOM = enableMTOM;
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.genXSDProjects = genXSDProjects;
    }

    public List<JAXWSWebServiceService> getServices() {
        return this.services;
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
    }

    public String getJavaBeanName() {
        return this.implClassName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class GenerateImplBeanOperation
    implements IWorkspaceRunnable {
        private IStatus status;
        private Set<String> generatedPathNames = new HashSet<String>();

        GenerateImplBeanOperation() {
            this.status = Status.OK_STATUS;
        }

        public void run(IProgressMonitor monitor) {
            for (JAXWSWebServiceService service : GenerateImplCommand.this.services) {
                for (JAXWSWebServiceBinding binding : service.getBindings()) {
                    IStatus retStatus = GenerateImplCommand.this.writeBean(service, binding, monitor, null);
                    if (retStatus.getSeverity() == 4) {
                        this.status = retStatus;
                        return;
                    }
                    this.generatedPathNames.add(retStatus.getMessage());
                }
            }
        }

        IStatus getStatus() {
            return this.status;
        }

        Set<String> getPathNames() {
            return this.generatedPathNames;
        }
    }
}

