/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.collector.ClientCollector;
import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.PortInfo;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.impl.WscbndFactoryImpl;
import com.ibm.xwt.wsdl.binding.soap12.SOAP12Address;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class GenerateIBMWSBndXMICommand
extends AbstractDataModelOperation {
    private IProject project;
    private IType serviceClass = null;
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        try {
            ClientCollector collector = new ClientCollector();
            if (this.serviceClass == null) {
                return Status.OK_STATUS;
            }
            collector.collect(this.serviceClass);
            ClientData clientObject = null;
            Iterator iterator = collector.getClientDataHash().values().iterator();
            while (iterator.hasNext()) {
                ClientData data;
                clientObject = data = (ClientData)iterator.next();
            }
            String serviceRefName = "service/" + clientObject.getName();
            String portQnameLocalNameLink = null;
            for (PortInfo port : clientObject.getPortInfoHash().values()) {
                portQnameLocalNameLink = port.getName();
            }
            String EndpointURI = null;
            Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
            Map services = definition.getServices();
            for (Service ser : services.values()) {
                Map ports = ser.getPorts();
                block17: for (Port p : ports.values()) {
                    for (Object obj : p.getExtensibilityElements()) {
                        SOAPAddress soapAddress;
                        if (obj instanceof SOAPAddress) {
                            soapAddress = (SOAPAddress)obj;
                            EndpointURI = soapAddress.getLocationURI();
                            continue block17;
                        }
                        if (!(obj instanceof SOAP12Address)) continue;
                        soapAddress = (SOAP12Address)obj;
                        EndpointURI = soapAddress.getLocationURI();
                        continue block17;
                    }
                }
            }
            try {
                new URL(EndpointURI);
            }
            catch (MalformedURLException malformedURLException) {
                return Status.OK_STATUS;
            }
            if (JavaEEProjectUtilities.isEJBProject((IProject)this.project)) {
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.project);
                Object model = provider.getModelObject();
                EJBJar ejbJar = (EJBJar)model;
                EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
                SessionBean theSessionBean = (SessionBean)beans.getSessionBeans().get(0);
                WscbndArtifactEdit artifactEdit = null;
                try {
                    try {
                        artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.project);
                        ClientBinding wscbnd = artifactEdit.getClientBinding();
                        ComponentScopedRefs compScopedRef = null;
                        EList componentScopedRefs = wscbnd.getComponentScopedRefs();
                        if (componentScopedRefs.size() > 0) {
                            compScopedRef = (ComponentScopedRefs)componentScopedRefs.get(0);
                        } else {
                            compScopedRef = this.wscbndfactory.createComponentScopedRefs();
                            compScopedRef.setComponentNameLink(theSessionBean.getEjbName());
                            componentScopedRefs.add((Object)compScopedRef);
                        }
                        this.setIBMWSCBndServiceRefs(compScopedRef.getServiceRefs(), clientObject, serviceRefName, portQnameLocalNameLink, EndpointURI);
                        artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (artifactEdit == null) return Status.OK_STATUS;
                        artifactEdit.dispose();
                    }
                    return Status.OK_STATUS;
                }
                finally {
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            if (!JavaEEProjectUtilities.isDynamicWebProject((IProject)this.project) && !JavaEEProjectUtilities.isApplicationClientProject((IProject)this.project)) return Status.OK_STATUS;
            WscbndArtifactEdit artifactEdit = null;
            try {
                try {
                    artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.project);
                    ClientBinding wscbnd = artifactEdit.getClientBinding();
                    this.setIBMWSCBndServiceRefs(wscbnd.getServiceRefs(), clientObject, serviceRefName, portQnameLocalNameLink, EndpointURI);
                    artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit == null) return Status.OK_STATUS;
                    artifactEdit.dispose();
                }
                return Status.OK_STATUS;
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    private void setIBMWSCBndServiceRefs(EList serviceRefs, ClientData clientObject, String serviceRefName, String portQnameLocalNameLink, String EndpointURI) {
        ServiceRef serviceRef = null;
        PortQnameBinding portQNameBinding = null;
        int i = 0;
        while (i < serviceRefs.size()) {
            ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
            if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(serviceRefName)) {
                serviceRef = serRef;
                break;
            }
            ++i;
        }
        if (serviceRef == null) {
            serviceRef = this.wscbndfactory.createServiceRef();
            serviceRef.setServiceRefLink(serviceRefName);
            serviceRefs.add((Object)serviceRef);
        }
        EList portQnameBindings = serviceRef.getPortQnameBindings();
        int j = 0;
        while (j < portQnameBindings.size()) {
            PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
            if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(portQnameLocalNameLink)) {
                portQNameBinding = pqBnd;
                portQNameBinding.setPortQnameNamespaceLink(clientObject.getTargetNamespace());
                portQNameBinding.setOverriddenEndpointURI(EndpointURI);
                break;
            }
            ++j;
        }
        if (portQNameBinding == null) {
            portQNameBinding = this.wscbndfactory.createPortQnameBinding();
            portQNameBinding.setPortQnameNamespaceLink(clientObject.getTargetNamespace());
            portQNameBinding.setPortQnameLocalNameLink(portQnameLocalNameLink);
            portQNameBinding.setOverriddenEndpointURI(EndpointURI);
            serviceRef.getPortQnameBindings().add((Object)portQNameBinding);
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setServiceClassId(IType serviceClassId) {
        this.serviceClass = serviceClassId;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }
}

