/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.CopyWSDLToProjectCommand;
import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationContext;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromWSDLInputCommand
extends AbstractDataModelOperation {
    private IWebService ws;
    private String project;
    private String earProject;
    private String wsdlURI;
    private String outputSrcLocation;
    private String serverInstanceId;
    private String serverFactoryId;
    private WebServicesParser webServicesParser;
    private CodeGenerationContext context = null;
    private ArrayList<String> validTargetPaths;
    private String targetPath;
    private String annotationProcessorGenSrcDir;
    private Boolean copyWSDL = null;
    private Boolean genXSDProjects = null;
    private Boolean genWSDDTopDown = null;
    private String overrideHostName = null;
    private String[] bindingFiles = null;
    private boolean assembleService = false;
    private String wasFacetVersion;
    private String targetJaxWsVersion = null;

    public FromWSDLInputCommand(IWebService ws, String project, String earProject) {
        this.ws = ws;
        this.project = project;
        this.earProject = earProject;
        this.initValidTargetPaths();
    }

    public ArrayList<String> getValidTargetPaths() {
        return this.validTargetPaths;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    private final IStatus initValidTargetPaths() {
        this.targetPath = "";
        this.validTargetPaths = new ArrayList();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
        IJavaProject javaProject = JavaCore.create((IProject)currentProject);
        try {
            try {
                try {
                    IPath genSrcPath = javaProject.getProject().getFullPath();
                    this.annotationProcessorGenSrcDir = genSrcPath.append(AptConfig.getGenSrcDir((IJavaProject)javaProject)).toString();
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in FromWSDLInputCommand.initValidTargetPaths(): " + e.getMessage()), (Throwable)e));
                }
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int j = 0;
                while (j < packageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
                    IPath targetIPath = packageFragmentRoot.getPath();
                    if (packageFragmentRoot.getKind() == 1) {
                        String targetPathString = targetIPath.toString();
                        this.validTargetPaths.add(targetPathString);
                        boolean hasHiddenDirectories = false;
                        int k = 0;
                        while (k < targetIPath.segmentCount()) {
                            if (targetIPath.segment(k).startsWith(".")) {
                                hasHiddenDirectories = true;
                                break;
                            }
                            ++k;
                        }
                        if (!hasHiddenDirectories) {
                            this.targetPath = targetPathString;
                        } else if (this.targetPath.length() == 0) {
                            this.targetPath = targetPathString;
                        }
                    }
                    ++j;
                }
            }
            catch (JavaModelException e) {
                IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                if (this.targetPath.length() == 0 && this.validTargetPaths.size() > 0) {
                    this.targetPath = this.validTargetPaths.get(0);
                }
                return iStatus;
            }
        }
        finally {
            if (this.targetPath.length() == 0 && this.validTargetPaths.size() > 0) {
                this.targetPath = this.validTargetPaths.get(0);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.wsdlURI = this.ws.getWebServiceInfo().getWsdlURL();
        this.serverInstanceId = this.ws.getWebServiceInfo().getServerInstanceId();
        this.serverFactoryId = this.ws.getWebServiceInfo().getServerFactoryId();
        this.outputSrcLocation = this.createOutputDirectory();
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        this.setupWasFacetVersion();
        return Status.OK_STATUS;
    }

    private void setupWasFacetVersion() {
        block4: {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                Set projFacets = fProject.getProjectFacets();
                for (IProjectFacetVersion facetVersion : projFacets) {
                    if (facetVersion.getProjectFacet().getId().equals(IFacetConstants.WEB_EXTENDED_FACET_ID)) {
                        this.wasFacetVersion = facetVersion.getVersionString();
                        return;
                    }
                    if (!facetVersion.getProjectFacet().getId().equals(IFacetConstants.EJB_EXTENDED_FACET_ID)) continue;
                    this.wasFacetVersion = facetVersion.getVersionString();
                    return;
                }
            }
            catch (Exception e) {
                if (!Activator.isTraceMode()) break block4;
                Activator.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)e));
            }
        }
    }

    private String createOutputDirectory() {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
        File outputDir = PlatformUtil.createTempDir((IProject)iProject);
        return outputDir.getAbsolutePath();
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public String getOutputSrcLocation() {
        return this.outputSrcLocation;
    }

    public String getProject() {
        return this.project;
    }

    public String getWSDLFileName() {
        return CopyWSDLToProjectCommand.getWSDLName(this.wsdlURI);
    }

    public String getAnnotationProcessorGenSrcDir() {
        return this.annotationProcessorGenSrcDir;
    }

    public void setCopyWSDL(boolean copyWSDL) {
        this.copyWSDL = new Boolean(copyWSDL);
    }

    public Boolean getCopyWSDL() {
        if (this.copyWSDL != null) {
            return (boolean)this.copyWSDL;
        }
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getCopyWSDL();
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.genXSDProjects = new Boolean(genXSDProjects);
    }

    public Boolean getGenXSDProjects() {
        if (this.genXSDProjects != null) {
            return (boolean)this.genXSDProjects;
        }
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        if (this.assembleService && this.context.getGenXSDProjects()) {
            return true;
        }
        return false;
    }

    public void setGenWSDDTopDown(boolean genWSDDTopDown) {
        this.genWSDDTopDown = new Boolean(genWSDDTopDown);
    }

    public Boolean getGenWSDDTopDown() {
        if (this.genWSDDTopDown != null) {
            return (boolean)this.genWSDDTopDown;
        }
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getGenWSDDTopDown();
    }

    public Boolean getDisableWrapperStyle() {
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return !this.context.getEnableWrapperStyle();
    }

    public String getServerInstanceId() {
        return this.serverInstanceId;
    }

    public boolean getDefineBindingFiles() {
        return this.bindingFiles != null;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public String getOverrideHostName() {
        return this.overrideHostName;
    }

    public void setOverrideHostName(String overrideHostName) {
        this.overrideHostName = overrideHostName;
    }

    public String[] getBindingFiles() {
        return this.bindingFiles;
    }

    public void setBindingFiles(String[] bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public boolean getEnableMTOM() {
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getEnableMTOMTopDown();
    }

    public String getEarProject() {
        return this.earProject;
    }

    public void setAssembleService(boolean assembleService) {
        this.assembleService = assembleService;
    }

    public String getServerFactoryId() {
        return this.serverFactoryId;
    }

    public String getWasFacetVersion() {
        return this.wasFacetVersion;
    }

    public String getTargetJaxWsVersion() {
        if (this.targetJaxWsVersion != null) {
            return this.targetJaxWsVersion;
        }
        return Activator.getDefault().getCodeGenerationContext().getVersionForJAXWS_Service();
    }

    public void setTargetJaxWsVersion(String targetJaxWsVersion) {
        this.targetJaxWsVersion = targetJaxWsVersion;
    }
}

