/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.jaxws.emitter.util.WSDLCopierUtil;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.eclipse.wst.wsdl.internal.impl.UnknownExtensibilityElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarlyCorrectWSDLEndpointAddrCommand
extends AbstractDataModelOperation {
    private final String SERVICES_STR = "services";
    private final String SOAP12_NS_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private final String defaultHostPort = "http://localhost:9080/";
    private IProject project;
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String guessedWebProjectURL;
    private WebServiceInfo serviceInfo;
    private Hashtable<QName, List<QName>> servicePortsMapping;

    public EarlyCorrectWSDLEndpointAddrCommand(WebServiceInfo info) {
        this.serviceInfo = info;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            if (this.wsdlURI == null) {
                return Status.OK_STATUS;
            }
            if (this.webServicesParser == null) {
                this.webServicesParser = new WebServicesParserExt(this.wsdlURI);
            }
            String projectURL = null;
            String serverInstanceId = this.serviceInfo.getServerInstanceId();
            if (serverInstanceId != null) {
                IServer server = ServerCore.findServer((String)serverInstanceId);
                projectURL = server != null ? ServerUtils.getWebComponentURL((IProject)this.project, null, (IServer)server) : ServerUtils.getEncodedWebComponentURL((IProject)this.project, null);
            }
            if (projectURL == null || projectURL.trim().length() == 0) {
                String webModule = J2EEUtil.getServerContextRoot((IProject)this.project);
                projectURL = "http://localhost:9080/" + webModule + "/";
            }
            if (!projectURL.endsWith("/")) {
                projectURL = String.valueOf(projectURL) + "/";
            }
            this.guessedWebProjectURL = projectURL;
            if (this.wsdlURI != null && this.wsdlURI.startsWith("platform:")) {
                this.wsdlURI = PlatformUtil.getFileURLFromPlatform((String)this.wsdlURI);
            }
            Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
            Map services = definition.getServices();
            for (Service ser : services.values()) {
                Map ports = ser.getPorts();
                block3: for (Port p : ports.values()) {
                    for (Object obj : p.getExtensibilityElements()) {
                        String locationURI;
                        List<QName> modelPorts;
                        boolean mPortsFlag = false;
                        if (obj instanceof SOAPAddress) {
                            SOAPAddress soapAddress = (SOAPAddress)obj;
                            mPortsFlag = this.servicePortsMapping != null ? (modelPorts = this.servicePortsMapping.get(ser.getQName())).size() > 1 : ports.size() > 1;
                            locationURI = this.getLocationURI(ser, p, mPortsFlag, projectURL);
                            soapAddress.setLocationURI(locationURI);
                            continue block3;
                        }
                        if (!(obj instanceof UnknownExtensibilityElementImpl)) continue;
                        UnknownExtensibilityElementImpl unknownElmt = (UnknownExtensibilityElementImpl)obj;
                        unknownElmt.getElement().getNodeName();
                        if (!unknownElmt.getElement().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                        mPortsFlag = this.servicePortsMapping != null ? (modelPorts = this.servicePortsMapping.get(ser.getQName())).size() > 1 : ports.size() > 1;
                        locationURI = this.getLocationURI(ser, p, mPortsFlag, projectURL);
                        unknownElmt.getElement().setAttribute("location", locationURI);
                        continue block3;
                    }
                }
            }
            super.getEnvironment();
            WSDLCopier wsdlCopier = new WSDLCopier(this.webServicesParser);
            wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)this.wsdlURI), definition);
            wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.wsdlURI)));
            wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.wsdlURI));
            IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
            if (status != null && status.getSeverity() == 4) {
                System.err.println(status.getMessage());
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    protected String getLocationURI(Service service, Port port, boolean multiports, String projectURL) {
        StringBuffer serviceURL = new StringBuffer();
        serviceURL.append(projectURL);
        if (!projectURL.endsWith("/")) {
            serviceURL.append("/");
        }
        if (multiports) {
            serviceURL.append("services/");
            serviceURL.append(port.getName());
        } else {
            serviceURL.append(service.getQName().getLocalPart());
        }
        return serviceURL.toString();
    }

    public void setProject(IProject webProject) {
        this.project = webProject;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        if (webServicesParser != null) {
            this.webServicesParser = webServicesParser;
        }
    }

    public String getGuessedWebProjectURL() {
        return this.guessedWebProjectURL;
    }

    public void setDestWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setServicePortsMapping(Hashtable<QName, List<QName>> mapping) {
        this.servicePortsMapping = mapping;
    }
}

