/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class DisableWrapperStyleCommand
extends AbstractDataModelOperation {
    private String disableWrapperStyleFile;
    private boolean disableWrapperStyle;
    private String wsdlURI;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (!this.disableWrapperStyle) {
            return Status.OK_STATUS;
        }
        File outputDir = PlatformUtil.createTempDir();
        String asyncOutputDir = outputDir.getAbsolutePath();
        StringBuffer sb = new StringBuffer(asyncOutputDir);
        sb.append(File.separator);
        sb.append("disableWrapperStyle.xml");
        this.disableWrapperStyleFile = sb.toString();
        return this.copyTemplateToTemp(this.disableWrapperStyleFile);
    }

    private IStatus copyTemplateToTemp(String outputFileName) {
        try {
            String inputLine;
            FileWriter fw = new FileWriter(outputFileName);
            DataInputStream is = new DataInputStream(Activator.getDefault().getBundle().getEntry("/customMappings/disableWrapperStyle.xml").openStream());
            while ((inputLine = is.readLine()) != null) {
                if (inputLine.indexOf("%WSDLPLACEHOLDER%") != -1) {
                    inputLine = inputLine.replaceAll("%WSDLPLACEHOLDER%", this.wsdlURI.trim().replaceAll(" ", "%20"));
                }
                fw.write(String.valueOf(inputLine) + "\n");
            }
            fw.flush();
            fw.close();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    public void setDisableWrapperStyle(boolean b) {
        this.disableWrapperStyle = b;
    }

    public boolean getDisableWrapperStyle() {
        return this.disableWrapperStyle;
    }

    public String getDisableWrapperStyleFile() {
        return this.disableWrapperStyleFile;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }
}

