/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.jaxws.emitter.util.WSDLCopierUtil;
import com.ibm.xwt.wsdl.binding.soap12.SOAP12Address;
import java.io.File;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.eclipse.wst.wsdl.internal.impl.UnknownExtensibilityElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyWSDLToProjectCommand
extends AbstractDataModelOperation {
    protected boolean copyWSDL = false;
    protected boolean soap12Binding = false;
    protected final String WSDL_FOLDER = "wsdl";
    private final String SERVICES_STR = "services";
    protected WebServiceInfo serviceInfo;
    protected WebServicesParser webServicesParser;
    protected IProject project;
    protected String wsdlURI;
    protected String destWsdlURI;
    protected boolean isBottomUp;
    private String outputSrcLocation;
    private String wsdlServiceName;
    private String guessedWebProjectURL;
    private String overrideHostName;
    protected String wsdlLocation = null;
    protected String wsdlRelativePath = null;
    protected String originalOutputWsdlURI = null;
    private String wsdlLocImplBean = null;
    protected Hashtable<QName, List<QName>> servicePortsMapping;
    private final String defaultHostPort = "http://localhost:9080/";
    private final String SOAP12_NS_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";

    public CopyWSDLToProjectCommand(WebServiceInfo info, boolean isBottomUp) {
        this.serviceInfo = info;
        this.isBottomUp = isBottomUp;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.soap12Binding) {
            this.copyWSDL = true;
        }
        if (this.wsdlLocImplBean != null && this.wsdlLocImplBean.length() > 0) {
            this.copyWSDL = false;
        }
        if (!this.copyWSDL) {
            this.guessedWebProjectURL = null;
            this.destWsdlURI = null;
            return Status.OK_STATUS;
        }
        super.getEnvironment();
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        if (this.isBottomUp) {
            this.setupWSDLURIForBottomUpScenario();
        }
        IPath wsdlPath = this.project.getFullPath();
        IVirtualFolder ivFolder = this.getDDFolderForProject();
        wsdlPath = this.getWSDLPath(wsdlPath, ivFolder);
        this.originalOutputWsdlURI = this.destWsdlURI = PlatformUtil.getPlatformFromPath((String)wsdlPath.toString());
        WSDLCopier wsdlCopier = new WSDLCopier(this.webServicesParser);
        wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)this.wsdlURI), this.correctEndpointAddressesInWSDL(this.wsdlURI, this.servicePortsMapping));
        wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.destWsdlURI)));
        wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.destWsdlURI));
        CopyWsdlFileOperation copyOp = new CopyWsdlFileOperation(wsdlCopier, adaptable);
        try {
            copyOp.run(monitor);
            IStatus status = copyOp.getStatus();
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            IPath relativePath = wsdlCopier.getRelativePath();
            this.wsdlRelativePath = relativePath.toString();
            this.wsdlLocation = this.getWSDLInfRelativePath(relativePath);
            if (relativePath.segmentCount() > 1) {
                wsdlPath = this.project.getFullPath();
                wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
                wsdlPath = wsdlPath.append("wsdl").append(relativePath);
                this.destWsdlURI = PlatformUtil.getPlatformFromPath((String)wsdlPath.toString());
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    protected IVirtualFolder getDDFolderForProject() {
        return J2EEUtil.getWebDeploymentDescriptorFolder((IProject)this.project);
    }

    protected IPath getWSDLPath(IPath wsdlPath, IVirtualFolder ivFolder) {
        wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
        wsdlPath = wsdlPath.append("wsdl").append(CopyWSDLToProjectCommand.getWSDLName(this.wsdlURI));
        return wsdlPath;
    }

    protected String getWSDLInfRelativePath(IPath relativePath) {
        return new Path("WEB-INF").append("wsdl").append(relativePath).toString();
    }

    protected IProject getWebFacingProject() {
        return this.project;
    }

    protected Definition correctEndpointAddressesInWSDL(String wsdlToModifyURI, Hashtable<QName, List<QName>> servicePortsMapping) {
        String projectURL = null;
        String serverInstanceId = this.serviceInfo.getServerInstanceId();
        if (serverInstanceId != null) {
            IServer server = ServerCore.findServer((String)serverInstanceId);
            if (server != null) {
                int serverState = server.getServerState();
                if (serverState != 4) {
                    projectURL = ServerUtils.getWebComponentURL((IProject)this.getWebFacingProject(), null, (IServer)server);
                }
            } else {
                projectURL = ServerUtils.getEncodedWebComponentURL((IProject)this.getWebFacingProject(), null);
            }
        }
        String webModule = J2EEUtil.getServerContextRoot((IProject)this.getWebFacingProject());
        if (projectURL == null || projectURL.trim().length() == 0) {
            projectURL = "http://localhost:9080/" + webModule + "/";
        }
        if (this.overrideHostName != null) {
            projectURL = String.valueOf(this.overrideHostName) + webModule + "/";
        }
        this.guessedWebProjectURL = projectURL;
        Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
        Map services = definition.getServices();
        for (Service ser : services.values()) {
            Map ports = ser.getPorts();
            block1: for (Port p : ports.values()) {
                for (Object obj : p.getExtensibilityElements()) {
                    String locationURI;
                    List<QName> modelPorts;
                    SOAPAddress soapAddress;
                    boolean mPortsFlag = false;
                    if (obj instanceof SOAPAddress) {
                        soapAddress = (SOAPAddress)obj;
                        mPortsFlag = servicePortsMapping != null ? (modelPorts = servicePortsMapping.get(ser.getQName())) != null && modelPorts.size() > 1 : ports.size() > 1;
                        locationURI = this.getLocationURI(ser.getQName().getLocalPart(), p, mPortsFlag, projectURL);
                        soapAddress.setLocationURI(locationURI);
                        continue block1;
                    }
                    if (obj instanceof SOAP12Address) {
                        soapAddress = (SOAP12Address)obj;
                        mPortsFlag = servicePortsMapping != null ? (modelPorts = servicePortsMapping.get(ser.getQName())) != null && modelPorts.size() > 1 : ports.size() > 1;
                        locationURI = this.getLocationURI(ser.getQName().getLocalPart(), p, mPortsFlag, projectURL);
                        soapAddress.setLocationURI(locationURI);
                        continue block1;
                    }
                    if (!(obj instanceof UnknownExtensibilityElementImpl)) continue;
                    UnknownExtensibilityElementImpl unknownElmt = (UnknownExtensibilityElementImpl)obj;
                    unknownElmt.getElement().getNodeName();
                    if (!unknownElmt.getElement().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                    mPortsFlag = servicePortsMapping != null ? (modelPorts = servicePortsMapping.get(ser.getQName())).size() > 1 : ports.size() > 1;
                    locationURI = this.getLocationURI(ser.getQName().getLocalPart(), p, mPortsFlag, projectURL);
                    unknownElmt.getElement().setAttribute("location", locationURI);
                    continue block1;
                }
            }
        }
        return definition;
    }

    protected String getLocationURI(String service, Port port, boolean multiports, String projectURL) {
        StringBuffer serviceURL = new StringBuffer();
        serviceURL.append(projectURL);
        if (!projectURL.endsWith("/")) {
            serviceURL.append("/");
        }
        if (multiports) {
            serviceURL.append(port.getName());
        } else {
            serviceURL.append(service);
        }
        return serviceURL.toString();
    }

    protected void setupWSDLURIForBottomUpScenario() {
        StringBuffer sb = new StringBuffer(this.outputSrcLocation);
        if (!this.outputSrcLocation.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(this.wsdlServiceName);
        sb.append(".wsdl");
        File wsdlFile = new File(sb.toString());
        try {
            this.wsdlURI = URLDecoder.decode(wsdlFile.toURI().toString(), "UTF-8");
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            this.wsdlURI = wsdlFile.toURI().toString();
        }
    }

    public void setCopyWSDL(Boolean copyWSDL) {
        this.copyWSDL = copyWSDL;
    }

    public Boolean getCopyWSDL() {
        return this.copyWSDL;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static String getWSDLName(String uri) {
        String wsdlName = CopyWSDLToProjectCommand.getName(uri).trim();
        if (wsdlName.equals("")) {
            wsdlName = "default.wsdl";
        } else if (!wsdlName.endsWith(".wsdl")) {
            if (wsdlName.toLowerCase().endsWith(".wsdl")) {
                int lastDot = wsdlName.lastIndexOf(".");
                wsdlName = String.valueOf(wsdlName.substring(0, lastDot)) + ".wsdl";
            } else {
                wsdlName = String.valueOf(wsdlName) + ".wsdl";
            }
        }
        return wsdlName;
    }

    public static String getName(String uri) {
        int slash;
        int bslash = uri.lastIndexOf("\\");
        int i = bslash > (slash = uri.lastIndexOf("/")) ? bslash : slash;
        String fileName = uri.substring(i + 1).replace('?', '.');
        return fileName;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public String getDestWsdlURI() {
        return this.destWsdlURI;
    }

    public String getGuessedWebProjectURL() {
        return this.guessedWebProjectURL;
    }

    public void setOutputSrcLocation(String outputSrcLocation) {
        this.outputSrcLocation = outputSrcLocation;
    }

    public void setWsdlServiceName(String wsdlServiceName) {
        this.wsdlServiceName = wsdlServiceName;
    }

    public void setOverrideHostName(String overrideHostName) {
        if (overrideHostName != null) {
            this.overrideHostName = "http://" + overrideHostName + "/";
        }
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWsdlLocImplBean(String loc) {
        this.wsdlLocImplBean = loc;
    }

    public void setSoap12Binding(boolean soap12) {
        this.soap12Binding = soap12;
    }

    public void setServicePortsMapping(Hashtable<QName, List<QName>> mapping) {
        this.servicePortsMapping = mapping;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getOriginalOutputWsdlURI() {
        return this.originalOutputWsdlURI;
    }

    class CopyWsdlFileOperation
    extends WorkspaceModifyOperation {
        private IAdaptable adaptable;
        private WSDLCopier wsdlCopier;
        private IStatus status;

        CopyWsdlFileOperation(WSDLCopier wsdlCopier, IAdaptable adaptable) {
            this.wsdlCopier = wsdlCopier;
            this.adaptable = adaptable;
        }

        protected void execute(IProgressMonitor monitor) {
            this.status = WSDLCopierUtil.run((WSDLCopier)this.wsdlCopier, (IProgressMonitor)monitor);
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

