/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationContext;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.jaxws.emitter.util.PlatformUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.AbstractWebServiceClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFromWSDLInputCommand
extends AbstractDataModelOperation {
    private static final String WAS7_SERVER_FACTORY = "com.ibm.ws.ast.st.v7.server";
    private static final String WAS61_SERVER_FACTORY = "com.ibm.ws.ast.st.v61.server";
    private static final String UNKNOWN_WAS_FACET_VERSION = "was.facet.version.unknown";
    private AbstractWebServiceClient client = null;
    private String project;
    private String earProject;
    private String wsdlURI;
    private String outputSrcLocation;
    private WebServicesParser webServicesParser;
    private CodeGenerationContext context = null;
    private String serverInstanceId;
    private String serverFactoryId;
    private ArrayList<String> validTargetPaths;
    private String targetPath;
    private String annotationProcessorGenSrcDir;
    private String[] bindingFiles = null;
    private String wasFacetVersion;
    private String targetJaxWsVersion = null;

    public ClientFromWSDLInputCommand(AbstractWebServiceClient client, String project, String earProject) {
        this.client = client;
        this.project = project;
        this.earProject = earProject;
        this.initValidTargetPaths();
    }

    public ArrayList<String> getValidTargetPaths() {
        return this.validTargetPaths;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    private final IStatus initValidTargetPaths() {
        this.targetPath = "";
        this.validTargetPaths = new ArrayList();
        IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
        IJavaProject javaProject = JavaCore.create((IProject)currentProject);
        try {
            try {
                try {
                    IPath genSrcPath = javaProject.getProject().getFullPath();
                    this.annotationProcessorGenSrcDir = genSrcPath.append(AptConfig.getGenSrcDir((IJavaProject)javaProject)).toString();
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in ClientFromWSDLInputCommand.initValidTargetPaths(): " + e.getMessage()), (Throwable)e));
                }
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int j = 0;
                while (j < packageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
                    IPath targetIPath = packageFragmentRoot.getPath();
                    if (packageFragmentRoot.getKind() == 1) {
                        String targetPathString = targetIPath.toString();
                        this.validTargetPaths.add(targetPathString);
                        boolean hasHiddenDirectories = false;
                        int k = 0;
                        while (k < targetIPath.segmentCount()) {
                            if (targetIPath.segment(k).startsWith(".")) {
                                hasHiddenDirectories = true;
                                break;
                            }
                            ++k;
                        }
                        if (!hasHiddenDirectories) {
                            this.targetPath = targetPathString;
                        } else if (this.targetPath.length() == 0) {
                            this.targetPath = targetPathString;
                        }
                    }
                    ++j;
                }
            }
            catch (JavaModelException e) {
                IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                if (this.targetPath.length() == 0 && this.validTargetPaths.size() > 0) {
                    this.targetPath = this.validTargetPaths.get(0);
                }
                return iStatus;
            }
        }
        finally {
            if (this.targetPath.length() == 0 && this.validTargetPaths.size() > 0) {
                this.targetPath = this.validTargetPaths.get(0);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        this.serverInstanceId = this.client.getWebServiceClientInfo().getServerInstanceId();
        this.serverFactoryId = this.client.getWebServiceClientInfo().getServerFactoryId();
        this.wsdlURI = this.client.getWebServiceClientInfo().getWsdlURL();
        if (this.wsdlURI.startsWith("platform:/resource")) {
            this.wsdlURI = PlatformUtil.getFileURLFromPlatform((String)this.wsdlURI);
        }
        this.outputSrcLocation = this.createOutputDirectory();
        this.setupWasFacetVersion();
        return Status.OK_STATUS;
    }

    private void setupWasFacetVersion() {
        block6: {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject == null || JavaUtil.isUnmanagedProject((IProject)project) || JavaEEProjectUtilities.isUtilityProject((IProject)project)) {
                    this.extrapolateWASFacetVersionFromServerFactoryID();
                }
                Set projFacets = fProject.getProjectFacets();
                for (IProjectFacetVersion facetVersion : projFacets) {
                    if (facetVersion.getProjectFacet().getId().equals(IFacetConstants.WEB_EXTENDED_FACET_ID)) {
                        this.wasFacetVersion = facetVersion.getVersionString();
                        return;
                    }
                    if (!facetVersion.getProjectFacet().getId().equals(IFacetConstants.EJB_EXTENDED_FACET_ID)) continue;
                    this.wasFacetVersion = facetVersion.getVersionString();
                    return;
                }
            }
            catch (Exception e) {
                if (!Activator.isTraceMode()) break block6;
                Activator.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)e));
            }
        }
        if (this.wasFacetVersion == null) {
            this.wasFacetVersion = UNKNOWN_WAS_FACET_VERSION;
        }
    }

    private void extrapolateWASFacetVersionFromServerFactoryID() {
        if (this.serverFactoryId.startsWith(WAS7_SERVER_FACTORY)) {
            this.wasFacetVersion = "7.0";
        } else if (this.serverFactoryId.startsWith(WAS61_SERVER_FACTORY)) {
            this.wasFacetVersion = "6.1";
        }
    }

    private String createOutputDirectory() {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project);
        File outputDir = PlatformUtil.createTempDir((IProject)iProject);
        return outputDir.getAbsolutePath();
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public Boolean getCopyWSDL() {
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getClientCopyWSDL();
    }

    public Boolean getGenWSDDClient() {
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getGenWSDDClient();
    }

    public String getOutputSrcLocation() {
        return this.outputSrcLocation;
    }

    public String getProject() {
        return this.project;
    }

    public String getEarProject() {
        return this.earProject;
    }

    public WebServicesParser getWebServicesParser() {
        if (this.webServicesParser == null) {
            this.webServicesParser = new WebServicesParserExt();
        }
        return this.webServicesParser;
    }

    public String getAnnotationProcessorGenSrcDir() {
        return null;
    }

    public boolean getAsyncMapping() {
        if (this.context == null) {
            this.context = Activator.getDefault().getCodeGenerationContext();
        }
        return this.context.getEnableAsync();
    }

    public String getServerInstanceId() {
        return this.serverInstanceId;
    }

    public String getServerFactoryId() {
        return this.serverFactoryId;
    }

    public boolean getDefineBindingFiles() {
        return this.bindingFiles != null;
    }

    public String[] getBindingFiles() {
        return this.bindingFiles;
    }

    public void setBindingFiles(String[] bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public boolean getGenXSDProjects() {
        return false;
    }

    public String getWasFacetVersion() {
        return this.wasFacetVersion;
    }

    public String getTargetJaxWsVersion() {
        if (this.targetJaxWsVersion != null) {
            return this.targetJaxWsVersion;
        }
        return Activator.getDefault().getCodeGenerationContext().getVersionForJAXWS_Client();
    }

    public void setTargetJaxWsVersion(String targetJaxWsVersion) {
        this.targetJaxWsVersion = targetJaxWsVersion;
    }
}

