/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.ui.widget;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.ejb.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.creation.ejb.util.JMSUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class JaxWSRouterWidget
extends SimpleWidgetDataContributor {
    private final String pluginId = "com.ibm.ast.ws.jaxws.creation.ejb.ui";
    private Listener statusListener;
    private boolean isHttp;
    private boolean isJMS;
    private Text wsdlBindings;
    private String INFOPOP_PTEB_TEXT_BINDINGS = "PTEB0001";
    private Combo httpRouterProjectCombo;
    private String INFOPOP_PTEB_COMBO_ROUTER_HTTP = "PTEB0003";
    private Combo jmsRouterProjectCombo;
    private String INFOPOP_PTEB_COMBO_ROUTER_JMS = "PTEB0004";
    private Combo mdbDeploymentMechanism;
    private final String INFOPOP_PBJMS_MDB_DEPLOYMENT = "PTEB0005";
    private Text activationSpecText;
    private final String INFOPOP_PBJMS_ACTIVATIONSPEC = "PTEB0006";
    private Text listenerInputPortText;
    private final String INFOPOP_PBJMS_PORT = "PTEB0007";

    public void setServices(List<JAXWSWebServiceService> services) {
        this.isHttp = services.get(0).isHTTPBinding();
        this.isJMS = services.get(0).isJMSBinding();
        this.httpRouterProjectCombo.setEnabled(this.isHttp);
        this.jmsRouterProjectCombo.setEnabled(this.isJMS);
        this.mdbDeploymentMechanism.setEnabled(this.isJMS);
        this.activationSpecText.setEnabled(this.isJMS);
        this.listenerInputPortText.setEnabled(this.isJMS);
        if (this.isJMS) {
            this.handleMDBDeploymentEvent();
        }
        if (this.isHttp && this.isJMS) {
            this.wsdlBindings.setText(Messages.LABEL_BINDINGS_JMS_HTTP);
        } else if (this.isHttp) {
            this.wsdlBindings.setText(Messages.LABEL_BINDING_HTTP);
        } else if (this.isJMS) {
            this.wsdlBindings.setText(Messages.LABEL_BINDING_JMS);
        }
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        TextBoxModifyListener modListener = new TextBoxModifyListener();
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxws.creation.ejb.ui");
        Group group = uiUtils.createGroup(parent, Messages.LABEL_BINDINGS_ROUTERS, Messages.TOOLTIP_BINDINGS_ROUTERS, null);
        Composite composite = uiUtils.createComposite((Composite)group, 2);
        this.wsdlBindings = uiUtils.createText(composite, Messages.LABEL_WSDL_BINDINGS, null, this.INFOPOP_PTEB_TEXT_BINDINGS, 2056);
        uiUtils.createHorizontalSeparator((Composite)group, 10);
        new Label((Composite)group, 256);
        composite = uiUtils.createComposite((Composite)group, 2);
        this.httpRouterProjectCombo = uiUtils.createCombo(composite, Messages.LABEL_ROUTER_HTTP, Messages.TOOLTIP_COMBO_ROUTER_HTTP, this.INFOPOP_PTEB_COMBO_ROUTER_HTTP, 2052);
        new Label(composite, 256);
        new Label(composite, 256);
        uiUtils.createHorizontalSeparator((Composite)group, 10);
        composite = uiUtils.createComposite((Composite)group, 2);
        this.jmsRouterProjectCombo = uiUtils.createCombo(composite, Messages.LABEL_ROUTER_JMS, Messages.TOOLTIP_COMBO_ROUTER_JMS, this.INFOPOP_PTEB_COMBO_ROUTER_JMS, 2052);
        new Label(composite, 256);
        new Label(composite, 256);
        this.mdbDeploymentMechanism = uiUtils.createCombo(composite, Messages.LABEL_JMS_MDB_DEPLOYMENT, Messages.TOOLTIP_JMS_COMBO_MDB_DEPLOYMENT, "PTEB0005", 2060);
        this.mdbDeploymentMechanism.add(Messages.COMBO_DESINATION_ACTIVATIONSPEC);
        this.mdbDeploymentMechanism.add(Messages.COMBO_DESINATION_LISTENERPORT);
        this.mdbDeploymentMechanism.select(0);
        this.mdbDeploymentMechanism.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JaxWSRouterWidget.this.handleMDBDeploymentEvent();
            }
        });
        this.activationSpecText = uiUtils.createText(composite, Messages.LABEL_JMS_ACTIVATIONSPECNAME, Messages.TOOLTIP_JMS_ACTIVATIONSPECNAME, "PTEB0006", 2052);
        this.activationSpecText.addModifyListener((ModifyListener)modListener);
        this.listenerInputPortText = uiUtils.createText(composite, Messages.LABEL_JMS_LISTENERNAME, Messages.TOOLTIP_JMS_LISTENERNAME, "PTEB0007", 2052);
        this.listenerInputPortText.addModifyListener((ModifyListener)modListener);
        new Label((Composite)group, 256);
        return this;
    }

    public IStatus getStatus() {
        IStatus finalStatus = this.verifyJMSFields();
        return finalStatus;
    }

    private void handleMDBDeploymentEvent() {
        boolean isActivationSpec = this.mdbDeploymentMechanism.getSelectionIndex() == 0;
        this.activationSpecText.setEnabled(isActivationSpec);
        this.listenerInputPortText.setEnabled(!isActivationSpec);
        this.statusListener.handleEvent(null);
    }

    private IStatus verifyJMSFields() {
        IStatus finalStatus = Status.OK_STATUS;
        if (!this.isJMS) {
            return finalStatus;
        }
        if (this.activationSpecText.getText().trim().equals("") && this.mdbDeploymentMechanism.getSelectionIndex() == 0) {
            finalStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_SOAPJMS_FIELD_BLANK, (Object[])new Object[]{Messages.MSG_ERROR_JMS_ACTIVATIONSPECNAME}));
            return finalStatus;
        }
        if (this.listenerInputPortText.getText().trim().equals("") && this.mdbDeploymentMechanism.getSelectionIndex() == 1) {
            finalStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_SOAPJMS_FIELD_BLANK, (Object[])new Object[]{Messages.LABEL_JMS_LISTENERNAME}));
            return finalStatus;
        }
        return finalStatus;
    }

    private void prepareRouterCombo(Combo combo, List<String> routerProjectNames) {
        combo.removeAll();
        for (String routerProjectName : routerProjectNames) {
            combo.add(routerProjectName);
        }
        combo.select(0);
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProjectCombo.getText();
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProjectCombo.getText();
    }

    public void setHttpRouterProjectNames(List<String> httpRouterProjectNames) {
        this.prepareRouterCombo(this.httpRouterProjectCombo, httpRouterProjectNames);
    }

    public void setJmsRouterProjectNames(List<String> jmsRouterProjectNames) {
        this.prepareRouterCombo(this.jmsRouterProjectCombo, jmsRouterProjectNames);
    }

    public JMSUtil.DEPLOYMENT_MECHANISM getDeploymentMechanism() {
        if (this.mdbDeploymentMechanism == null) {
            return null;
        }
        if (this.mdbDeploymentMechanism.getSelectionIndex() == 0) {
            return JMSUtil.DEPLOYMENT_MECHANISM.ACTIVATION_SPEC;
        }
        return JMSUtil.DEPLOYMENT_MECHANISM.LISTENER_PORT;
    }

    public String getMdbActivateName() {
        if (this.mdbDeploymentMechanism != null) {
            if (this.mdbDeploymentMechanism.getSelectionIndex() == 0) {
                return this.activationSpecText.getText();
            }
            return this.listenerInputPortText.getText();
        }
        return null;
    }

    private class TextBoxModifyListener
    implements ModifyListener {
        private TextBoxModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            JaxWSRouterWidget.this.statusListener.handleEvent(null);
        }
    }
}

