/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.ui.widget;

import com.ibm.ast.ws.jaxws.creation.ejb.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.creation.ejb.util.JMSURLParser;
import com.ibm.ast.ws.jaxws.creation.ejb.util.JMSUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class JaxWSJmsConfigWidget
extends SimpleWidgetDataContributor {
    private Combo destinationCombo_;
    private final String INFOPOP_PBJMS_DEST_TYPE = "PBJMS0003";
    private Combo jndiNameCombo_;
    private final String INFOPOP_PBJMS_DEST = "PBJMS0004";
    private Combo connectionFactoryCombo_;
    private final String INFOPOP_PBJMS_CF = "PBJMS0005";
    private Text jmsInitialContextFactoryText_;
    private final String INFOPOP_PBJMS_INITIALCONTEXTFACTORY = "PBJMS0008";
    private Text jmsJndiProviderURLText_;
    private final String INFOPOP_PBJMS_JNDIPROVIDERURL = "PBJMS0009";
    private Combo deliveryModeCombo_;
    private final String INFOPOP_PBJMS_DELIVERYMODE = "PBJMS0010";
    private Text timeToLiveText_;
    private final String INFOPOP_PBJMS_TIMETOLIVE = "PBJMS0011";
    private Combo priorityCombo_;
    private final String INFOPOP_PBJMS_PRIORITY = "PBJMS0012";
    private Text replyToText_;
    private final String INFOPOP_PBJMS_REPLYTONAME = "PBJMS0022";
    private Text userText_;
    private final String INFOPOP_PBJMS_USERID = "PBJMS0013";
    private Text passwordText_;
    private final String INFOPOP_PBJMS_PWD = "PBJMS0014";
    private Button useNewJMSProtocolCheckBox_;
    private final String INFOPOP_PBJMS_NEWPROTOCOL = "PBJMS0015";
    private Group jmsBindingGroup;
    private String JMSLocation;
    private final String pluginId_ = "com.ibm.ast.ws.jaxws.creation";
    private final String QUEUE = "queue";
    private final String TOPIC = "topic";
    private IWizardContainer context_ = null;
    private Composite parent_ = null;
    private String wasVersion = null;
    private String remoteInterfaceName;
    private String ejbClassName;
    private String homeInterfaceName;
    private String ejbJndiName;
    private Listener statusListener_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        UIUtils uiUtils = new UIUtils("com.ibm.ast.ws.jaxws.creation");
        TextBoxModifyListener modListener = new TextBoxModifyListener();
        this.jmsBindingGroup = uiUtils.createGroup(parent, Messages.LABEL_JMS_BINDING, "test", null);
        Composite composite = uiUtils.createComposite((Composite)this.jmsBindingGroup, 2);
        this.destinationCombo_ = uiUtils.createCombo(composite, Messages.LABEL_JMS_DESINATION, Messages.TOOLTIP_JMS_DESTINATION, "PBJMS0003", 2060);
        this.destinationCombo_.add(Messages.COMBO_DESINATION_QUEUE);
        this.destinationCombo_.add(Messages.COMBO_DESINATION_TOPIC);
        this.destinationCombo_.select(0);
        this.jndiNameCombo_ = uiUtils.createCombo(composite, Messages.LABEL_JMS_JNDINAME, Messages.TOOLTIP_JMS_JNDINAME, "PBJMS0004", 2052);
        this.jndiNameCombo_.addModifyListener((ModifyListener)modListener);
        this.connectionFactoryCombo_ = uiUtils.createCombo(composite, Messages.LABEL_JMS_CONNECTIONFACTORY, Messages.TOOLTIP_JMS_CONNECTIONFACTORY, "PBJMS0005", 2052);
        this.connectionFactoryCombo_.addModifyListener((ModifyListener)modListener);
        this.jmsInitialContextFactoryText_ = uiUtils.createText(composite, Messages.LABEL_JMS_INITIALCONTEXTFACTORY, Messages.TOOLTIP_JMS_INITIALCONTEXTFACTORY, "PBJMS0008", 2052);
        this.jmsJndiProviderURLText_ = uiUtils.createText(composite, Messages.LABEL_JMS_JNDIPROVIDERURL, Messages.TOOLTIP_JMS_JNDIPROVIDERURL, "PBJMS0009", 2052);
        this.deliveryModeCombo_ = uiUtils.createCombo(composite, Messages.LABEL_JMS_DELIVERYMODE, Messages.TOOLTIP_JMS_DELIVERYMODE, "PBJMS0010", 2060);
        this.deliveryModeCombo_.removeAll();
        this.deliveryModeCombo_.add("1");
        this.deliveryModeCombo_.add("2");
        this.deliveryModeCombo_.select(0);
        this.timeToLiveText_ = uiUtils.createText(composite, Messages.LABEL_JMS_TIMETOLIVE, Messages.TOOLTIP_JMS_TIMETOLIVE, "PBJMS0011", 2052);
        this.priorityCombo_ = uiUtils.createCombo(composite, Messages.LABEL_JMS_PRIORITY, Messages.TOOLTIP_JMS_PRIORITY, "PBJMS0012", 2060);
        this.priorityCombo_.removeAll();
        int i = 0;
        while (i < 10) {
            Integer temp = new Integer(i);
            this.priorityCombo_.add(temp.toString());
            ++i;
        }
        this.priorityCombo_.select(4);
        this.replyToText_ = uiUtils.createText(composite, Messages.LABEL_JMS_REPLY_TO_NAME, Messages.TOOLTIP_JMS_REPLY_TO_NAME, "PBJMS0022", 2052);
        this.userText_ = uiUtils.createText(composite, Messages.LABEL_JMS_USERID, Messages.TOOLTIP_JMS_USERID, "PBJMS0013", 2052);
        this.passwordText_ = uiUtils.createText(composite, Messages.LABEL_JMS_PWD, Messages.TOOLTIP_JMS_PWD, "PBJMS0011", 0x400804);
        this.useNewJMSProtocolCheckBox_ = uiUtils.createCheckbox((Composite)this.jmsBindingGroup, Messages.LABEL_JMS_USENEW_PROTOCOL, Messages.TOOLTIP_JMS_USENEW_PROTOCOL, "PBJMS0015");
        return this;
    }

    private String constructNewJMSURL() {
        StringBuffer location = new StringBuffer();
        location.append("jms:jndi:");
        location.append(this.jndiNameCombo_.getText());
        location.append("?jndiConnectionFactoryName=");
        location.append(this.connectionFactoryCombo_.getText());
        if (!this.jmsInitialContextFactoryText_.getText().equals("")) {
            location.append("&jndiInitialContextFactory=");
            location.append(this.jmsInitialContextFactoryText_.getText());
        }
        if (!this.jmsJndiProviderURLText_.getText().equals("")) {
            location.append("&jndiURL=");
            location.append(this.jmsJndiProviderURLText_.getText());
        }
        if (this.deliveryModeCombo_.getSelectionIndex() != 0) {
            location.append("&deliveryMode=");
            location.append(this.deliveryModeCombo_.getItem(this.deliveryModeCombo_.getSelectionIndex()));
        }
        if (!this.timeToLiveText_.getText().equals("")) {
            location.append("&timeToLive=").append(this.timeToLiveText_.getText());
        }
        if (this.priorityCombo_.getSelectionIndex() != 4) {
            location.append("&priority=");
            location.append(this.priorityCombo_.getItem(this.priorityCombo_.getSelectionIndex()));
        }
        if (!this.userText_.getText().equals("")) {
            location.append("&user=").append(this.userText_.getText());
        }
        if (!this.passwordText_.getText().equals("")) {
            location.append("&password=").append(this.passwordText_.getText());
        }
        return location.toString();
    }

    private String constructOldJMSURL(String destination) {
        StringBuffer location = new StringBuffer();
        location.append("jms:/");
        location.append(destination);
        location.append("?destination=");
        location.append(this.jndiNameCombo_.getText());
        location.append("&connectionFactory=");
        location.append(this.connectionFactoryCombo_.getText());
        if (!this.jmsInitialContextFactoryText_.getText().equals("")) {
            location.append("&initialContextFactory=");
            location.append(this.jmsInitialContextFactoryText_.getText());
        }
        if (!this.jmsJndiProviderURLText_.getText().equals("")) {
            location.append("&jndiProviderURL=");
            location.append(this.jmsJndiProviderURLText_.getText());
        }
        if (this.deliveryModeCombo_.getSelectionIndex() != 0) {
            location.append("&deliveryMode=");
            location.append(this.deliveryModeCombo_.getItem(this.deliveryModeCombo_.getSelectionIndex()));
        }
        if (!this.timeToLiveText_.getText().equals("")) {
            location.append("&timeToLive=").append(this.timeToLiveText_.getText());
        }
        if (this.priorityCombo_.getSelectionIndex() != 4) {
            location.append("&priority=");
            location.append(this.priorityCombo_.getItem(this.priorityCombo_.getSelectionIndex()));
        }
        if (!this.replyToText_.getText().equals("")) {
            location.append("&replyToName=");
            location.append(this.replyToText_.getText());
        }
        if (!this.userText_.getText().equals("")) {
            location.append("&user=").append(this.userText_.getText());
        }
        if (!this.passwordText_.getText().equals("")) {
            location.append("&password=").append(this.passwordText_.getText());
        }
        return location.toString();
    }

    public String getJmsEndpointURL() {
        String destination = null;
        destination = this.destinationCombo_.getSelectionIndex() == 0 ? "queue" : "topic";
        if (this.was7orAbove() && this.useNewJMSProtocolCheckBox_.getSelection()) {
            return this.constructNewJMSURL();
        }
        return this.constructOldJMSURL(destination);
    }

    public IStatus getStatus() {
        IStatus finalStatus = this.verifyJMSFields();
        return finalStatus;
    }

    private IStatus verifyJMSFields() {
        IStatus finalStatus = Status.OK_STATUS;
        if (!this.jmsBindingGroup.getVisible()) {
            return finalStatus;
        }
        if (this.jndiNameCombo_.getText().trim().equals("")) {
            finalStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_SOAPJMS_FIELD_BLANK, (Object[])new Object[]{Messages.MSG_ERROR_JMS_JNDINAME}));
            return finalStatus;
        }
        if (this.connectionFactoryCombo_.getText().trim().equals("")) {
            finalStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_SOAPJMS_FIELD_BLANK, (Object[])new Object[]{Messages.MSG_ERROR_JMS_CONNECTIONFACTORY}));
            return finalStatus;
        }
        return finalStatus;
    }

    public void setWasFacetVersion(String wasVersion) {
        this.wasVersion = wasVersion;
        if (wasVersion != null) {
            boolean was7OrAbove = this.was7orAbove();
            this.useNewJMSProtocolCheckBox_.setVisible(was7OrAbove);
            if (was7OrAbove) {
                this.useNewJMSProtocolCheckBox_.setSelection(was7OrAbove);
            }
        }
    }

    private boolean was7orAbove() {
        if (this.wasVersion != null) {
            return !this.wasVersion.equals("6.0") && !this.wasVersion.equals("6.1");
        }
        return false;
    }

    public JMSUtil.DESTINATION_TYPE getDestinationType() {
        if (this.destinationCombo_ == null) {
            return null;
        }
        if (this.destinationCombo_.getSelectionIndex() == 0) {
            return JMSUtil.DESTINATION_TYPE.QUEUE;
        }
        return JMSUtil.DESTINATION_TYPE.TOPIC;
    }

    public void setJMSLocation(String jMsLocation) {
        this.JMSLocation = jMsLocation;
        JMSURLParser parser = new JMSURLParser();
        try {
            parser.parse(this.JMSLocation);
            this.updateWidgetFields(parser);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void updateWidgetFields(JMSURLParser jmsParser) {
        if (jmsParser.isQueue()) {
            this.destinationCombo_.select(0);
        } else {
            this.destinationCombo_.select(1);
        }
        if (jmsParser.isSoapJMSInteropURL()) {
            this.connectionFactoryCombo_.setText((String)jmsParser.get(jmsParser.JNDICONNECTIONFACTORYNAME));
        } else {
            jmsParser.getClass();
            this.connectionFactoryCombo_.setText((String)jmsParser.get("connectionFactory"));
        }
        this.jndiNameCombo_.setText((String)jmsParser.get(jmsParser.DESTINATION));
        String info = (String)jmsParser.get(jmsParser.JNDIINITIALCONTEXTFACTORY);
        if (info == null) {
            info = (String)jmsParser.get(jmsParser.INITIALCONTEXTFACTORY);
        }
        if (info != null) {
            this.jmsInitialContextFactoryText_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.JNDIURL)) == null) {
            info = (String)jmsParser.get(jmsParser.JNDIPROVIDERURL);
        }
        if (info != null) {
            this.jmsJndiProviderURLText_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.DELIVERYMODE)) != null) {
            this.deliveryModeCombo_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.TIMETOLIVE)) != null) {
            this.timeToLiveText_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.PRIORITY)) != null) {
            this.priorityCombo_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.REPLYTONAME)) != null) {
            this.replyToText_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.USER)) != null) {
            this.userText_.setText(info);
        }
        if ((info = (String)jmsParser.get(jmsParser.PASSWORD)) != null) {
            this.passwordText_.setText(info);
        }
    }

    private class TextBoxModifyListener
    implements ModifyListener {
        private TextBoxModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            JaxWSJmsConfigWidget.this.statusListener_.handleEvent(null);
        }
    }
}

