/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.command;

import com.ibm.ast.ws.jaxws.creation.command.FromWSDLInputCommand;
import com.ibm.ast.ws.jaxws.creation.ejb.util.EJBRouterComboUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class EjbWsFromWSDLInputCommand
extends FromWSDLInputCommand {
    private IProject ejbProject_;
    private IProject earProject_;
    private List<String> httpRouterProjectNames_;
    private List<String> jmsRouterProjectNames_;

    public EjbWsFromWSDLInputCommand(IWebService ws, String ejbProjectName, String earProjectName) {
        super(ws, ejbProjectName, earProjectName);
        this.ejbProject_ = ResourcesPlugin.getWorkspace().getRoot().getProject(ejbProjectName);
        this.earProject_ = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjectName);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.initHttpRouterProjectNames();
        this.initJmsRouterProjectNames();
        return super.execute(monitor, info);
    }

    private void initHttpRouterProjectNames() {
        this.httpRouterProjectNames_ = this.getRouterProjectNames(EJBRouterComboUtil.getAppropriateHttpRouterComponents(this.earProject_, this.ejbProject_));
        if (this.httpRouterProjectNames_.size() == 0) {
            this.httpRouterProjectNames_.add(String.valueOf(this.ejbProject_.getName()) + "HttpRouter");
        }
    }

    public List<String> getHttpRouterProjectNames() {
        return this.httpRouterProjectNames_;
    }

    public String getDefaultHttpRouterProjectName() {
        return this.httpRouterProjectNames_.get(0);
    }

    public List<String> getJmsRouterProjectNames() {
        return this.jmsRouterProjectNames_;
    }

    public String getDefaultJmsRouterProjectName() {
        return this.jmsRouterProjectNames_.get(0);
    }

    private ArrayList<String> getRouterProjectNames(List<IVirtualComponent> routerComponents) {
        ArrayList<String> routerProjectNames = new ArrayList<String>();
        for (IVirtualComponent routerComponent : routerComponents) {
            routerProjectNames.add(routerComponent.getProject().getName());
        }
        return routerProjectNames;
    }

    public void initJmsRouterProjectNames() {
        this.jmsRouterProjectNames_ = this.getRouterProjectNames(EJBRouterComboUtil.getAppropriateJmsRouterComponents(this.earProject_, this.ejbProject_));
        if (this.jmsRouterProjectNames_.size() == 0) {
            this.jmsRouterProjectNames_.add(String.valueOf(this.ejbProject_.getName()) + "JmsRouter");
        }
    }
}

