/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.ejb.command;

import com.ibm.ast.ws.jaxws.creation.command.CopyWSDLToProjectCommand;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import java.util.List;
import javax.wsdl.Port;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class CopyEjbWSDLToProjectCommand
extends CopyWSDLToProjectCommand {
    private String jmsEndpointURL = null;
    private IProject httpRouterProject = null;
    private List<JAXWSWebServiceService> services;

    public CopyEjbWSDLToProjectCommand(WebServiceInfo info, boolean isBottomUp, String id) {
        super(info, isBottomUp);
        this.setID(id);
    }

    protected IVirtualFolder getDDFolderForProject() {
        return J2EEUtil.getEJBDeploymentDescriptorFolder((IProject)this.project);
    }

    protected IPath getWSDLPath(IPath wsdlPath, IVirtualFolder ivFolder) {
        wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
        wsdlPath = wsdlPath.append("wsdl").append(CopyEjbWSDLToProjectCommand.getWSDLName((String)this.wsdlURI));
        return wsdlPath;
    }

    protected String getWSDLInfRelativePath(IPath relativePath) {
        return new Path("META-INF").append("wsdl").append(relativePath).toString();
    }

    public IProject getHttpRouterProject() {
        return this.getWebFacingProject();
    }

    public void setHttpRouterProject(IProject httpRouterProject) {
        this.httpRouterProject = httpRouterProject;
    }

    protected IProject getWebFacingProject() {
        return this.httpRouterProject;
    }

    protected String getLocationURI(String serviceName, Port port, boolean multiports, String projectURL) {
        for (JAXWSWebServiceService webService : this.services) {
            if (!webService.getServiceName().getLocalPart().equals(serviceName)) continue;
            for (JAXWSWebServiceBinding binding : webService.getBindings()) {
                for (JAXWSWebServicePort webPort : binding.getPorts()) {
                    if (!webPort.getPortName().getLocalPart().equals(port.getName())) continue;
                    if (webPort.getPortType().equals("jms")) {
                        StringBuffer serviceURL = new StringBuffer(this.jmsEndpointURL);
                        serviceURL.append("&targetService=");
                        if (binding.isMultiportBinding()) {
                            serviceURL.append(port.getName());
                        } else {
                            serviceURL.append(this.getSEIName(binding));
                        }
                        return serviceURL.toString();
                    }
                    return super.getLocationURI(port.getName(), port, multiports, projectURL);
                }
            }
        }
        return super.getLocationURI(serviceName, port, multiports, projectURL);
    }

    private String getSEIName(JAXWSWebServiceBinding binding) {
        String fullSEI = binding.getSei();
        String sei = fullSEI.substring(fullSEI.lastIndexOf(46) + 1);
        return sei;
    }

    public void setJmsEndpointURL(String jmsEndpointURL) {
        this.jmsEndpointURL = jmsEndpointURL;
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
    }
}

