/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxb.ui.command;

import com.ibm.ast.ws.jaxb.ui.messages.Messages;
import com.ibm.ast.ws.jaxb.ui.plugin.Activator;
import com.ibm.ast.ws.jaxws.deployer.ProjectPathResolver;
import com.ibm.ast.ws.jaxws.emitter.common.MappingObject;
import com.ibm.ast.ws.jaxws.emitter.util.ServerUtils;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.ast.ws.jaxws.xsd.XSDModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CreateSchemaProjectsCommand
extends AbstractDataModelOperation {
    private HashMap<String, String> uriToProjectMap;
    private Hashtable<String, Hashtable<String, Boolean>> allDependencies;
    private HashMap<String, IPath> projectToOutputPathMap;
    private String earProjectName;
    private boolean createEAR = false;
    private final String ID_WAS_V7_SERVERFACTORY = "com.ibm.ws.ast.st.v7.server.base";
    private final String ID_WAS_V61_SERVERFACTORY = "com.ibm.ws.ast.st.v61.server.base";
    private String serverInstanceId;
    private MappingObject mapping;
    private boolean optimized = true;

    public CreateSchemaProjectsCommand() {
        this(new MappingObject());
    }

    public CreateSchemaProjectsCommand(MappingObject mapObj) {
        this.mapping = mapObj;
        XSDModel xsdModel = this.mapping.getXsdModel();
        if (xsdModel != null) {
            this.uriToProjectMap = xsdModel.getUriToProjectMap();
            this.allDependencies = xsdModel.getDependenciesGraph();
        }
    }

    private IRuntime getPrimaryRuntime(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) {
                return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getPrimaryRuntime());
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        XSDModel xsdModel;
        CreateFacetedProjectCommand createProjectCmd;
        XSDModel xsdModel2;
        if (!this.mapping.getGenXsd()) {
            return Status.OK_STATUS;
        }
        if (this.mapping != null && (xsdModel2 = this.mapping.getXsdModel()) != null) {
            if (this.uriToProjectMap == null) {
                this.uriToProjectMap = xsdModel2.getUriToProjectMap();
            } else {
                xsdModel2.setUriToProjectMap(this.uriToProjectMap);
            }
            this.allDependencies = xsdModel2.getDependenciesGraph();
        }
        this.projectToOutputPathMap = new HashMap();
        String serverFactoryId = this.mapping.getServerFactoryId();
        if (this.serverInstanceId == null) {
            if (serverFactoryId == null) {
                IServerType[] serverTypes;
                IProject earProject;
                IRuntime runtime = null;
                if (this.createEAR && this.earProjectName != null && (earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.earProjectName)).exists()) {
                    runtime = this.getPrimaryRuntime(earProject);
                }
                if (runtime == null) {
                    runtime = this.getPrimaryRuntime(this.mapping.getProject());
                }
                if (runtime == null && (runtime = ServerUtils.getWebSphereV7StubRuntime()) == null) {
                    runtime = ServerUtils.getWebSphereV61StubRuntime();
                }
                String runtimeTypeId = runtime.getRuntimeType().getId();
                IServerType[] iServerTypeArray = serverTypes = ServerCore.getServerTypes();
                int n = serverTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IServerType serverType = iServerTypeArray[n2];
                    if (serverType.getRuntimeType().getId().equals(runtimeTypeId)) {
                        serverFactoryId = serverType.getId();
                        break;
                    }
                    ++n2;
                }
            }
        } else if (serverFactoryId == null) {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServers();
            int serverType = servers.length;
            int serverTypes = 0;
            while (serverTypes < serverType) {
                IServer server = iServerArray[serverTypes];
                if (server.getId().equals(this.serverInstanceId)) {
                    serverFactoryId = server.getServerType().getId();
                    break;
                }
                ++serverTypes;
            }
        }
        MultiStatus multiStatus = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.MSG_PROGRESS_CREATE_SCHEMA_PROJECTS, null);
        if (this.createEAR && this.earProjectName != null) {
            createProjectCmd = new CreateFacetedProjectCommand();
            createProjectCmd.setEnvironment(super.getEnvironment());
            createProjectCmd.setTemplateId("template.jst.ear");
            createProjectCmd.setServerFactoryId(serverFactoryId);
            createProjectCmd.setServerInstanceId(this.serverInstanceId);
            createProjectCmd.setProjectName(this.earProjectName);
            createProjectCmd.setRequiredFacetVersions(this.getRequiredEARFacetVersion(serverFactoryId));
            IStatus status = createProjectCmd.execute(monitor, info);
            multiStatus.add(status);
        }
        createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(super.getEnvironment());
        createProjectCmd.setTemplateId("template.jst.utility");
        createProjectCmd.setServerFactoryId(serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredFacetVersion(serverFactoryId));
        AssociateModuleWithEARCommand cmd = null;
        if (this.earProjectName != null) {
            cmd = new AssociateModuleWithEARCommand();
            cmd.setEARProject(this.earProjectName);
            cmd.setEnvironment(super.getEnvironment());
        }
        if (monitor != null) {
            monitor.beginTask(Messages.MSG_PROGRESS_CREATE_SCHEMA_PROJECTS, this.uriToProjectMap.size());
        }
        for (String xsdUri : this.uriToProjectMap.keySet()) {
            String projectName = this.uriToProjectMap.get(xsdUri);
            createProjectCmd.setProjectName(projectName);
            IStatus status = createProjectCmd.execute(monitor, info);
            multiStatus.add(status);
            IPath outputPath = this.getOutputPath(projectName);
            this.projectToOutputPathMap.put(projectName, outputPath);
            if (cmd != null) {
                cmd.setProject(projectName);
                status = cmd.execute(monitor, info);
                multiStatus.add(status);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (!this.optimized) {
            this.initializeProjects(this.allDependencies, monitor);
            this.setupServiceProjectClassPath(monitor);
        } else {
            SetClasspathOperation op = new SetClasspathOperation(this.allDependencies);
            try {
                op.run(monitor);
            }
            catch (Exception e) {
                IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
                multiStatus.add(errStatus);
                return multiStatus;
            }
        }
        if (this.mapping != null && (xsdModel = this.mapping.getXsdModel()) != null) {
            xsdModel.setProjectToOutputPathMap(this.projectToOutputPathMap);
        }
        return multiStatus;
    }

    private RequiredFacetVersion[] getRequiredEARFacetVersion(String serverFactoryId) {
        String wasFacetVersion = null;
        if ("com.ibm.ws.ast.st.v61.server.base".equals(serverFactoryId)) {
            wasFacetVersion = "6.1";
        } else if ("com.ibm.ws.ast.st.v7.server.base".equals(serverFactoryId)) {
            wasFacetVersion = "7.0";
        }
        if (wasFacetVersion == null) {
            return new RequiredFacetVersion[0];
        }
        IProjectFacet projectFacetCoExist = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.coexistence.ear");
        IProjectFacetVersion projFacetCoExistVersion = projectFacetCoExist.getVersion(wasFacetVersion);
        IProjectFacet projectFacetExt = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.extended.ear");
        IProjectFacetVersion projFacetExtVersion = projectFacetExt.getVersion(wasFacetVersion);
        RequiredFacetVersion reqFacetCoExtVersion = new RequiredFacetVersion();
        reqFacetCoExtVersion.setAllowNewer(false);
        reqFacetCoExtVersion.setProjectFacetVersion(projFacetCoExistVersion);
        RequiredFacetVersion reqFacetExtVersion = new RequiredFacetVersion();
        reqFacetExtVersion.setAllowNewer(false);
        reqFacetExtVersion.setProjectFacetVersion(projFacetExtVersion);
        return new RequiredFacetVersion[]{reqFacetCoExtVersion, reqFacetExtVersion};
    }

    private RequiredFacetVersion[] getRequiredFacetVersion(String serverFactoryId) {
        if ("com.ibm.ws.ast.st.v61.server.base".equals(serverFactoryId)) {
            IProjectFacet projectFacetJava = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.wsfp.utility");
            IProjectFacetVersion projJavaFacetVersion = projectFacetJava.getVersion("1.0");
            RequiredFacetVersion reqFacetVersion = new RequiredFacetVersion();
            reqFacetVersion.setAllowNewer(false);
            reqFacetVersion.setProjectFacetVersion(projJavaFacetVersion);
            return new RequiredFacetVersion[]{reqFacetVersion};
        }
        return new RequiredFacetVersion[0];
    }

    private void initializeProjects(Hashtable<String, Hashtable<String, Boolean>> dependenciesGraph, IProgressMonitor monitor) {
        if (!this.optimized) {
            for (String id : dependenciesGraph.keySet()) {
                Hashtable<String, Boolean> allDependencies = dependenciesGraph.get(id);
                for (String depId : allDependencies.keySet()) {
                    String projectName1 = this.uriToProjectMap.get(id);
                    String projectName2 = this.uriToProjectMap.get(depId);
                    if (projectName1 == null || projectName2 == null) continue;
                    this.setProjectDependency(projectName1, projectName2, monitor);
                }
            }
        } else {
            HashSet<String> projectSetup = new HashSet<String>();
            for (String id : dependenciesGraph.keySet()) {
                Hashtable<String, Boolean> allDependencies = dependenciesGraph.get(id);
                ArrayList<String> depProjectList = new ArrayList<String>();
                String projectName1 = this.uriToProjectMap.get(id);
                if (projectSetup.contains(projectName1)) continue;
                for (String depId : allDependencies.keySet()) {
                    String projectName2 = this.uriToProjectMap.get(depId);
                    if (projectName1 == null || projectName2 == null) continue;
                    depProjectList.add(projectName2);
                }
                this.setProjectsDependency(projectName1, depProjectList, monitor);
                projectSetup.add(projectName1);
            }
        }
    }

    private void setupServiceProjectClassPath(IProgressMonitor monitor) {
        if (this.mapping.getProject() == null) {
            return;
        }
        for (String projectName : this.uriToProjectMap.values()) {
            this.addJ2EEProjectDependency(projectName, monitor);
        }
    }

    private void addJ2EEProjectDependency(String dependentProjectName, IProgressMonitor monitor) {
        try {
            IProject targetProject = this.mapping.getProject();
            if (!J2EEProjectUtilities.isJEEProject((IProject)targetProject)) {
                return;
            }
            if (!J2EEProjectUtilities.getManifestFile((IProject)targetProject).exists()) {
                return;
            }
            ArchiveManifest manifest = J2EEProjectUtilities.readManifest((IProject)targetProject);
            manifest.mergeClassPath(new String[]{String.valueOf(dependentProjectName) + ".jar"});
            J2EEProjectUtilities.writeManifest((IProject)targetProject, (ArchiveManifest)manifest);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in CreateSchemaProjectsCommand.setJ2EEProjectDependency(): " + e.getMessage()), (Throwable)e));
        }
    }

    private void setProjectsDependency(String projectName1, ArrayList<String> projectNames2, IProgressMonitor monitor) {
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName1);
        IJavaProject javaProject1 = JavaCore.create((IProject)project1);
        try {
            IClasspathEntry[] classPathEntries = javaProject1.getRawClasspath();
            ArrayList<IClasspathEntry> desiredEntries = new ArrayList<IClasspathEntry>();
            HashSet<String> addedProject = new HashSet<String>();
            for (String projectName2 : projectNames2) {
                if (projectName1.equals(projectName2) || addedProject.contains(projectName2)) continue;
                IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName2);
                IPath desiredPath = project2.getFullPath();
                boolean entryAlreadyExist = false;
                int i = 0;
                while (i < classPathEntries.length) {
                    IPath path;
                    IClasspathEntry classpathEntry = classPathEntries[i];
                    if (classpathEntry.getEntryKind() == 2 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                        entryAlreadyExist = true;
                        break;
                    }
                    ++i;
                }
                if (!entryAlreadyExist) {
                    desiredEntries.add(JavaCore.newProjectEntry((IPath)desiredPath));
                }
                addedProject.add(projectName2);
            }
            int desiredSize = desiredEntries.size();
            if (desiredSize == 0) {
                return;
            }
            IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + desiredSize];
            int loopCnt = 0;
            for (IClasspathEntry desiredEntry : desiredEntries) {
                newClassPathEntries[loopCnt++] = desiredEntry;
            }
            int i = 0;
            while (i < classPathEntries.length) {
                newClassPathEntries[i + desiredSize] = classPathEntries[i];
                ++i;
            }
            javaProject1.setRawClasspath(newClassPathEntries, monitor);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in CreateSchemaProjectsCommand.setProjectsDependency(): " + e.getMessage()), (Throwable)e));
        }
    }

    private void setProjectDependency(String projectName1, String projectName2, IProgressMonitor monitor) {
        if (projectName1.equals(projectName2)) {
            return;
        }
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName1);
        IJavaProject javaProject1 = JavaCore.create((IProject)project1);
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName2);
        try {
            IClasspathEntry[] classPathEntries = javaProject1.getRawClasspath();
            IPath desiredPath = project2.getFullPath();
            int i = 0;
            while (i < classPathEntries.length) {
                IPath path;
                IClasspathEntry classpathEntry = classPathEntries[i];
                if (classpathEntry.getEntryKind() == 2 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                    return;
                }
                ++i;
            }
            IClasspathEntry thinClientClassPathEntry = JavaCore.newProjectEntry((IPath)desiredPath);
            IClasspathEntry[] newClassPathEntries = new IClasspathEntry[classPathEntries.length + 1];
            newClassPathEntries[0] = thinClientClassPathEntry;
            int i2 = 0;
            while (i2 < classPathEntries.length) {
                newClassPathEntries[i2 + 1] = classPathEntries[i2];
                ++i2;
            }
            javaProject1.setRawClasspath(newClassPathEntries, monitor);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(StatusUtils.errorStatus((String)("Exception in CreateSchemaProjectsCommand.setProjectDependency(): " + e.getMessage()), (Throwable)e));
        }
    }

    private IPath getOutputPath(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ProjectPathResolver pathResolver = new ProjectPathResolver(javaProject);
        pathResolver.initValidTargetPaths();
        String targetPath = pathResolver.getTargetPath();
        return ResourcesPlugin.getWorkspace().getRoot().findMember(targetPath).getFullPath();
    }

    public void setUriToProjectMap(HashMap<String, String> uriToProjectMap) {
        this.uriToProjectMap = uriToProjectMap;
    }

    public HashMap<String, IPath> getProjectToOutputPathMap() {
        return this.projectToOutputPathMap;
    }

    public void setAllDependencies(Hashtable<String, Hashtable<String, Boolean>> allDependencies) {
        this.allDependencies = allDependencies;
    }

    public void setProject(IProject project) {
        this.mapping.setProject(project);
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.mapping.setServerFactoryId(serverFactoryId);
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setGenXSDProjects(boolean genXSDProjects) {
        this.mapping.setGenXsd(genXSDProjects);
    }

    public void setCreateEAR(boolean createEAR) {
        this.createEAR = createEAR;
    }

    class SetClasspathOperation
    extends WorkspaceModifyOperation {
        private IStatus status;
        Hashtable<String, Hashtable<String, Boolean>> dependenciesGraph;

        SetClasspathOperation(Hashtable<String, Hashtable<String, Boolean>> dependenciesGraph) {
            this.dependenciesGraph = dependenciesGraph;
        }

        protected void execute(IProgressMonitor monitor) {
            CreateSchemaProjectsCommand.this.initializeProjects(this.dependenciesGraph, monitor);
            CreateSchemaProjectsCommand.this.setupServiceProjectClassPath(monitor);
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

