/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.widgets.skeleton;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SkeletonConfigWidget
extends SimpleWidgetDataContributor {
    private JavaWSDLParameterBase javaWSDLParam;
    private static final String INFOPOP_PBCF_PAGE = "PBSC0001";
    private Combo skeletonFolderCombo_;
    private static final String INFOPOP_PBSC_TEXT_SKELETON_FOLDER = "PBSC0004";
    private Combo deployScopeCombo_;
    private String INFOPOP_PBSC_COMBO_DEPLOYSCOPE = "com.ibm.etools.webservice.was.creation.ui.PBSC0007";
    private Combo securityTypeCombo_;
    private String INFOPOP_PBCF_COMBO_SECURITYTYPE = "com.ibm.etools.webservice.was.creation.ui.PBSC0006";
    private Button showMappingsCheckbox_;
    private String INFOPOP_N2P_SHOW_MAPPINGS = "PBSC0016";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "com.ibm.etools.webservice.was.creation.ui";
        UIUtils uiUtils = new UIUtils(pluginId);
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(pluginId) + "." + INFOPOP_PBCF_PAGE));
        parent.setToolTipText(Messages.TOOLTIP_PBCF_PAGE);
        Composite textGroup = uiUtils.createComposite(parent, 2, 0, 0);
        this.skeletonFolderCombo_ = uiUtils.createCombo(textGroup, Messages.LABEL_SKELETON_ROOT_NAME, Messages.TOOLTIP_PBCF_TEXT_SKELETON_FOLDER, INFOPOP_PBSC_TEXT_SKELETON_FOLDER, 2060);
        this.deployScopeCombo_ = uiUtils.createCombo(textGroup, Messages.LABEL_DEPLOYSCOPE, Messages.TOOLTIP_PBCL_COMBO_DEPLOYSCOPE, this.INFOPOP_PBSC_COMBO_DEPLOYSCOPE, 2060);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_DEFAULT);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_APPLICATION);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_REQUEST);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_SESSION);
        this.deployScopeCombo_.select(0);
        this.securityTypeCombo_ = uiUtils.createCombo(textGroup, Messages.LABEL_SECURITY_CONFIG, Messages.TOOLTIP_PBCF_COMBO_SECURITYTYPE, this.INFOPOP_PBCF_COMBO_SECURITYTYPE, 2060);
        this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_NONE, 0);
        this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_DSIG, 1);
        this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_ENC, 2);
        this.securityTypeCombo_.select(0);
        new Label(parent, 256);
        this.showMappingsCheckbox_ = uiUtils.createCheckbox(parent, Messages.LABEL_EXPLORE_MAPPINGS_XML2BEAN, Messages.TOOLTIP_N2P_SHOW_MAPPINGS, this.INFOPOP_N2P_SHOW_MAPPINGS);
        return this;
    }

    public void setOutputJavaFolder(String outputJavaFolder) {
        if (outputJavaFolder != null) {
            int index = this.skeletonFolderCombo_.indexOf(outputJavaFolder);
            if (index != -1) {
                this.skeletonFolderCombo_.select(index);
            } else if (this.skeletonFolderCombo_.getItemCount() <= 0) {
                String root = this.getWorkspaceRootLocation();
                if (outputJavaFolder.startsWith(root)) {
                    this.skeletonFolderCombo_.add(outputJavaFolder.substring(root.length()));
                } else {
                    this.skeletonFolderCombo_.add(outputJavaFolder);
                }
                this.skeletonFolderCombo_.select(0);
            }
        }
    }

    public void setShowMapping(boolean showMapping) {
        this.showMappingsCheckbox_.setSelection(showMapping);
    }

    public boolean getShowMapping() {
        if (this.showMappingsCheckbox_ == null) {
            return false;
        }
        return this.showMappingsCheckbox_.getSelection();
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        String developServerJavaOutput = PlatformUtils.getPlatformFromPath(this.skeletonFolderCombo_.getText());
        this.javaWSDLParam.setDevelopServerJavaOutput(developServerJavaOutput);
        IProject serviceProject = this.javaWSDLParam.getProject();
        if (!J2EEUtils.hasWasXDocletSupport((IProject)serviceProject)) {
            this.javaWSDLParam.setJavaOutput(developServerJavaOutput);
        }
        this.javaWSDLParam.setSecurityConfig((byte)this.securityTypeCombo_.getSelectionIndex());
        switch (this.deployScopeCombo_.getSelectionIndex()) {
            case 0: {
                this.javaWSDLParam.setDeployScope(null);
                break;
            }
            case 1: {
                this.javaWSDLParam.setDeployScope("Application");
                break;
            }
            case 2: {
                this.javaWSDLParam.setDeployScope("Request");
                break;
            }
            case 3: {
                this.javaWSDLParam.setDeployScope("Session");
            }
        }
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        if (javaWSDLParam.getJ2eeLevel().equals("1.4") && this.securityTypeCombo_.indexOf(Messages.COMBO_WS_SECURITY_DSIG_ENC) == -1) {
            this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_DSIG_ENC, 3);
        }
        if (javaWSDLParam.getDeployScope() == null) {
            this.deployScopeCombo_.select(0);
        } else if (javaWSDLParam.getDeployScope().equals("Application")) {
            this.deployScopeCombo_.select(1);
        } else if (javaWSDLParam.getDeployScope().equals("Request")) {
            this.deployScopeCombo_.select(2);
        } else if (javaWSDLParam.getDeployScope().equals("Session")) {
            this.deployScopeCombo_.select(3);
        }
    }

    public byte getWsSecurityConfig() {
        return (byte)this.securityTypeCombo_.getSelectionIndex();
    }

    private String getWorkspaceRootLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().toString();
    }

    public void setServerProject(IProject serviceProject) {
        try {
            if (!J2EEUtils.hasWasXDocletSupport((IProject)serviceProject)) {
                String originalSkeletonFolder = this.skeletonFolderCombo_.getText();
                this.skeletonFolderCombo_.removeAll();
                IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IProject)serviceProject);
                int i = 0;
                while (i < paths.length) {
                    this.skeletonFolderCombo_.add(paths[i].toString());
                    ++i;
                }
                int index = this.skeletonFolderCombo_.indexOf(originalSkeletonFolder);
                if (index != -1) {
                    this.skeletonFolderCombo_.select(index);
                } else {
                    this.skeletonFolderCombo_.select(0);
                }
            } else {
                this.skeletonFolderCombo_.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }
}

