/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.widgets.bean;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.JavaMOFUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.JavaResourceFilter;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class BeanClassWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "com.ibm.etools.webservice.was.creation.ui";
    private final String INFOPOP_PBCL_PAGE = String.valueOf(this.pluginId_) + ".PBCL0001";
    private Text beanClassText_;
    private final String INFOPOP_PBCL_TEXT_BEAN_CLASS = String.valueOf(this.pluginId_) + ".PBCL0002";
    private Combo deployScopeCombo_;
    private String INFOPOP_PBCL_COMBO_DEPLOYSCOPE = String.valueOf(this.pluginId_) + ".PBCL0006";
    private Combo httpSoapActionCombo_;
    private String INFOPOP_PBCL_COMBO_SOAPACTION_HTTP = String.valueOf(this.pluginId_) + ".PBCL0007";
    private Button httpWsdl11MimeStyleCheckbox_;
    private String INFOPOP_PBCL_MIMESTYLE_HTTP = String.valueOf(this.pluginId_) + ".PBCL0008";
    private Composite parent_ = null;
    private IProject serverProject_ = null;
    private IWizardContainer context_ = null;
    private JavaResourceFilter filter_ = new JavaResourceFilter();
    private IResource initialResource_ = null;
    private boolean generateSEIFile = true;
    private Button useExistingSEIButton_;
    private final String INFOPOP_PSEI_BUTTON_SEI = String.valueOf(this.pluginId_) + ".PBCL0005";
    private Listener statusListener_;
    private Text seiFileLocationText_;
    private Button seiInterfaceBrowseButton_;
    private final String INFOPOP_PBCL_BUTTON_SEI_CLASS_BROWSE = String.valueOf(this.pluginId_) + ".PBCL0006";
    private Button seiResourceBrowseButton_;
    private final String INFOPOP_PBCL_BUTTON_SEI_RESOURCE_BROWSE = String.valueOf(this.pluginId_) + ".PBCL0007";
    private JavaWSDLParameterBase javaWSDLParam;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        Composite group = uiUtils.createComposite(parent, 2);
        this.beanClassText_ = uiUtils.createText(group, Messages.LABEL_BEAN_CLASS_NAME, Messages.TOOLTIP_PBCL_TEXT_BEAN_CLASS, this.INFOPOP_PBCL_TEXT_BEAN_CLASS, 8);
        new Label(parent, 256);
        this.useExistingSEIButton_ = uiUtils.createButton(32, parent, Messages.LABEL_USE_EXISTING_SEI, Messages.TOOLTIP_PSEI_BUTTON_SEI, this.INFOPOP_PSEI_BUTTON_SEI);
        this.useExistingSEIButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanClassWidget.this.handleUseExistingSEIButtonEvent();
            }
        });
        this.useExistingSEIButton_.setToolTipText(Messages.TOOLTIP_PSEI_BUTTON_SEI);
        Group seiGroup = uiUtils.createGroup(parent, Messages.LABEL_SEI, null, null);
        this.seiFileLocationText_ = uiUtils.createText((Composite)seiGroup, null, Messages.TOOLTIP_PBCL_TEXT_BEAN_CLASS, this.INFOPOP_PBCL_TEXT_BEAN_CLASS, 2052);
        this.seiFileLocationText_.addModifyListener((ModifyListener)new SEIModifyListener());
        group = this.createComposite((Composite)seiGroup, 2, -1, -1);
        this.seiInterfaceBrowseButton_ = uiUtils.createPushButton(group, Messages.BUTTON_BROWSE_INTERFACES, Messages.TOOLTIP_PBCL_BUTTON_BEAN_CLASS_BROWSE, this.INFOPOP_PBCL_BUTTON_SEI_CLASS_BROWSE);
        this.seiInterfaceBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanClassWidget.this.handleSEIClassBrowseButtonEvent();
            }
        });
        this.seiResourceBrowseButton_ = uiUtils.createPushButton(group, Messages.BUTTON_BROWSE_FILES, Messages.TOOLTIP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE, this.INFOPOP_PBCL_BUTTON_SEI_RESOURCE_BROWSE);
        this.seiResourceBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                BeanClassWidget.this.handleSEIResourceBrowseButtonEvent();
            }
        });
        new Label(parent, 256);
        group = uiUtils.createComposite(parent, 2);
        this.deployScopeCombo_ = uiUtils.createCombo(group, Messages.LABEL_DEPLOYSCOPE, Messages.TOOLTIP_PBCL_COMBO_DEPLOYSCOPE, this.INFOPOP_PBCL_COMBO_DEPLOYSCOPE, 2060);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_DEFAULT);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_APPLICATION);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_REQUEST);
        this.deployScopeCombo_.add(Messages.COMBO_WS_DEPLOYSCOPE_SESSION);
        this.deployScopeCombo_.select(0);
        this.httpSoapActionCombo_ = uiUtils.createCombo(group, Messages.LABEL_SOAPACTION, Messages.TOOLTIP_PBCL_SOAPACTION, this.INFOPOP_PBCL_COMBO_SOAPACTION_HTTP, 2060);
        this.httpSoapActionCombo_.add(Messages.COMBO_SOAPACTION_DEFAULT);
        this.httpSoapActionCombo_.add(Messages.COMBO_SOAPACTION_NONE);
        this.httpSoapActionCombo_.add(Messages.COMBO_SOAPACTION_OPERATION);
        this.httpSoapActionCombo_.select(0);
        group = uiUtils.createComposite(parent, 2);
        this.httpWsdl11MimeStyleCheckbox_ = uiUtils.createCheckbox(group, Messages.LABEL_WSDL11_MIME_STYLE, Messages.TOOLTIP_WSDL11_MIME_STYLE, this.INFOPOP_PBCL_MIMESTYLE_HTTP);
        this.httpWsdl11MimeStyleCheckbox_.setSelection(true);
        this.enableInputs();
        return this;
    }

    private void handleUseExistingSEIButtonEvent() {
        boolean bl = this.generateSEIFile = !this.useExistingSEIButton_.getSelection();
        if (!this.generateSEIFile) {
            this.seiFileLocationText_.setText("");
        } else {
            this.seiFileLocationText_.setText(String.valueOf(this.getBeanClassName()) + "_SEI");
        }
        this.seiFileLocationText_.setEnabled(!this.generateSEIFile);
        this.seiResourceBrowseButton_.setEnabled(!this.generateSEIFile);
        this.seiInterfaceBrowseButton_.setEnabled(!this.generateSEIFile);
    }

    private void handleSEIClassBrowseButtonEvent() {
        String seiName = DialogUtils.browseInterfaces((Shell)this.parent_.getShell(), (IProject)this.serverProject_, (IWizardContainer)this.context_);
        if (seiName != null) {
            this.seiFileLocationText_.setText(seiName);
        }
    }

    private void handleSEIResourceBrowseButtonEvent() {
        IPath path;
        String basename;
        IResource resource;
        IProject topResource = this.serverProject_;
        if (topResource == null) {
            topResource = ResourceUtils.getWorkspaceRoot();
        }
        if ((resource = DialogUtils.browseResources((Shell)this.parent_.getShell(), (IResource)topResource, null, (Filter)this.filter_)) != null && (basename = (path = resource.getFullPath()).lastSegment()) != null && basename.length() > 0) {
            String beanClass;
            String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)path);
            String string = beanClass = beanPackage == null ? basename : String.valueOf(beanPackage) + "." + basename;
            if (beanClass.toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class")) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
            this.seiFileLocationText_.setText(beanClass);
        }
    }

    private void enableInputs() {
        this.useExistingSEIButton_.setSelection(!this.generateSEIFile);
        this.handleUseExistingSEIButtonEvent();
    }

    public void setCurrentPage(IWizardPage page) {
        this.context_ = page.getWizard().getContainer();
    }

    public void setBeanClassName(String beanClassName) {
        this.seiFileLocationText_.setText(String.valueOf(beanClassName) + "_SEI");
        this.beanClassText_.setText(beanClassName);
    }

    public String getBeanClassName() {
        return this.beanClassText_.getText().trim();
    }

    public void setServiceProject(IProject serviceProject) {
        this.serverProject_ = serviceProject;
    }

    public void setInitialResource(IResource resource) {
        this.initialResource_ = resource;
    }

    public void setSEIClassName(String seiClassName) {
        this.seiFileLocationText_.setText(seiClassName);
    }

    public String getSEIClassName() {
        return this.seiFileLocationText_.getText().trim();
    }

    public boolean getGenerateSEIFile() {
        return !this.useExistingSEIButton_.getSelection();
    }

    public void setGenerateSEIFile(boolean genSEIFile) {
        this.generateSEIFile = genSEIFile;
    }

    private Composite createComposite(Composite parent, int columns, int marginHeight, int marginWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = columns;
        if (marginHeight >= 0) {
            gridlayout.marginHeight = marginHeight;
        }
        if (marginWidth >= 0) {
            gridlayout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)gridlayout);
        GridData griddata = new GridData(640);
        composite.setLayoutData((Object)griddata);
        return composite;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        this.javaWSDLParam.setGenerateSEIFile(this.generateSEIFile);
        if (!this.generateSEIFile) {
            this.javaWSDLParam.setSEIName(this.getSEIClassName());
        }
        switch (this.deployScopeCombo_.getSelectionIndex()) {
            case 0: {
                this.javaWSDLParam.setDeployScope(null);
                break;
            }
            case 1: {
                this.javaWSDLParam.setDeployScope("Application");
                break;
            }
            case 2: {
                this.javaWSDLParam.setDeployScope("Request");
                break;
            }
            case 3: {
                this.javaWSDLParam.setDeployScope("Session");
            }
        }
        this.javaWSDLParam.setBindingTypes("http");
        switch (this.httpSoapActionCombo_.getSelectionIndex()) {
            case 0: {
                this.javaWSDLParam.setSoapAction("DEFAULT");
                break;
            }
            case 1: {
                this.javaWSDLParam.setSoapAction("NONE");
                break;
            }
            case 2: {
                this.javaWSDLParam.setSoapAction("OPERATION");
            }
        }
        if (this.httpWsdl11MimeStyleCheckbox_.getSelection()) {
            this.javaWSDLParam.setMimeStyle("WSDL11");
        } else {
            this.javaWSDLParam.setMimeStyle("swaRef");
        }
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        if (javaWSDLParam.getSoapAction() != null) {
            if (javaWSDLParam.getSoapAction().equals("DEFAULT")) {
                this.httpSoapActionCombo_.select(0);
            } else if (javaWSDLParam.getSoapAction().equals("NONE")) {
                this.httpSoapActionCombo_.select(1);
            } else if (javaWSDLParam.getSoapAction().equals("OPERATION")) {
                this.httpSoapActionCombo_.select(2);
            }
        }
        if (javaWSDLParam.getMimeStyle() != null) {
            if (javaWSDLParam.getMimeStyle().equals("WSDL11")) {
                this.httpWsdl11MimeStyleCheckbox_.setSelection(true);
            } else if (javaWSDLParam.getMimeStyle().equals("swaRef")) {
                this.httpWsdl11MimeStyleCheckbox_.setSelection(false);
            }
        }
        if (javaWSDLParam.getDeployScope() == null) {
            this.deployScopeCombo_.select(0);
        } else if (javaWSDLParam.getDeployScope().equals("Application")) {
            this.deployScopeCombo_.select(1);
        } else if (javaWSDLParam.getDeployScope().equals("Request")) {
            this.deployScopeCombo_.select(2);
        } else if (javaWSDLParam.getDeployScope().equals("Session")) {
            this.deployScopeCombo_.select(3);
        }
    }

    public IStatus getStatus() {
        IStatus finalStatus = Status.OK_STATUS;
        if (this.useExistingSEIButton_.getSelection()) {
            finalStatus = this.verifySEI();
        }
        return finalStatus;
    }

    private IStatus verifySEI() {
        IStatus finalStatus = Status.OK_STATUS;
        if (this.getSEIClassName() == null || this.getSEIClassName().equals("")) {
            return StatusUtils.errorStatus((String)Messages.PAGE_MSG_CLASS_SEI_BLANK);
        }
        if (this.serverProject_ != null) {
            try {
                JavaEMFNature jMOF = JavaEMFNature.createRuntime((IProject)this.serverProject_);
                JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(this.getSEIClassName(), jMOF.getResourceSet());
                if (!javaClass.isExistingType()) {
                    finalStatus = StatusUtils.errorStatus((String)Messages.PAGE_MSG_CLASS_NOT_AN_SEI);
                    return finalStatus;
                }
                if (!JavaMOFUtils.isInterface((JavaClass)javaClass)) {
                    finalStatus = StatusUtils.errorStatus((String)Messages.PAGE_MSG_CLASS_NOT_AN_SEI);
                    return finalStatus;
                }
                if (!JavaMOFUtils.extendsClass((String)this.getSEIClassName(), (String)"java.rmi.Remote", (IProject)this.serverProject_)) {
                    finalStatus = StatusUtils.errorStatus((String)Messages.PAGE_MSG_CLASS_NOT_AN_SEI);
                    return finalStatus;
                }
            }
            catch (CoreException coreException) {
                finalStatus = StatusUtils.errorStatus((String)Messages.PAGE_MSG_CLASS_NOT_AN_SEI);
                return finalStatus;
            }
        }
        return finalStatus;
    }

    private class SEIModifyListener
    implements ModifyListener {
        private SEIModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            BeanClassWidget.this.statusListener_.handleEvent(null);
        }
    }
}

