/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.task;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.PlatformUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.was.utils.WSDLCopierUtil;
import java.io.File;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentMergeContext;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;

public class DefaultsForWSDL2SkeletonTask
extends AbstractDataModelOperation {
    public final String SERVICE_EXT = "services/";
    private final String WSDL_EXT = "wsdl";
    private final String WSDL_FOLDER = "wsdl";
    private IProject serviceProject;
    private String wSDLServicePathname;
    private String wSDLServiceURL;
    private WebServicesParser wSParser;
    private String serverInstanceId;
    private JavaWSDLParameterBase javaWSDLParam = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.serviceProject);
        IPath sourcePath = J2EEUtils.getJavaSourceLocation((IVirtualComponent)component);
        String developJavaOutput = PlatformUtils.getPlatformURL((IPath)sourcePath);
        this.javaWSDLParam.setDevelopServerJavaOutput(developJavaOutput);
        String output = J2EEUtils.hasWasXDocletSupport((IProject)this.serviceProject) ? PlatformUtils.getPlatformURL((IPath)this.serviceProject.getFolder("gen/src").getFullPath()) : PlatformUtils.getPlatformURL((IPath)sourcePath);
        this.javaWSDLParam.setJavaOutput(output);
        this.javaWSDLParam.setProject(this.serviceProject);
        IPath modulePath = this.serviceProject.getFullPath();
        if (J2EEUtils.isWebProject((IProject)this.serviceProject)) {
            IVirtualFolder ivFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            modulePath = modulePath.append(ivFolder.getProjectRelativePath());
        }
        output = PlatformUtils.getPlatformURL((IPath)modulePath);
        this.javaWSDLParam.setOutput(output);
        this.javaWSDLParam.setTempOutput(J2EEUtils.getFileURL((File)J2EEUtils.createTempDir()));
        PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
        if (mergeContext.isSkeletonMergeEnabled()) {
            StringBuffer tmpJavaOutput = new StringBuffer(this.javaWSDLParam.getTempOutput());
            tmpJavaOutput.append("src");
            tmpJavaOutput.append(File.separator);
            this.javaWSDLParam.setTempJavaOutput(tmpJavaOutput.toString());
        }
        if (this.wSDLServicePathname != null) {
            this.wSDLServiceURL = PlatformUtils.isPlatformURL((String)this.wSDLServicePathname) ? PlatformUtils.getFileURLFromPlatform((String)this.wSDLServicePathname) : this.wSDLServicePathname;
        }
        if (this.wSDLServiceURL == null) {
            this.wSDLServiceURL = "";
        }
        this.javaWSDLParam.setInputWsdlLocation(this.wSDLServiceURL);
        this.javaWSDLParam.setStyle("RPC");
        this.javaWSDLParam.setUse("LITERAL");
        this.javaWSDLParam.setMetaInfOnly(false);
        this.javaWSDLParam.setServerSide((byte)1);
        IEnvironment env = super.getEnvironment();
        IStatus status = this.setWSDLLoaction(env, monitor, adaptable);
        this.javaWSDLParam.setNoDataBinding(WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoDataBindings());
        return status;
    }

    private IStatus setWSDLLoaction(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        PortType portType;
        IProject project = this.serviceProject;
        Definition definition = null;
        String wsdlURL = this.javaWSDLParam.getInputWsdlLocation();
        try {
            definition = this.wSParser.getWSDLDefinitionVerbose(wsdlURL);
        }
        catch (Throwable e) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_PARSE_WSDL, (Object[])new String[]{wsdlURL}), (Throwable)e);
        }
        String wsdlLocation = null;
        Service service = null;
        Port port = null;
        if (definition == null) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_NO_DEFINITION, (Object[])new String[]{wsdlURL}));
        }
        if (definition.getServices().size() > 0) {
            service = (Service)definition.getServices().values().iterator().next();
        }
        boolean needToCopyWsdl = false;
        if (service == null) {
            portType = (PortType)definition.getPortTypes().values().iterator().next();
            service = definition.createService();
            QName serviceQName = new QName(definition.getTargetNamespace(), String.valueOf(portType.getQName().getLocalPart()) + "Service");
            service.setQName(serviceQName);
            definition.addService(service);
            needToCopyWsdl = true;
        }
        if (service.getPorts().size() > 0) {
            port = (Port)service.getPorts().values().iterator().next();
        }
        if (port == null) {
            portType = (PortType)definition.getPortTypes().values().iterator().next();
            Binding binding = (Binding)definition.getBindings().values().iterator().next();
            port = definition.createPort();
            service.addPort(port);
            port.setBinding(binding);
            port.setName(portType.getQName().getLocalPart());
            needToCopyWsdl = true;
            SOAPAddress soapAddress = SOAPFactory.eINSTANCE.createSOAPAddress();
            soapAddress.setLocationURI("http://localhost:9080/");
            port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        }
        if (needToCopyWsdl) {
            IPath relativePath;
            String tmpOutputDir = "";
            String destWsdlURI = wsdlURL;
            try {
                File outputDir = PlatformUtils.createTempDir((IProject)project);
                StringBuffer sb = new StringBuffer(outputDir.toURL().toString());
                tmpOutputDir = sb.toString();
                sb.append(WSDLUtils.getWSDLName(wsdlURL));
                destWsdlURI = sb.toString();
            }
            catch (Exception exception) {}
            WSDLCopier wsdlCopier = new WSDLCopier(this.wSParser);
            wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)wsdlURL), definition);
            wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)destWsdlURI)));
            wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)destWsdlURI));
            IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            if (status.getSeverity() == 0 && (relativePath = wsdlCopier.getRelativePath()).segmentCount() > 1) {
                StringBuffer sb = new StringBuffer(tmpOutputDir);
                sb.append(relativePath.toString());
                destWsdlURI = sb.toString();
            }
            this.javaWSDLParam.setInputWsdlLocation(destWsdlURI);
        }
        IPath wsdlPath = project.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.serviceProject);
        try {
            if (J2EEUtils.isWebProject((IProject)this.serviceProject)) {
                IVirtualFolder ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
                wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
            }
            wsdlPath = wsdlPath.append("wsdl").append(port.getName()).addFileExtension("wsdl");
            wsdlLocation = PlatformUtils.getPlatformURL((IPath)wsdlPath);
            this.javaWSDLParam.setOutputWsdlLocation(wsdlLocation);
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_WRITE_WSDL, (Object[])new String[]{wsdlLocation}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setWebServiceURI(String servicePathname) {
        this.wSDLServicePathname = servicePathname;
    }

    public void setWSDLServiceURL(String serviceURL) {
        this.wSDLServiceURL = serviceURL;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

