/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.etools.webservice.was.consumption.ui.plugin.WebServiceWasConsumptionUIPlugin;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class TDWASInputCommand
extends AbstractDataModelOperation {
    private IWebService ws_;
    private String serverProject_;
    private String earProject_;
    private String serverServer_;
    private String serviceServerTypeID_;
    private String wsdlURI_;
    private String serviceJ2EEVersion_;
    private String wasFacet_;

    public TDWASInputCommand() {
    }

    public TDWASInputCommand(IWebService ws, String project) {
        this.ws_ = ws;
        this.serverProject_ = project;
    }

    public TDWASInputCommand(IWebService ws, String project, String earProject) {
        this(ws, project);
        this.earProject_ = earProject;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.serviceJ2EEVersion_ = J2EEUtils.getJ2EEVersion((String)this.serverProject_);
        this.serverServer_ = this.ws_.getWebServiceInfo().getServerInstanceId();
        String serverFactoryId = this.ws_.getWebServiceInfo().getServerFactoryId();
        this.wsdlURI_ = this.ws_.getWebServiceInfo().getWsdlURL();
        IServer serviceExistingServer = null;
        if (this.serverServer_ != null) {
            serviceExistingServer = ServerCore.findServer((String)this.serverServer_);
            if (serviceExistingServer != null) {
                this.serviceServerTypeID_ = serviceExistingServer.getServerType().getId();
            }
        } else {
            this.serviceServerTypeID_ = serverFactoryId;
        }
        this.setupWasFacetVersion();
        return Status.OK_STATUS;
    }

    private void setupWasFacetVersion() {
        block3: {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serverProject_);
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                Set projFacets = fProject.getProjectFacets();
                for (IProjectFacetVersion facetVersion : projFacets) {
                    if (!facetVersion.getProjectFacet().getId().equals("com.ibm.websphere.extended.ejb")) continue;
                    this.wasFacet_ = facetVersion.getVersionString();
                }
            }
            catch (Exception e) {
                if (!WebServiceWasConsumptionUIPlugin.isTraceMode()) break block3;
                WebServiceWasConsumptionUIPlugin.getInstance().getLog().log(StatusUtils.errorStatus((Throwable)e));
            }
        }
    }

    public String getServerProject() {
        return this.serverProject_;
    }

    public String getServerServer() {
        return this.serverServer_;
    }

    public String getWsdlURI() {
        return this.wsdlURI_;
    }

    public String getServiceServerTypeID() {
        return this.serviceServerTypeID_;
    }

    public String getServerProjectEAR() {
        return this.earProject_;
    }

    public String getServiceJ2EEVersion() {
        return this.serviceJ2EEVersion_;
    }

    public String getWasFacetVersion() {
        return this.wasFacet_;
    }
}

