/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.WSDLCopierUtil;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class ModifyWSDLEndpointAddressCommand
extends AbstractDataModelOperation {
    private String serverInstanceId;
    private IProject webProject;
    private String wsdlURI;
    private WebServicesParser wSParser;
    private JavaWSDLParameterBase javaWSDLParam = null;
    private String guessWebProjectURL;
    private String originalWSDLDestination;
    private WebServiceInfo serviceInfo = null;

    public ModifyWSDLEndpointAddressCommand(WebServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        try {
            if (this.guessWebProjectURL == null) {
                return Status.OK_STATUS;
            }
            IServer server = null;
            if (this.serviceInfo != null && this.serviceInfo.getServerInstanceId() != null) {
                server = ServerCore.findServer((String)this.serviceInfo.getServerInstanceId());
            } else if (this.serverInstanceId != null) {
                server = ServerCore.findServer((String)this.serverInstanceId);
            }
            String projectURL = server != null ? ServerUtils.getWebComponentURL((IProject)this.webProject, null, (IServer)server) : ServerUtils.getEncodedWebComponentURL((IProject)this.webProject, null);
            if (projectURL == null || projectURL.trim().length() == 0) {
                return Status.OK_STATUS;
            }
            if (!this.guessWebProjectURL.endsWith("/")) {
                this.guessWebProjectURL = String.valueOf(this.guessWebProjectURL) + "/";
            }
            if (!projectURL.endsWith("/")) {
                projectURL = String.valueOf(projectURL) + "/";
            }
            if (this.guessWebProjectURL.equals(projectURL)) {
                return Status.OK_STATUS;
            }
            Path filePath = new Path(PlatformUtils.getPathFromPlatform(this.wsdlURI));
            if (this.wsdlURI != null && this.wsdlURI.startsWith("platform:")) {
                this.wsdlURI = PlatformUtils.getFileURLFromPlatform(this.wsdlURI);
            }
            if (this.wsdlURI != null) {
                boolean modified = false;
                Definition definition = this.wSParser.getWSDLDefinition(this.wsdlURI);
                Map services = definition.getServices();
                for (Service ser : services.values()) {
                    Map ports = ser.getPorts();
                    for (Port p : ports.values()) {
                        for (Object obj : p.getExtensibilityElements()) {
                            SOAPAddress soapAddress;
                            String wsdlSoapAddress;
                            if (!(obj instanceof SOAPAddress) || (wsdlSoapAddress = (soapAddress = (SOAPAddress)obj).getLocationURI()) == null || !wsdlSoapAddress.startsWith(this.guessWebProjectURL)) continue;
                            StringBuffer stringBuf = new StringBuffer(projectURL);
                            stringBuf.append(wsdlSoapAddress.substring(this.guessWebProjectURL.length()));
                            soapAddress.setLocationURI(stringBuf.toString());
                            modified = true;
                        }
                    }
                }
                if (modified) {
                    super.getEnvironment();
                    WSDLCopier wsdlCopier = new WSDLCopier(this.wSParser);
                    wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)this.wsdlURI), definition);
                    if (this.originalWSDLDestination != null) {
                        wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.originalWSDLDestination)));
                        wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.originalWSDLDestination));
                    } else {
                        wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)this.wsdlURI)));
                        wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)this.wsdlURI));
                    }
                    IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
                    if (status != null && status.getSeverity() == 4) {
                        System.err.println(status.getMessage());
                    }
                    try {
                        IResource wsdlFile = ResourceUtils.findResource((IPath)filePath);
                        wsdlFile.refreshLocal(0, null);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {}
        return Status.OK_STATUS;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerInstanceId(String serverId) {
        this.serverInstanceId = serverId;
    }

    public void setWebProject(IProject webProject) {
        this.webProject = webProject;
    }

    public void setGuessWebProjectURL(String guessWebProjectURL) {
        this.guessWebProjectURL = guessWebProjectURL;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWSParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public void setOriginalWSDLDestination(String originalWSDLDestination) {
        this.originalWSDLDestination = originalWSDLDestination;
    }
}

