/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CopyGeneratedJavaFilesCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam;
    private ResourceContext resCtx_;
    private final int DOT_JAVA_EXTENSION_LENGTH = ".java".length();
    private String tmpRootDir;
    private IPath outputPath;
    boolean isDebugEnabled = Platform.inDebugMode() && "true".equals(Platform.getDebugOption((String)"com.ibm.ast.ws.creation.ui/debug"));

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.javaWSDLParam.getTempJavaOutput() == null) {
            return Status.OK_STATUS;
        }
        IEnvironment env = super.getEnvironment();
        this.resCtx_ = this.getResourceContext(env);
        String javaOutputPath = this.javaWSDLParam.getDevelopServerJavaOutput() != null ? this.javaWSDLParam.getDevelopServerJavaOutput() : this.javaWSDLParam.getJavaOutput();
        this.outputPath = new Path(PlatformUtils.getPathFromPlatform((String)javaOutputPath));
        this.tmpRootDir = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempJavaOutput());
        File sourceDir = new File(this.tmpRootDir);
        com.ibm.etools.webservice.was.consumption.command.CopyGeneratedJavaFilesCommand copyCmd = new com.ibm.etools.webservice.was.consumption.command.CopyGeneratedJavaFilesCommand();
        copyCmd.setEnvironment(env);
        copyCmd.setTargetPath(javaOutputPath);
        copyCmd.setSourceDir(sourceDir);
        IStatus copyCmdStatus = copyCmd.execute(monitor, info);
        if (copyCmdStatus.getSeverity() == 4) {
            return copyCmdStatus;
        }
        return copyCmdStatus;
    }

    private final ResourceContext getResourceContext(IEnvironment env) {
        return ((BaseEclipseEnvironment)env).getResourceContext();
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    private IStatus overwriteResource(File tempFile, IPath tmpPath, IProgressMonitor monitor, IStatusHandler handler) {
        try {
            FileInputStream fis = new FileInputStream(tempFile);
            IFile javaFile = FileResourceUtils.createFile((ResourceContext)this.resCtx_, (IPath)tmpPath, (InputStream)fis, (IProgressMonitor)monitor, (IStatusHandler)handler);
            fis.close();
            if (javaFile == null) {
                return StatusUtils.errorStatus((String)"");
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus processGeneratedFiles(File directory, int tempDirPrefixPos, IProgressMonitor monitor, IStatusHandler handler) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                IStatus retStatus = this.processGeneratedFiles(files[i], tempDirPrefixPos, monitor, handler);
                if (retStatus.getSeverity() != 0) {
                    return retStatus;
                }
            } else {
                IStatus retStatus;
                String filePath = files[i].getAbsolutePath();
                String curFile = filePath.substring(this.tmpRootDir.length());
                IPath targetFilePath = this.outputPath.append(curFile);
                if (this.isDebugEnabled) {
                    System.out.println("com.ibm.ast.ws.creation.ui: copying " + filePath + " to " + targetFilePath);
                }
                if ((retStatus = this.overwriteResource(files[i], targetFilePath, monitor, handler)).getSeverity() != 0) {
                    return retStatus;
                }
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    class CopyJavaFileOperation
    extends WorkspaceModifyOperation {
        private File rootDir;
        private IStatusHandler handler;
        private IStatus status;

        CopyJavaFileOperation(File dir, IStatusHandler hdler) {
            this.rootDir = dir;
            this.handler = hdler;
        }

        protected void execute(IProgressMonitor monitor) {
            this.status = CopyGeneratedJavaFilesCommand.this.processGeneratedFiles(this.rootDir, 0, monitor, this.handler);
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

