/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ui.command;

import com.ibm.ast.ws.creation.ui.messages.Messages;
import com.ibm.etools.webservice.was.consumption.ui.plugin.WebServiceWasConsumptionUIPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddIBMWebServicesSecurityDSIGandENCC
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private final String IBM_WEBSERVICES_BND_XMI = "ibm-webservices-bnd.xmi";
    private final String IBM_WEBSERVICES_EXT_XMI = "ibm-webservices-ext.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    private static final byte SECURITY_CONFIG = 3;
    private EList wsDescriptions = null;
    private String routerModule = null;
    IPath ibmWebServicesXMLPath = null;
    IPath ibmWebServicesBndXMIPath = null;
    IPath ibmWebServicesExtXMIPath = null;
    private String eJBProjectName;
    private IProject serviceProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getSecurityConfig() != 3) {
            return status;
        }
        if (this.javaWSDLParam.getJ2eeLevel().equals("1.4")) {
            this.copyTemplateToTempDirectory("/samples/BasicSigEnc/ibm-webservices-bnd.xmi", "ibm-webservices-bnd.xmi", status, env, monitor);
            this.copyTemplateToTempDirectory("/samples/BasicSigEnc/ibm-webservices-ext.xmi", "ibm-webservices-ext.xmi", status, env, monitor);
        }
        return status;
    }

    private void copyTemplateToTempDirectory(String source, String fileName, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        try {
            String inputLine;
            String tempDir = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
            File file = new File(String.valueOf(tempDir) + "sec");
            if (!file.exists()) {
                file.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(tempDir) + "sec" + File.separator + fileName);
            DataInputStream is = new DataInputStream(WebServiceWasConsumptionUIPlugin.getInstance().getBundle().getEntry(source).openStream());
            while ((inputLine = is.readLine()) != null) {
                fw.write(inputLine);
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void getNamesFromWebServicesXML(IProject ddProject) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            this.wsDescriptions = webservices.getWebServiceDescriptions();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtDSIG6(IProject ddProject) {
        WsextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ddProject);
            WsExtension wsext = artifactEdit.getWsExtension();
            EList wsDescExts = wsext.getWsDescExt();
            WsDescExt wsDescExt = (WsDescExt)wsDescExts.get(0);
            wsDescExt.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(0)).getWebServiceDescriptionName());
            EList portComponents = ((WebServiceDescription)this.wsDescriptions.get(0)).getPortComponents();
            EList pcBnds = wsDescExt.getPcBinding();
            PcBinding pcBinding = (PcBinding)pcBnds.get(0);
            pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
            int p = 1;
            while (p < portComponents.size()) {
                EObject newPcBinding = EcoreUtil.copy((EObject)pcBinding);
                ((PcBinding)newPcBinding).setPcNameLink(((PortComponent)portComponents.get(p)).getPortComponentName());
                wsDescExt.getPcBinding().add((Object)newPcBinding);
                ++p;
            }
            int ws = 1;
            while (ws < this.wsDescriptions.size()) {
                WsDescExt newWsDescExt = (WsDescExt)EcoreUtil.copy((EObject)wsDescExt);
                newWsDescExt.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(ws)).getWebServiceDescriptionName());
                portComponents = ((WebServiceDescription)this.wsDescriptions.get(ws)).getPortComponents();
                pcBnds = newWsDescExt.getPcBinding();
                pcBinding = (PcBinding)pcBnds.get(0);
                pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
                int p2 = 1;
                while (p2 < portComponents.size()) {
                    EObject newPcBinding = EcoreUtil.copy((EObject)pcBinding);
                    ((PcBinding)newPcBinding).setPcNameLink(((PortComponent)portComponents.get(p2)).getPortComponentName());
                    newWsDescExt.getPcBinding().add((Object)newPcBinding);
                    ++p2;
                }
                wsext.getWsDescExt().add((Object)newWsDescExt);
                ++ws;
            }
            wsext.setRouterModuleName(this.routerModule);
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsBndDSIG6(IProject ddProject) {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ddProject);
            WSBinding wsbnd = artifactEdit.getWSBinding();
            EList wscbindings = wsbnd.getWsdescBindings();
            WSDescBinding wsDescBinding = (WSDescBinding)wscbindings.get(0);
            wsDescBinding.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(0)).getWebServiceDescriptionName());
            EList portComponents = ((WebServiceDescription)this.wsDescriptions.get(0)).getPortComponents();
            EList pcBindings = wsDescBinding.getPcBindings();
            PCBinding pcBinding = (PCBinding)pcBindings.get(0);
            pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
            int p = 1;
            while (p < portComponents.size()) {
                EObject newPCBinding = EcoreUtil.copy((EObject)pcBinding);
                ((PCBinding)newPCBinding).setPcNameLink(((PortComponent)portComponents.get(p)).getPortComponentName());
                wsDescBinding.getPcBindings().add((Object)newPCBinding);
                ++p;
            }
            int ws = 1;
            while (ws < this.wsDescriptions.size()) {
                WSDescBinding newWsDescBinding = (WSDescBinding)EcoreUtil.copy((EObject)wsDescBinding);
                newWsDescBinding.setWsDescNameLink(((WebServiceDescription)this.wsDescriptions.get(ws)).getWebServiceDescriptionName());
                portComponents = ((WebServiceDescription)this.wsDescriptions.get(ws)).getPortComponents();
                pcBindings = newWsDescBinding.getPcBindings();
                pcBinding = (PCBinding)pcBindings.get(0);
                pcBinding.setPcNameLink(((PortComponent)portComponents.get(0)).getPortComponentName());
                int p2 = 1;
                while (p2 < portComponents.size()) {
                    EObject newPCBinding = EcoreUtil.copy((EObject)pcBinding);
                    ((PCBinding)newPCBinding).setPcNameLink(((PortComponent)portComponents.get(p2)).getPortComponentName());
                    newWsDescBinding.getPcBindings().add((Object)newPCBinding);
                    ++p2;
                }
                wsbnd.getWsdescBindings().add((Object)newWsDescBinding);
                ++ws;
            }
            artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void copyTemplateFromBundle(String source, IPath target, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        try {
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)WebServiceWasConsumptionUIPlugin.getInstance().getBundle().getEntry(source).openStream(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_FILECOPY, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.ibmWebServicesXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservices-bnd.xmi")).exists()) {
            this.ibmWebServicesBndXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile("ibm-webservices-ext.xmi")).exists()) {
            this.ibmWebServicesExtXMIPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }
}

